package com.docomo_um.module.location;

/**
 *現在位置提供を開始した時のイベントを受け取るリスナクラスです。
 *
 */
public interface ProviderLocationListener {
	/**
	 *<p>
	 *現在位置提供を開始した場合に呼ばれます。
	 *通知される測位状態は緊急通報時の位置提供中のみになります。
	 *</p>
	 *@param status このリスナが呼び出された時の測位状態が設定されています。
	 *
	 *@see LocationProvider#STATUS_EMERGENCY
	 */
	void onProvideLocationStarted(int status);
}
