package com.docomo_um.module.location;

import com.docomo_um.win.Logging;

/**
 * 現在地の測位などの失敗が原因で発生する例外クラスです。
 */
public class LocationException extends Exception {
	private int status;
	/**
	 * ステータスが未定義であることを示します。
	 */
	public static final int UNDEFINED = 0;

	/**
	 * 例外の原因を示すステータスの一つで、現在位置取得に失敗したことを表します。
	 */
	public static final int POSITIONING_FAILURE = 1;

	/**
	 * 例外の原因を示すステータスの一つで、タイムアウトにより現在位置取得に失敗したことを表します。
	 */
	public static final int TIMEOUT = 2;

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定しないでインスタンスを生成します。
	 * ステータス値は、{@link #UNDEFINED}に設定されます。
	 */
	public LocationException() {
		this(UNDEFINED);
	}

	/**
	 * 例外の原因を示すステータス値を設定してインスタンスを生成します。
	 * @param status 例外のステータスを指定します。
	 */
	public LocationException(int status) {
		this(status, null);
	}

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定してインスタンスを生成します。
	 * @param status 例外のステータスを指定します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public LocationException(int status, String msg) {
		super(msg);
		this.status = status;
		Logging.getInstance().putMethod(this, "LocationException", String.valueOf(status), msg);
	}

	/**
	 * 例外の原因を示すステータス値を取得します。
	 *
	 * @return 例外の原因を示すステータス値を返します。
	 */
	public int getStatus() {
		Logging.getInstance().putMethod(this, "getStatus");
		return status;
	}

}
