package com.docomo_um.module.connection;

/**
 * シリアルデバイスの状態変化をイベント通知するリスナクラスです。
 */
public interface SerialListener {

	/**
	 * シリアルデバイスがデータを受信した場合に呼び出されます。
	 * 
	 * @param serial データを受信したシリアルデバイスのインスタンスが設定されます。
	 */
	public void onReceived(Serial serial);


	/**
	 * <p>
	 * ER信号の状態が変化した場合に呼び出されます。 
	 * その場合、引数serialにはER信号の状態が変化したシリアルデバイスのインスタンスが設定されます。 
	 * </p>
	 * 
	 * <p>
	 * また、シリアルデバイスのインスタンスにリスナが登録されていない状態で、このリスナを設定した場合にも呼び出されます。 
	 * その場合、引数serialにはリスナを設定したシリアルデバイスのインスタンスが設定されます。 
	 * </p>
	 * 
	 * <p>
	 * 引数erの値がtrueの場合、接続先のシリアルデバイスが通信可能であることを示します。
	 * falseの場合、接続先のシリアルデバイスが通信不可であり、false受信以降は通信が出来ません。
	 * </p>
	 * 
	 * @param serial シリアルデバイスのインスタンスが設定されます。
	 * @param er 接続先のシリアルデバイスが通信可能であることを示す場合はtrueを、通信不可であることを示す場合はfalseが設定されます。
	 */
	public void onChangedERStatus(Serial serial, boolean er);

}
