package com.docomo_um.module.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.co.aplix.extra.util.HexUtil;

public class SPIFunctions {
	private static SPIListener spiListener = null;
	private static SPICommCombinedThread combinedThread = null;
	private static SPICommFullduplexThread fullduplexThread = null;
	private static SPIDevice spiDevice = null;
	static boolean busy = false;
	static Object lockObj = new Object();

	static SPIInputStream is = null;
	static SPIOutputStream os = null;
	static boolean started = false;
	static boolean interrupted = false;
	/**
	 * 終了処理
	 */
	public static void finalize() {
		try {
			if (is != null) {
				is.close();
			}
			if (os != null) {
				os.close();
			}
		} catch (IOException e) {
		}
	}
	/**
	 * デバイスの登録
	 * @param dev
	 */
	public static void setSPIDevice(SPIDevice dev) {
		spiDevice = dev;
		is = new SPIInputStream();
		os = new SPIOutputStream();
	}
	/**
	 * シスナの登録
	 * @param listener
	 * @throws ConnectionException
	 */
	public static void setSPIListener(SPIListener listener) throws ConnectionException {
		spiListener = listener;
	}
	/**
	 * 通信開始処理
	 */
	public static void start() {
		if (!started) {
			started = true;
			if ((spiListener != null) && (spiDevice != null)) {
				spiListener.onChangedStatus(spiDevice, true);
			}
		}
	}
	/**
	 * 通信停止処理
	 */
	public static void stop() {
		if (started) {
			started = false;
			if ((spiListener != null) && (spiDevice != null)) {
				spiListener.onChangedStatus(spiDevice, false);
			}
			interrupted = true;
			if (fullduplexThread != null) {
				fullduplexThread.interrupt();
			}
			if (combinedThread != null) {
				combinedThread.interrupt();
			}
		}
	}
	/**
	 * 通信開始状態の取得
	 * @return
	 */
	public static boolean isStarted() {
		return started;
	}

	/**
	 * 同時にデータを送受信
	 * @param write
	 * @return
	 * @throws IOException
	 * @throws ConnectionException
	 */
	public static byte[] sendFullduplexFormat(byte[] write) throws IOException, ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		synchronized (lockObj) {
			if (busy) {
				throw new IllegalStateException();
			}
			busy = true;
		}
		interrupted = false;
		fullduplexThread = new SPICommFullduplexThread(write);
		fullduplexThread.start();
		try {
			fullduplexThread.join();
		} catch (InterruptedException e) {
			throw new IOException();
		}
		finally {
			synchronized (lockObj) {
				busy = false;
			}
		}
		if (interrupted) {
			throw new IOException();
		}
		return fullduplexThread.getReceivedData();
	}

	/**
	 * 連続したデータの送受信
	 * @param data
	 * @return
	 * @throws IOException
	 * @throws ConnectionException
	 */
	public static SPICombinedFormatData[] sendCombinedFormat(SPICombinedFormatData[] data)  throws IOException, ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		synchronized (lockObj) {
			if (busy) {
				throw new IllegalStateException();
			}
			busy = true;
		}

		interrupted = false;
		combinedThread = new SPICommCombinedThread(data);
		combinedThread.start();
		try {
			combinedThread.join();
		} catch (InterruptedException e) {
			throw new IOException();
		}
		finally {
			synchronized (lockObj) {
				busy = false;
			}
		}
		if (interrupted) {
			throw new IOException();
		}
		return combinedThread.getReceivedData();
	}
	/**
	 * 通信の中断処理
	 * @throws IOException
	 * @throws ConnectionException
	 */
	public static void interrupt() throws IOException, ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		if (combinedThread != null) {
			interrupted = true;
			combinedThread.interrupt();
		}
	}

	/**
	 * SPI送受信スレッドクラス
	 */
	static class SPICommFullduplexThread extends Thread {
		byte[] data;
		byte[] recvData;
		SPICommFullduplexThread(byte[] data) {
			this.data = data;
			recvData = new byte[data.length];
		}
		public byte[] getReceivedData() {
			return recvData;
		}
		@Override
		public void run() {
			try {
				os.write(data);
				if (interrupted) {
					return;
				}
				is.read(recvData);
			} catch (IOException e) {
			}
		}
	}
	/**
	 * SPI送受信スレッドクラス
	 */
	static class SPICommCombinedThread extends Thread {
		SPICombinedFormatData[] data;
		SPICombinedFormatData[] recvData = null;
		/**
		 * コンストラクタ
		 * @param data
		 */
		SPICommCombinedThread(SPICombinedFormatData[] data) {
			super();
			int count = 0;
			this.data = data;
			for (int i = 0; i < data.length; i++) {
				if (data[i].getProcessingType() == SPICombinedFormatData.TYPE_READ) {
					count++;
				}
			}
			if (count > 0) {
				recvData = new SPICombinedFormatData[count];
			}
			else {
				recvData = null;
			}
		}
		/**
		 * 受信データの取得
		 * @return
		 */
		public SPICombinedFormatData[] getReceivedData() {
			return recvData;
		}
		@Override
		public void run() {
			int count = 0;
			try {
				for (int i = 0; i < data.length; i++) {
					if (interrupted) {
						break;
					}
					if (data[i].getProcessingType() == SPICombinedFormatData.TYPE_READ) {
						// 受信
						byte[] buf = new byte[data[i].getTransmissionData().length];
						is.read(buf);
						recvData[count] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf);
						count++;
					} else {
						// 送信
						os.write(data[i].getTransmissionData());
					}
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	/**
	 * SPI出力ストリームクラス
	 */
	static class SPIOutputStream extends OutputStream {
		FileOutputStream fos = null;
		SPIOutputStream() {
			File f = new File(ConnectionProperties.getInstance().getSPIOutputFile());
			try {
				if (!f.exists()) {
					f.createNewFile();
				}
				fos = new FileOutputStream(ConnectionProperties.getInstance().getSPIOutputFile());
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}

		}
		@Override
		public void write(int b) throws IOException {
			String buf = HexUtil.toHexStringUpper((byte)b);
			fos.write(buf.getBytes());
		}
		@Override
		public void close() throws IOException {
			fos.close();
		}
	}
	/**
	 * SPI入力ストリームクラス
	 */
	static class SPIInputStream extends InputStream {
		FileInputStream fis = null;
		SPIInputStream() {
			try {
				fis = new FileInputStream(ConnectionProperties.getInstance().getSPIInputFile());
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}
		private int read4bit() throws IOException, InterruptedException {
			int data = -1;
			while (true) {
				if (started) {
					if (interrupted) {
						break;
					}
					data = fis.read();
					if (data >= '0' && data <= '9') {
						data -= '0';
						break;
					}
					else if (data >= 'A' && data <= 'F') {
						data -= 'A';
						data += 10;
						break;
					}
					else if (data >= 'a' && data <= 'f') {
						data -= 'a';
						data += 10;
						break;
					}
				}
				Thread.sleep(200);
			}
			return data;
		}
		@Override
		public int read() throws IOException {
			if (fis == null) {
				return -1;
			}
			int h = 0;
			int l = 0;
			try {
				h = read4bit();
				l = read4bit();
			} catch (InterruptedException e) {
				return -1;
			}
			return ((h << 4) | l);
		}
		@Override
		public void close() throws IOException {
			if (fis != null) {
				fis.close();
			}
		}
	}
}
