package com.docomo_um.module.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.docomo_um.win.Logging;

public class I2CMasterImpl extends I2CMaster {
	/** I2C情報 */
	private I2CSpec spec;
	/** 通信速度 */
	private long speed;
	/** スレーブアドレス */
	private int slaveAddress;
	/** 通信開始フラグ */
	private boolean bStart;
	/** 入力ストリーム */
	InputStream inputStream = null;
	/** 出力ストリーム */
	OutputStream outputStream = null;

	I2CMasterImpl(I2CSpec spec, int slaveaddr) {
		super();
		this.spec = spec;
		slaveAddress = slaveaddr;
	}
	@Override
	public void start() {
		Logging.getInstance().putMethod(this, "start");
		bStart = true;
		return;
	}
	@Override
	public void stop() {
		Logging.getInstance().putMethod(this, "stop");
		bStart = false;
		return;
	}
	@Override
	public void setCommSpeed(long speed) {
		Logging.getInstance().putMethod(this, "setCommSpeed", String.valueOf(speed));
		for (int i = 0; i < spec.getCommSpeedList().size(); i++) {
//			System.out.println("setCommSpeed: " + String.valueOf(speed) + ", " + String.valueOf(spec.getCommSpeedList().get(i)));
			if (speed == spec.getCommSpeedList().get(i)) {
				this.speed = speed;
				return;
			}
		}
		throw new IllegalArgumentException();
	}
	@Override
	public OutputStream getOutputStream() {
		Logging.getInstance().putMethod(this, "getOutputStream");
		if (!bStart) {
			throw new IllegalStateException();
		}
		if (outputStream == null) {
			outputStream = I2CStream.getInstance().getOutputStream(slaveAddress);
		}
		return outputStream;
	}
	@Override
	public InputStream getInputStream() {
		Logging.getInstance().putMethod(this, "getInputStream");
		if (!bStart) {
			throw new IllegalStateException();
		}
		if (inputStream == null) {
			inputStream = I2CStream.getInstance().getInputStream(slaveAddress);
		}
		return inputStream;
	}
	@Override
	public byte[] sendCombinedFormat(byte[] write, int bufferSize) throws IOException {
		Logging.getInstance().putMethod(this, "sendCombinedFormat", "byte[" + write.length + "]", String.valueOf(bufferSize));
		if (!bStart) {
			throw new IllegalStateException();
		}
		if (bufferSize <= 0) {
			throw new IllegalArgumentException();
		}
		byte[] readbuf = new byte[bufferSize];
		if (inputStream == null) {
			inputStream = I2CStream.getInstance().getInputStream(slaveAddress);
		}
		if (outputStream == null) {
			outputStream = I2CStream.getInstance().getOutputStream(slaveAddress);
		}
		outputStream.write(write);
		inputStream.read(readbuf);
		return readbuf;
	}

	/**
	 * スレーブアドレスの取得（PCSDK固有）
	 * @return
	 */
	public int getSlaveAddress() {
		return slaveAddress;
	}
	public long getSpeed() {
		return speed;
	}
}
