package com.docomo_um.module.connection;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * I2Cのマスタとスレーブの抽象クラスです。
 */
public abstract class I2CDevice {

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	I2CDevice() {
		
	}
	
	/**
	 * 出力ストリームを取得します。
	 * @return 出力ストリームを返します。
	 */
	public abstract OutputStream getOutputStream();

	/**
	 * 入力ストリームを取得します。
	 * @return 入力ストリームを返します。
	 */	
	public abstract InputStream getInputStream();
}
