package com.docomo_um.module.connection;

/**
 * 汎用入力ポート状態変化のイベントを受信するリスナクラスです。
 * @see GPIOConnection
 */
public interface GPIOListener {

	/**
	 * 汎用入力ポートの状態が変化した場合に呼び出されます。
	 *
	 * @param port 変化のあった入力ポート番号が設定されます。
	 * @param signal 入力ポートがHighの場合はtrueが、Lowの場合はfalseが設定されます。
	 */
	public void onChangedStatus(int port, boolean signal);
}
