package com.docomo_um.module.connection;

import java.util.ArrayList;
import java.util.List;

public class ADConverterFunctions {
	/** チャネルリスト */
	private static List<ADChannel> chList;
	/** 各チャネルのAD変換値 */
	private static int[] chValue;
	public static void initADConverter(List<ADChannel> list) {
		chList = list;
		chValue = new int[chList.size()];
	}
	public static List<ADChannel> getChannelList() {
		List<ADChannel> list = new ArrayList<ADChannel>();
		for (int i = 0; i < chList.size(); i++) {
			ADChannel ch = chList.get(i);
			list.add(new ADChannel(ch.getChannelName(), ch.getResolution()));
		}
		return list;
	}
	public static int getAD(ADChannel ch) throws ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		for (int i = 0; i < chList.size(); i++) {
			if (ch.getChannelName().equals(chList.get(i).getChannelName())) {
				return chValue[i];
			}
		}
		return 0;
	}
	/**
	 * AD変換値をセットします。（PCSDK固有）
	 * @param no
	 * @param value
	 */
	public static void setAD(int no, int value) {
		if (no < 0 || no > chList.size()) {
			return;
		}
		chValue[no] = value;
	}
}
