package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * 規制による通信失敗が原因で発生する例外クラスです。
 */
public class RegulationException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。 
	 */
	public RegulationException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 * 
	 * @param msg 詳細メッセージを指定します。
	 */
	public RegulationException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "RegulationException", msg);
	}
}
