package com.docomo_um.module;

/**
 *モジュールの状態を通知するリスナクラスです。
 *
 */
public interface ModuleListener {

	/**
	 * システムアップデートの中止理由の一つで、更新不要を表します。
	 * @see #onSystemUpdateAbort(int)
	 */
	public static final int STATUS_NO_UPDATE = 0;
	/**
	 * システムアップデートの中止理由の一つで、ダウンロード失敗を表します。
	 * @see #onSystemUpdateAbort(int)
	 */
	public static final int STATUS_DOWNLOAD_FAILURE = 1;

	/**
	 *システムがリセットを要求した場合にコールされます。
	 *<p>
	 *本リスナがコールされたら、{@link ModuleManager#reset()} メソッドをコールして下さい。
	 *{@link ModuleManager#reset()} メソッドがコールされると、システムはリセット処理を開始します。
	 *システムがリセットされると、不揮発メモリに保存していないデータは削除されます。<br>
	 *尚、本リスナがコールされてから10秒経過しても{@link ModuleManager#reset()}メソッドがコールされない場合、
	 *システムは自動的にリセット処理を開始します。
	 *</p>
	 *<p>
	 *システムアップデートにおいて、ダウンロードが完了した場合にも、本リスナはコールされます。
	 *ダウンロードが完了する前に以下のいずれかの機能を開始していた場合、当該機能が完了するまで本リスナはコールされません。
	 *<ul>
	 *<li>音声通信</li>
	 *<li>現在位置取得</li>
	 *<li>緊急通報時の位置提供</li>
	 *<li>SMSメッセージ送信</li>
	 *</ul>
	 *</p>
	 *@see ModuleManager#reset()
	 */
	public void onReset();

	/**
	 *システムアップデートをシステムが要求した場合にコールされます。
	 *<p>
	 *本リスナがコールされたら、{@link ModuleManager#updateSystem()} メソッドをコールして下さい。
	 *{@link ModuleManager#updateSystem()} メソッドがコールされると、システムアップデートを開始します。<br>
	 *尚、本リスナがコールされてから5秒経過しても{@link ModuleManager#updateSystem()}メソッドがコールされない場合、
	 *自動的にシステムアップデートが開始されます。<br>
	 *システムアップデート要求が発生する前に音声通信を開始していた場合であっても、本リスナはコールされます。<br>
	 *システムアップデート要求が発生する前にパケット通信を開始していた場合、パケット通信を切断して本リスナがコールされます。<br>
	 *本リスナがコールされると、システムアップデートが完了するまでパケット通信を実行することはできません。音声通信は実行することができます。<br>
	 *</p>
	 *@see ModuleManager#updateSystem()
	 */
	public void onSystemUpdate();

	/**
	 *システムアップデートを継続できない場合にコールされます。
	 *<p>
	 *更新不要やダウンロード失敗など、システムアップデートが中断した場合にコールされます。
	 *ただし、{@link ModuleManager#cancelSystemUpdate()}によってシステムアップデートをキャンセルした場合はコールされません。
	 *</p>
	 *@param abortStatus システムアップデートの中断理由が設定されます。
	 *@see ModuleManager#updateSystem()
	 *@see #STATUS_NO_UPDATE
	 *@see #STATUS_DOWNLOAD_FAILURE
	 */
	public void onSystemUpdateAbort(int abortStatus);
}
