package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * アプリケーションを表すクラスです。
 *
 * @see ModuleManager#getApplicationList()
 * @see ModuleManager#changeApplication(Application)
 */
public final class Application {

	/** アプリケーション名 */
	private String applicationName;

	/** アプリケーション領域名 */
	private String areaName;

	/**
	 *アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 * @param name 名称を指定します。
	 * @param applicationAreaName アプリケーション領域名を指定します。
	 */
	Application(String name, String applicationAreaName) {
		applicationName = name;
		areaName = applicationAreaName;
	}

	/**
	 * 名称を取得します。
	 * @return 名称を返します。
	 */
	public String getName() {
		Logging.getInstance().putMethod(this, "getName");
		return applicationName;
	}

	/**
	 * アプリケーション領域名を取得します。
	 * @return アプリケーション領域名を返します。
	 */
	public String getApplicationAreaName() {
		Logging.getInstance().putMethod(this, "getApplicationAreaName");
		return areaName;
	}
}

