package com.docomo_um.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.docomo_um.win.SDKProperties;

/**
 * IO関連のプロパティを管理するクラス（PCSDK固有）
 *
 * <p>
 * プロパティファイル（io.pro）からIO関連のプロパティを読み出し、保持します。
 * </p>
 */
public class IOProperties {
	/** 自身のインスタンス */
	private static IOProperties instanceIOProperties = null;

	/** 設定ファイルファイル名 */
	private static String filename = "/nano/properties/io.pro";

	/** FFSファイルを格納するディレクトリ */
	private static String FFSDir = "./";

	/** ダウンロード領域として使用するファイルを格納するディレクトリ */
	private static String DLDir  = "./";

	/** アプリケーション領域として使用するファイルを格納するディレクトリ */
	private static String AppDir = "./";

	/** NVM領域として使用するファイルを格納するディレクトリ */
	private static String NVMDir = "./";

	/** NVMのサイズ */
	private static int nvmSize = 1024;

	/** LoadableModuleExceptionの発生の有無 */
	private boolean loadableModuleException;

	/** LoadableModuleExceptionの要因 */
	private int loadableModuleExceptionCause;

	/**
	 * モジュール情報プロパティのインスタンスを取得
	 *
	 * @return モジュール情報プロパティのインスタンス
	 */
	synchronized public static IOProperties getInstance() {
		if (instanceIOProperties == null) {
			instanceIOProperties = new IOProperties();
		}
		return instanceIOProperties;
	}

	/**
	 * FFSファイルディレクトリを取得
	 * @return
	 */
	public String getFFSDir(){
		return FFSDir;
	}

	/**
	 * ダウンロード領域ディレクトリを取得
	 * @return
	 */
	public String getDLDir(){
		return DLDir;
	}

	/**
	 * アプリケーション領域ディレクトリを取得
	 * @return
	 */
	public String getAppDir(){
		return AppDir;
	}

	/**
	 * NVM領域ディレクトリを取得
	 * @return
	 */
	public String getNVMDir(){
		return NVMDir;
	}

	/**
	 * LoadableModuleExceptionの例外の有無を設定します。
	 * @param enable
	 * @param cause
	 */
	public void setLoadableModuleExcepiton(boolean enable, int cause) {
		loadableModuleException = enable;
		loadableModuleExceptionCause = cause;
	}

	/**
	 * LoadableModuleExceptionの例外の有無を取得します。
	 */
	public boolean getLoadableModuleException() {
		return loadableModuleException;
	}

	/**
	 * LoadableModuleExceptionの例外の要因を取得します。
	 */
	public int getLoadableModuleExceptionCause() {
		return loadableModuleExceptionCause;
	}
	/**
	 * NVMのサイズを取得します。
	 * @return
	 */
	public int getNVMSize() {
		return nvmSize;
	}
	/**
	 * コンストラクタ
	 */
	private IOProperties() {
		try {
			this.getFileProperties();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * ファイルからプロパティを取得
	 */
	private void getFileProperties() throws IOException{
		InputStream is;

		try {
			is = new FileInputStream(filename);
		} catch (FileNotFoundException e) {
			return;
		}

		SDKProperties pro = new SDKProperties();
		pro.load(is);

		//FFSDir
		FFSDir = pro.getProperty("FFSDIR", "./");
		if (FFSDir.charAt(FFSDir.length() - 1) != '/') {
			FFSDir += "/";
		}

		//DLDir
		DLDir = pro.getProperty("DLDIR", "./");
		if (DLDir.charAt(DLDir.length() - 1) != '/') {
			DLDir += "/";
		}

		//AppDir
		AppDir = pro.getProperty("APPDIR", "./");
		if (AppDir.charAt(AppDir.length() - 1) != '/') {
			AppDir += "/";
		}

		//NVMDir
		NVMDir = pro.getProperty("NVMDIR", "./");
		if (NVMDir.charAt(NVMDir.length() - 1) != '/') {
			NVMDir += "/";
		}

		String strBuf;
		strBuf = pro.getProperty("NVMSIZE", "1024");
		nvmSize = Integer.valueOf(strBuf);
	}
}
