package com.docomo_um.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.win.Logging;


/**
 * FFSファイルの情報を表すクラスです。
 */
public final class FFSFile {

	/** FFSファイルのファイル名 */
	private String pathName;

	/**
	 *アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 *@param pathname ファイル名を指定します。
	 */
	FFSFile(String pathname){
		pathName = pathname;
	}

	/**
	 *ファイル名を取得します。
	 *
	 *@return ファイル名を返します。
	 */
	public String getName() {
		Logging.getInstance().putMethod(this, "getName");
		Logging.getInstance().putMethodMessage(this, "getName", "name = " + pathName);
		return pathName;
	}

	/**
	 *ファイルサイズ(byte)を取得します。
	 *
	 *@return ファイルサイズ(byte)を返します。
	 *
	 * @throws IOException ファイルサイズ取得に失敗した場合に発生します。
	 */
	public long length() throws IOException {
		String dir = "";
		Logging.getInstance().putMethod(this, "length");
		if (ConnectionProperties.getInstance().getIOException()) {
			throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		if (pathName.equals("dltemp.cap")) {
			dir = IOProperties.getInstance().getDLDir();
		} else {
			dir = IOProperties.getInstance().getFFSDir();
		}
		File file = new File(dir + pathName);
		if (file.exists()) {
			RandomAccessFile f = new RandomAccessFile(dir + pathName,"r");
			long length = f.length();
			f.close();
			return length;
		}
		Logging.getInstance().putMethodMessage(this, "length", pathName + " is not found.");
		return 0;
	}
}
