package jp.co.aplix.avm.pluginbase;
/*
 * Copyright 2010 Aplix Corporation. All rights reserved.
 */
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;

import jp.co.aplix.avm.AppendResource;
import jp.co.aplix.avm.LoadableModule;
import jp.co.aplix.avm.LoadableModuleException;

public final class PluginLoader {
	private static String capfile;
	private static final int BUFFSIZE = 512;
	private static final boolean DEBUG = false;
	private static AppendResource ar = null;
	private static Object lockObj = new Object();
	private static boolean fBusy = false;
	
	
	public PluginLoader(String capfile) {
		synchronized (lockObj) {
			if (capfile == null) {
				throw new IllegalStateException("already active");
			}
		}
		PluginLoader.capfile = capfile;
	}
	
	public static AppendResource getAppendResource() {
		synchronized (lockObj) {
			return ar;
		}
	}
	
	public void dispose() {
		synchronized (lockObj) {
			if (fBusy) {
				throw new IllegalStateException("application is still running.");
			}
			capfile = null;
			ar = null;
		}
	}
	
	public void start() {
		synchronized (lockObj) {
			if (fBusy) {
				throw new IllegalStateException("application is already stated.");
			}
			if (capfile == null) {
				throw new IllegalStateException("application is already finished.");
			}
			fBusy = true;
		}
		try {
			// load file to bytearray
			byte[] ba;
			try {
				ba = xGetFileBytes(capfile);
			} catch (IOException e) {
				if (DEBUG) {
					e.printStackTrace();
				}
				throw new RuntimeException("read error in " + capfile);
			}
			
			int balen = ba.length;
			if (balen < 8) {
				throw new RuntimeException("bad length, file:" + capfile);
			}
			int caplen = (ba[4] << 24) | ((ba[5] & 0xFF) << 16) | ((ba[6] & 0xFF) <<  8) | (ba[7] & 0xFF);
			if (caplen > balen) {
				throw new RuntimeException("bad length, file:" + capfile);
			}
//			System.out.println("byte array length:" + balen);
//			System.out.println("CAP length:" + caplen);
			if (caplen != balen) {
				int reslen = balen - caplen;
				byte[] res = new byte[reslen];
				System.arraycopy(ba, caplen, res, 0, reslen);
				byte[] newba = new byte[caplen];
				System.arraycopy(ba, 0, newba, 0, caplen);
				ba = newba;
				
				ar = new AppendResource(res);
			}
			
			
			
			// create LoadableModule from the bytearray.
			LoadableModule lm;
			try {
				lm = xCreateLoadableModule(ba);
			} catch (LoadableModuleException e) {
				if (DEBUG) {
					e.printStackTrace();
				}
				throw new RuntimeException("error in create LoadableModule instance from " + capfile);
			}
			
			// invoke entry method.
			try {
				try {
					if (DEBUG) {
						System.out.println("Calling invokeEntryMethod");
					}
					lm.invokeEntryMethod();
				} catch (LoadableModuleException e) {
					if (DEBUG) {
						e.printStackTrace();
					}
					try {
						if (DEBUG) {
							System.out.println("Calling createInstance");
						}
						Runnable r = (Runnable) lm.createInstance();
						Thread instance = new Thread(r);
						instance.start();
					} catch  (LoadableModuleException e2) {
						if (DEBUG) {
							e2.printStackTrace();
						}
						throw new RuntimeException("error in invokeEntryMethod & createInstance method.");
					}
				}
			} finally {
				try {
					lm.destroy();
				} catch (LoadableModuleException e) {
					if (DEBUG) {
						e.printStackTrace();
					}
				}
			}
		} finally {
			synchronized (lockObj) {
				fBusy = false;
			}
			dispose();
		}
	}
	
	private static LoadableModule xCreateLoadableModule(byte[] ba) throws LoadableModuleException {
		LoadableModule lm = new LoadableModule(ba);
		if (DEBUG) {
			System.out.println("Load CAP Success.");
			System.out.println("Name:" + lm.getModuleName());
			System.out.println("Vendor:" + lm.getMakerName());
			System.out.println("Version:" + lm.getVersion());
		}
		return lm;
	}

	private static byte[] xGetFileBytes(String capfile) throws IOException {
		FileInputStream is = new FileInputStream(capfile);
		try {
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			byte[] buff = new byte[BUFFSIZE];
			while (true) {
				int rdsz = is.read(buff);
				if (rdsz == -1) {
					break;
				}
				os.write(buff, 0, rdsz);
			}
			return os.toByteArray();
		} finally {
			is.close();
		}
	}
}
