import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.ModemController;
import com.docomo_um.module.net.ModemControllerListener;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.module.net.VoiceController;
import com.docomo_um.module.net.VoiceControllerListener;
import com.docomo_um.module.net.VoiceSession;


public class VoiceControllerTest {
	Session receivedSession;
	int sessionStatus;
	public void Test10_01() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_01_Listener());
		Session session = voice.createSession("0123");
		VoiceSession voiceSession = (VoiceSession)session;
		sessionStatus = session.getConnectedStatus();
		session.send();
		System.out.println("TEST10_01: call status = " + String.valueOf(voiceSession.getCallStatus()));
		System.out.println("TEST10_01: send 0123 ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_OUTGOING_CALL) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_01: CONNECTION_STATUS_OUTGOING_CALL");
		System.out.println("TEST10_01: Please receive on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		voice.setReceiverVolume(10);
		Session connected = voice.getConnectedSession();
		if (connected != null) {
			System.out.println("TEST10_01: call status = " + String.valueOf(voiceSession.getCallStatus()));
			System.out.println("TEST10_01: connected " + connected.getDestination());
		}
		else {
			throw new Exception("TEST10_01: fail");
		}
		System.out.println("TEST10_01: Please disconnect on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_DISCONNECT) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_01: disconnected 0123");
		System.out.println("TEST10_01: call status = " + String.valueOf(voiceSession.getCallStatus()));
		System.out.println("TEST10_01: pass");
	}
	private class Test10_01_Listener implements VoiceControllerListener {
		@Override
		public void onReceived(ModemController controller, Session session) {
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST10_01: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}

		@Override
		public void onReceivingGuidance(VoiceController controller,
				VoiceSession session) {
			System.out.println("Guidance");
		}

	}
	public void Test10_02() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		receivedSession = null;
		voice.setModemControllerListener(new Test10_02_Listener());
		System.out.println("TEST10_02: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		Thread.sleep(1000);
		VoiceSession voiceSession = (VoiceSession)voice.getConnectedSession();
		System.out.println("TEST10_02: call status = " + String.valueOf(voiceSession.getCallStatus()));
		System.out.println("TEST10_02: hold");
		voiceSession.hold();
		System.out.println("TEST10_02: call status = " + String.valueOf(voiceSession.getCallStatus()));
		if (voiceSession.getCallStatus() != VoiceSession.STATUS_HOLD) {
			throw new Exception("TEST10_02: fail");
		}
		System.out.println("TEST10_02: changeHoldStatus");
		voice.changeHoldStatus();
		if (voiceSession.getCallStatus() != VoiceSession.STATUS_TALKING) {
			throw new Exception("TEST10_02: fail");
		}
		voiceSession.sendDTMF("98765abc");
		int manner = voiceSession.getMannerModeType();
		System.out.println("TEST10_02: manner mode type = " + String.valueOf(manner));
		System.out.println("TEST10_02: disconnect");
		receivedSession.disconnect();
		while (receivedSession.getConnectedStatus() == Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_02: pass");
	}
	private class Test10_02_Listener implements ModemControllerListener {

		@Override
		public void onReceived(ModemController controller, Session session) {
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST10_02: onReceived " + session.getDestination());
			receivedSession = session;
			try {
				session.receive();
			} catch (SessionException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (CommunicationFailureException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (IllegalSettingException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST10_02: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}
	}
	public void Test10_03() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		int[] func = voice.getAvailableFunction();
		for (int i = 0; i < func.length; i++) {
			System.out.println("TEST10_03: func[" + String.valueOf(i) + "] = " + String.valueOf(func[i]));
		}
		int action = voice.getArrivalCallAction();
		System.out.println("TEST10_03: call action = " + String.valueOf(action));
		voice.setArrivalCallAction(VoiceController.ARRIVALCALL_ACTION_CALL_WAIT);
		action = voice.getArrivalCallAction();
		System.out.println("TEST10_03: call action = " + String.valueOf(action));
		if (action != VoiceController.ARRIVALCALL_ACTION_CALL_WAIT) {
			throw new Exception("TEST10_03: fail");
		}
		voice.setReceiverVolume(10);
		int volume = voice.getReceiverVolume();
		System.out.println("TEST10_03: Receiver volume = " + String.valueOf(volume));
		if (volume != 10) {
			throw new Exception("TEST10_03: fail");
		}
		voice.setDriveMode(true);
		boolean driveMode = voice.isDriveMode();
		System.out.println("TEST10_03: Drive mode = " + String.valueOf(driveMode));
		if (!driveMode) {
			throw new Exception("TEST10_03: fail");
		}
		voice.setEchoCanceller(true);
		boolean echoCanceller = voice.isEchoCanceller();
		System.out.println("TEST10_03: echo canceller = " + String.valueOf(echoCanceller));
		if (!echoCanceller) {
			throw new Exception("TEST10_03: fail");
		}
		voice.setNoiseCanceller(true);
		boolean noiseCanceller = voice.isNoiseCanceller();
		System.out.println("TEST10_03: noise canceller = " + String.valueOf(noiseCanceller));
		if (!noiseCanceller) {
			throw new Exception("TEST10_03: fail");
		}
		voice.setSenderVolumeMute(true);
		boolean mute = voice.isSenderVolumeMute();
		System.out.println("TEST10_03: sender volume mute = " + String.valueOf(mute));
		if (!mute) {
			throw new Exception("TEST10_03: fail");
		}
		System.out.println("TEST10_03: pass");
	}
	public void Test10_04() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_04_Listener());
		receivedSession = null;
		voice.setDriveMode(false);
		System.out.println("TEST10_04: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_04: redirect");
		((VoiceSession)receivedSession).redirect();

		receivedSession = null;
		System.out.println("TEST10_04: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_04: send answering");
		((VoiceSession)receivedSession).sendAnswering();

		receivedSession = null;
		System.out.println("TEST10_04: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_04: reject");
		((VoiceSession)receivedSession).reject();

		voice.setDriveMode(true);
		receivedSession = null;
		System.out.println("TEST10_04: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_04: redirect");
		try {
			((VoiceSession)receivedSession).redirect();
		} catch (IllegalStateException e) {
			System.out.println("TEST10_04: pass");
			return;
		}
		System.out.println("TEST10_04: fail");
	}
	private class Test10_04_Listener implements ModemControllerListener {

		@Override
		public void onReceived(ModemController controller, Session session) {
			// TODO 自動生成されたメソッド・スタブ
			receivedSession = session;
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			// TODO 自動生成されたメソッド・スタブ

		}
	}
	public void Test10_05() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_04_Listener());
		receivedSession = null;
		voice.setDriveMode(false);
		Session session = voice.createSession("0123");
//		System.out.println("Please set enable CommunicationFailureException on terminal.");
//		while (!ModuleProperties.getInstance().getCommunicationFailureException()) {
//			Thread.sleep(100);
//		}
		boolean exception = false;
//		try {
//			session.send();
//		} catch (CommunicationFailureException e) {
//			exception = true;
//		}
//		if (!exception) {
//			throw new Exception("TEST10_05: fail");
//		}
		ModuleProperties.getInstance().setCommunicationFailureException(false);

		System.out.println("Please set enable SessionException on terminal.");
		while (!NetProperties.getInstance().getSessionException()) {
			Thread.sleep(100);
		}
		exception = false;
		try {
			session.send();
		} catch (SessionException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST10_05: fail");
		}
		NetProperties.getInstance().setSessionException(false, 0, null);

		System.out.println("Please set to false UIM on terminal.");
		while (ModuleProperties.getInstance().getUIM()) {
			Thread.sleep(100);
		}
		exception = false;
		try {
			session.send();
		} catch (ExternalStatusException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST10_05: fail");
		}
		ModuleProperties.getInstance().setUIM(true);
		System.out.println("TEST10_05: pass");
	}
	public void Test10_06() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_06_Listener());
		voice.setArrivalCallAction(VoiceController.ARRIVALCALL_ACTION_CALL_WAIT);
		receivedSession = null;
		voice.setDriveMode(true);
		Session session = voice.createSession("0123");
		session.send();
		System.out.println("TEST10_06: Please receive on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		Session connected = voice.getConnectedSession();
		if (connected != null) {
			VoiceSession voiceSession = (VoiceSession)session;
			System.out.println("TEST10_06: call status = " + String.valueOf(voiceSession.getCallStatus()));
			System.out.println("TEST10_06: connected " + connected.getDestination());
		}
		else {
			throw new Exception("TEST10_06: fail");
		}
		System.out.println("TEST10_06: Please call from terminal ");
		receivedSession = null;
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		boolean exception = false;
		try {
			voice.changeHoldStatus();
		}
		catch (SessionException e) {
			exception =true;
		}
		if (!exception) {
			throw new Exception("TEST10_06: fail");
		}

		System.out.println("TEST10_06: pass");

	}
	private class Test10_06_Listener implements ModemControllerListener {

		@Override
		public void onReceived(ModemController controller, Session session) {
			receivedSession = session;
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			// TODO 自動生成されたメソッド・スタブ

		}

	}
	int callcount;
	public void Test10_07() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_07_Listener());
		Session session = voice.createSession("0123");
		VoiceSession voiceSession = (VoiceSession)session;
		callcount = 0;
		while (callcount < 3) {
			Thread.sleep(100);
		}
		System.out.println("TEST10_07: pass");
	}
	private class Test10_07_Listener implements ModemControllerListener {
		@Override
		public void onReceived(ModemController controller, Session session) {
			System.out.println("TEST10_07: onReceived:" + session.getDestination());
			callcount++;
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST10_07: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}

	}
	public void Test10_08() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_07_Listener());
		Session session = voice.createSession("0123");
		session.send();
		session.disconnect();
		session.send();
		session.disconnect();
		session.send();
		session.disconnect();
		Thread.sleep(1000*60*2);
		session.send();
		session.disconnect();
		session.send();
		session.disconnect();
		System.out.println("TEST10_08: pass");
	}
	public void Test10_09() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		voice.setModemControllerListener(new Test10_09_Listener());
		VoiceSession session = (VoiceSession) voice.createSession("110");
		session.send();
		boolean exception = false;
		while (sessionStatus != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		try {
			session.hold();
		} catch (IllegalStateException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST10_09: fail");
		}
		session.disconnect();
		session = (VoiceSession) voice.createSession("123");
		session.send();
		exception = false;
		while (sessionStatus != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		session.hold();
		try {
			session.hold();
		} catch (IllegalStateException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST10_09: fail");
		}
		System.out.println("TEST10_09: pass");
	}
	private class Test10_09_Listener implements ModemControllerListener {
		@Override
		public void onReceived(ModemController controller, Session session) {
			System.out.println("TEST10_09: onReceived:" + session.getDestination());
			callcount++;
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST10_09: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}

	}
	public void Test10_10() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		VoiceSession session = (VoiceSession) voice.createSession("123");
		VoiceSession session2 = (VoiceSession) voice.createSession("222");
		session.send();
		System.out.println("TEST10_10: Please receive on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		boolean exception = false;
		try {
			session2.send();
		}
		catch (IllegalStateException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST10_10: fail");
		}
		session.disconnect();
		System.out.println("TEST10_10: pass");
	}
	public void Test10_11() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		VoiceSession session1, session2;
		receivedSession = null;
		voice.setModemControllerListener(new Test10_02_Listener());
		System.out.println("TEST10_11: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		session1 = (VoiceSession)receivedSession;
//		voice.setArrivalCallAction(VoiceController.ARRIVALCALL_ACTION_REJECT);
//		voice.setArrivalCallAction(VoiceController.ARRIVALCALL_ACTION_REDIRECT);
		voice.setCallWaiting(false);
		voice.setArrivalCallAction(VoiceController.ARRIVALCALL_ACTION_ANSWERING);
		receivedSession = null;
		System.out.println("TEST10_11: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}

	}
	public void Test10_12() throws Exception {
		VoiceController voice = ModuleManager.getInstance().getVoiceController();
		VoiceSession session1, session2;
		receivedSession = null;
		voice.setModemControllerListener(new Test10_02_Listener());
		System.out.println("TEST10_11: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		session1 = (VoiceSession)receivedSession;
		voice.setCallWaiting(false);
		receivedSession = null;
		System.out.println("TEST10_11: Please call from terminal ");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
	}
}
