import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.USSDServiceException;
import com.docomo_um.module.net.USSDServiceListener;
import com.docomo_um.module.net.USSDServiceManager;


public class USSDServiceTest {
	public void Test15_01() throws Exception {
		USSDServiceManager ussd = USSDServiceManager.getInstance();
		ussd.send("#*0123456789");
		System.out.println("TEST15_01: pass");
	}
	public void Test15_02() throws Exception {
		USSDServiceManager ussd = USSDServiceManager.getInstance();
		try {
			ussd.send("012_a_345");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST15_02: pass");
			return ;
		}
		throw new Exception("TEST51_02: fail");
	}
	String receiveMessage;
	public void Test15_03() throws Exception {
		USSDServiceManager ussd = USSDServiceManager.getInstance();
		ussd.setUssdListener(new Test15_03_listener());
		receiveMessage = null;
		System.out.println("Please send USSD message from Terminal.");
		while (receiveMessage == null) {
			Thread.sleep(100);
		}
		System.out.println(receiveMessage);
		System.out.println("TEST15_03: pass");
	}
	public class Test15_03_listener implements USSDServiceListener {

		@Override
		public void onReceived(String message) {
			receiveMessage = message;
		}

	}
	public void Test15_04() throws Exception {
		USSDServiceManager ussd = USSDServiceManager.getInstance();
		System.out.println("Please set enable to USSDServiceException on Terminal.");
		while (!NetProperties.getInstance().getUSSDServiceException()) {
			Thread.sleep(100);
		}
		try {
			ussd.send("#*0123456789");
		} catch (USSDServiceException e) {
			System.out.println("USSDServiceException:" + e.getMessage());
			System.out.println("TEST15_04: pass");
		}
	}

}
