import java.util.Date;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.util.Timer;
import com.docomo_um.util.TimerException;
import com.docomo_um.util.TimerListener;


public class TimerTest implements TimerListener {
	int count;
	/**
	 * タイマの開始と停止
	 *
	 * @throws Exception
	 */
	public void Test07_01() throws Exception {
		Timer tm = new Timer();
		int resolution = tm.getResolution();
		System.out.println("Resolution = " + String.valueOf(resolution));
		tm.setTimerListener(true, resolution	, this);
		count = 0;
		tm.start();
		while (count < 10) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST07_01: fail");
			}
		}
		tm.dispose();
		System.out.println("TEST07_01: pass");
	}
	@Override
	public void onTimerExpired(Timer source) {
		Date date = new Date();
		System.out.println(String.valueOf(count) + ":" + String.valueOf(date.getTime()));
		if (++count >= 10) {
			try {
				source.stop();
			} catch (TimerException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}
	}
	boolean bDone;
	/**
	 * ワンショットタイマの開始
	 * @throws Exception
	 */
	public void Test07_02() throws Exception {
		Timer tm = new Timer();
		tm.setTimerListener(false, 1000, new Test07_02_listener());
		bDone = false;
		tm.start();
		while (!bDone) {
			Thread.sleep(100);
		}
		bDone = false;
		tm.start();
		while (!bDone) {
			Thread.sleep(100);
		}
		bDone = false;
		tm.start();
		while (!bDone) {
			Thread.sleep(100);
		}
		System.out.println("TEST07_02: pass");
	}
	private class Test07_02_listener implements TimerListener {
		@Override
		public void onTimerExpired(Timer source) {
			bDone = true;
		}

	}
	public void Test07_03() throws Exception {
		Timer tm = new Timer();
		tm.setTimerListener(false, 10000, new Test07_02_listener());
		bDone = false;
		tm.start();
		Thread.sleep(1000);
		tm.stop();
		Thread.sleep(11000);
		if (bDone) {
			throw new Exception("TEST07_03: fail");
		}
		System.out.println("TEST07_03: pass");
	}
	public void Test07_04() throws Exception {
		for (int i = 0; i < 100; i++) {
			System.out.print(String.valueOf(i) + " ");
			Timer timer = new Timer();
			TimerListener listener = new TimerListener() {
				public void onTimerExpired(Timer source) {
				}
			};
			timer.setTimerListener(false, 1000, listener);
			timer.dispose();
			Thread.sleep(100);
		}
		System.out.println("TEST07_04: pass");
	}
	public void Test07_05() throws Exception {
		Timer tm = new Timer();
		int resolution = tm.getResolution();
		System.out.println("Resolution = " + String.valueOf(resolution));
		tm.setTimerListener(true, 0, this);
		count = 0;
		tm.start();
		while (count < 10) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST07_05: fail");
			}
		}
		tm.dispose();
		System.out.println("TEST07_05: pass");
	}
	public void Test07_06() throws Exception {
		Timer tm = new Timer();
		tm.setTimerListener(false, 10000, new Test07_02_listener());
		System.out.println("Please set enable to TimerException from terminal.");
		while (!ModuleProperties.getInstance().getTimerException()) {
			Thread.sleep(100);
		}
		boolean exception = false;
		try {
			tm.start();
		}
		catch (TimerException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST07_06: fail");
		}
		ModuleProperties.getInstance().setTimerExcepiton(false, null);
		tm.dispose();
		exception = false;
		try {
			tm.start();
		}
		catch (IllegalStateException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST07_06: fail");
		}
		System.out.println("TEST07_06: pass");
	}
}
