import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.docomo_um.module.net.Mail;
import com.docomo_um.module.net.MailException;
import com.docomo_um.module.net.MailManager;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.POPServerInfo;
import com.docomo_um.module.net.SMTPClient;
import com.docomo_um.module.net.SMTPServerInfo;


public class SmtpClientTest {
	public void Test14_Initialize() {
		File file;
		for (int i = 0; i < 100; i++) {
			file = new File(NetProperties.getInstance().getMailDirectory() + "outbox/" + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
		file = new File(NetProperties.getInstance().getMailDirectory() + "outbox");
		if (file.exists()) {
			file.delete();
		}
		file = new File(NetProperties.getInstance().getMailDirectory());
		if (file.exists()) {
			file.delete();
		}
	}
	public void Test14_01() throws Exception {
		SMTPServerInfo smtpServer = new SMTPServerInfo("192.168.10.2", "account", "password", SMTPServerInfo.SMTP_AUTH_TYPE_NONE);
		if (!smtpServer.getSMTPServerName().equals("192.168.10.2")) {
			throw new Exception("TEST14_01: fail");
		}
		if (!smtpServer.getAccount().equals("account")) {
			throw new Exception("TEST14_01: fail");
		}
		if (!smtpServer.getPassword().equals("password")) {
			throw new Exception("TEST14_01: fail");
		}
//		if (smtpServer.getPortNo() != 25) {
//			throw new Exception("TEST14_01: fail");
//		}
		if (smtpServer.getAuthentication() != SMTPServerInfo.SMTP_AUTH_TYPE_NONE) {
			throw new Exception("TEST14_01: fail");
		}
		MailManager mailMan = MailManager.getInstance();
		SMTPClient smtp = mailMan.getSMTPClient(smtpServer, false);
		Mail mail = new Mail();
		mail.setFromAddress("aaa@aaa.co.jp");
		List<String> toAddresses = new ArrayList<String>();
		toAddresses.add("to1@aaa.co.jp");
		toAddresses.add("to2@aaa.co.jp");
		toAddresses.add("to3@aaa.co.jp");
		mail.setToAddresses(toAddresses);
		List<String> ccAddresses = new ArrayList<String>();
		ccAddresses.add("cc1@bbb.co.jp");
		ccAddresses.add("cc2@bbb.co.jp");
		ccAddresses.add("cc3@bbb.co.jp");
		ccAddresses.add("cc4@bbb.co.jp");
		mail.setCcAddresses(ccAddresses);
		List<String> bccAddresses = new ArrayList<String>();
		bccAddresses.add("bcc1@ccc.co.jp");
		bccAddresses.add("bcc2@ccc.co.jp");
		mail.setBccAddresses(bccAddresses);
		mail.setSubject("subject");
		mail.setBody("mailsendtest");
		smtp.sendMail(mail);

		File file = new File(NetProperties.getInstance().getMailDirectory() + "outbox/0");
		if (!file.exists()) {
			throw new Exception("TEST14_01: fail");
		}
		System.out.println("TEST14_01: pass");
	}
	public void Test14_02() throws Exception {
		SMTPServerInfo smtpServer = new SMTPServerInfo("192.168.10.2", "account", "password", SMTPServerInfo.SMTP_AUTH_TYPE_PLAIN);
		MailManager mailMan = MailManager.getInstance();
		SMTPClient smtp = mailMan.getSMTPClient(smtpServer, false);
		List<String> toAddresses = new ArrayList<String>();
		toAddresses.add("to1@aaa.co.jp");
		toAddresses.add("to2@aaa.co.jp");
		toAddresses.add("to3@aaa.co.jp");
		Mail mail = new Mail("from@xxx.co.jp", toAddresses);
		List<String> ccAddresses = new ArrayList<String>();
		ccAddresses.add("cc1@bbb.co.jp");
		ccAddresses.add("cc2@bbb.co.jp");
		ccAddresses.add("cc3@bbb.co.jp");
		ccAddresses.add("cc4@bbb.co.jp");
		mail.setCcAddresses(ccAddresses);
		List<String> bccAddresses = new ArrayList<String>();
		bccAddresses.add("bcc1@ccc.co.jp");
		bccAddresses.add("bcc2@ccc.co.jp");
		mail.setBccAddresses(bccAddresses);
		mail.setSubject("subject");
		mail.setBody("mailsendtest");
		smtp.sendMail(mail);

		File file = new File(NetProperties.getInstance().getMailDirectory() + "outbox/1");
		if (!file.exists()) {
			throw new Exception("TEST14_02: fail");
		}
		System.out.println("TEST14_02: pass");
	}
	public void Test14_03() throws Exception {
		SMTPServerInfo smtpServer = new SMTPServerInfo("192.168.10.2", "account", "password", SMTPServerInfo.SMTP_AUTH_TYPE_PLAIN);
		MailManager mailMan = MailManager.getInstance();
		SMTPClient smtp = mailMan.getSMTPClient(smtpServer, false);
		Mail mail = new Mail();
		mail.setFromAddress("aaa@aaa.co.jp");
		List<String> toAddresses = new ArrayList<String>();
		toAddresses.add("to1@aaa.co.jp");
		toAddresses.add("to2@aaa.co.jp");
		toAddresses.add("to3@aaa.co.jp");
		mail.setToAddresses(toAddresses);
		List<String> ccAddresses = new ArrayList<String>();
		ccAddresses.add("cc1@bbb.co.jp");
		ccAddresses.add("cc2@bbb.co.jp");
		ccAddresses.add("cc3@bbb.co.jp");
		ccAddresses.add("cc4@bbb.co.jp");
		mail.setCcAddresses(ccAddresses);
		List<String> bccAddresses = new ArrayList<String>();
		bccAddresses.add("bcc1@ccc.co.jp");
		bccAddresses.add("bcc2@ccc.co.jp");
		mail.setBccAddresses(bccAddresses);
		mail.setSubject("subject");
		mail.setBody("mailsendtest");

		System.out.println("Please set enable MailException on terminal");
		while (!NetProperties.getInstance().getMailException()) {
			Thread.sleep(100);
		}
		try {
			smtp.sendMail(mail);
		} catch (MailException e) {
			//int status = e.getStatus();
			//System.out.println("status = " + String.valueOf(status));
			System.out.println("TEST14_03: pass");
			return;
		}
		throw new Exception("TEST14_03: fail");
	}
	public void Test14_04() throws Exception {
		SMTPServerInfo smtpServer = new SMTPServerInfo("192.168.10.2", "account", "password", SMTPServerInfo.SMTP_AUTH_TYPE_PLAIN);
		POPServerInfo popServer = new POPServerInfo("ServerName", "account", "password");
		MailManager mailMan = MailManager.getInstance();
		SMTPClient smtp = mailMan.getSMTPClient(smtpServer, false);
		smtp.setPOPServerInfo(popServer);
		List<String> toAddresses = new ArrayList<String>();
		toAddresses.add("to1@aaa.co.jp");
		toAddresses.add("to2@aaa.co.jp");
		toAddresses.add("to3@aaa.co.jp");
		Mail mail = new Mail("from@xxx.co.jp", toAddresses);
		List<String> ccAddresses = new ArrayList<String>();
		ccAddresses.add("cc1@bbb.co.jp");
		ccAddresses.add("cc2@bbb.co.jp");
		ccAddresses.add("cc3@bbb.co.jp");
		ccAddresses.add("cc4@bbb.co.jp");
		mail.setCcAddresses(ccAddresses);
		List<String> bccAddresses = new ArrayList<String>();
		bccAddresses.add("bcc1@ccc.co.jp");
		bccAddresses.add("bcc2@ccc.co.jp");
		mail.setBccAddresses(bccAddresses);
		mail.setSubject("subject");
		mail.setBody("mailsendtest");
		NetProperties.getInstance().setMailException(false, 0, null);
		smtp.sendMail(mail);

		File file = new File(NetProperties.getInstance().getMailDirectory() + "outbox/1");
		if (!file.exists()) {
			throw new Exception("TEST14_04: fail");
		}
		System.out.println("TEST14_04: pass");

	}
	public void Test14_05() throws Exception {
		String message = new String();
		for (int i = 0; i < 5120; i++) {
			message += 'a';
		}
		Mail mail = new Mail();
		try {
			mail.setBody(message);
			throw new Exception("TEST14_05: fail");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST14_05:IllegalArgumentException occur.");
		}
		System.out.println("TEST14_05: pass");

	}
}
