import java.io.File;
import java.util.List;

import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageBox;
import com.docomo_um.module.net.ShortMessageBoxListener;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.module.net.ShortMessageListener;
import com.docomo_um.module.net.ShortMessageManager;


public class ShortMessageTest {
	String messageBoxDir;
	String messageBoxUIMDir;
	String messageBoxModuleDir;
	public void Test09_Initialize() {
		File file;
		messageBoxDir = NetProperties.getInstance().getSMSDir();
		messageBoxUIMDir = messageBoxDir + "UIM/";
		messageBoxModuleDir = messageBoxDir + "MODULE/";
		for (int i = 1; i < 100; i++) {
			file = new File(messageBoxDir + "SENT/" + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
		for (int i = 1; i <= 20; i++) {
			file = new File(messageBoxUIMDir + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
		for (int i = 1; i <= 8; i++) {
			file = new File(messageBoxModuleDir + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
	}
	public void Test09_01() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		System.out.println("Message Format = " + smsMan.getMessageFormat());
		smsBox.setStorage(ShortMessageBox.ACTION_TYPE_RECEIVE, ShortMessageBox.STORAGE_TYPE_MODULE);
		smsBox.setStorage(ShortMessageBox.ACTION_TYPE_SEND, ShortMessageBox.STORAGE_TYPE_UIM);
		ShortMessage sm = new ShortMessage();
		sm.setToPhoneNumber("0123");
		sm.setToPhoneNumberType("129");
		sm.setMessage("TEST");
		smsBox.send(sm, false, 1);
		File file = new File(messageBoxDir + "SENT/1");
		if (!file.exists()) {
			throw new Exception("TEST09_01: fail");
		}
		String receiveStorage = smsBox.getStorage(ShortMessageBox.ACTION_TYPE_RECEIVE);
		if (!receiveStorage.equals(ShortMessageBox.STORAGE_TYPE_MODULE)) {
			throw new Exception("TEST09_01: fail");
		}
		String sendStorage = smsBox.getStorage(ShortMessageBox.ACTION_TYPE_SEND);
		if (!sendStorage.equals(ShortMessageBox.STORAGE_TYPE_UIM)) {
			throw new Exception("TEST09_01: fail");
		}
		System.out.println("TEST09_01: pass");
	}
	MessageBox receiveMessageBox;
	int receiveMessageNumber;
	boolean receiveOverride;
	boolean bFull;
	public void Test09_02() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		for (int i = 1; i <= smsBox.getTotalMessageNumber(ShortMessageBox.ACTION_TYPE_RECEIVE); i++) {
			receiveMessageNumber = -1;
			System.out.println("Please send short message from terminal.");
			while (receiveMessageNumber == -1) {
				Thread.sleep(100);
			}
			System.out.println("receive " + String.valueOf(receiveMessageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER));
			if ((receiveMessageNumber & ShortMessageFunctions.PREFIX_SHORTMESSAGE) == 0) {
				throw new Exception("TEST09_02: fail");
			}
			if ((receiveMessageNumber & ShortMessageFunctions.PREFIX_UIM) != 0) {
				throw new Exception("TEST09_02: fail");
			}
			int savedNum = ((ShortMessageBox) receiveMessageBox).getSavedMessageNumber(ShortMessageBox.ACTION_TYPE_RECEIVE);
			System.out.println("TOTAL RECIVE = " + String.valueOf(savedNum));
			if (savedNum != i) {
				throw new Exception("TEST09_02: fail");
			}
			ShortMessage receiveMessage = receiveMessageBox.get(receiveMessageNumber);
			System.out.println(receiveMessage.getFormat());
			System.out.println(receiveMessage.getToPhoneNumber());
			System.out.println(receiveMessage.getToPhoneNumberType());
			System.out.println(String.valueOf(receiveMessage.getMessageNumber()));
			System.out.println(receiveMessage.getMessage());
		}
		System.out.println("Please send short message from terminal.");
		receiveMessageNumber = -1;
		while (receiveMessageNumber == -1) {
			Thread.sleep(100);
		}
		System.out.println("receive " + String.valueOf(receiveMessageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER));
		if ((receiveMessageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER) != 1) {
			throw new Exception("TEST09_02: fail");
		}
		ShortMessage receiveMessage = receiveMessageBox.get(receiveMessageNumber);
		System.out.println(receiveMessage.getMessage());
		System.out.println("TEST09_02: pass");
	}
	public void Test09_03() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		for (int i = 1; i <= smsBox.getTotalMessageNumber(ShortMessageBox.ACTION_TYPE_RECEIVE); i++) {
			receiveMessageNumber = -1;
			System.out.println("Please send short message from terminal.");
			while (receiveMessageNumber == -1) {
				Thread.sleep(100);
			}
			System.out.println("receive " + String.valueOf(receiveMessageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER));
			if ((receiveMessageNumber & ShortMessageFunctions.PREFIX_SHORTMESSAGE) == 0) {
				throw new Exception("TEST09_03: fail");
			}
			if ((receiveMessageNumber & ShortMessageFunctions.PREFIX_UIM) != 0) {
				throw new Exception("TEST09_03: fail");
			}
			int savedNum = ((ShortMessageBox) receiveMessageBox).getSavedMessageNumber(ShortMessageBox.ACTION_TYPE_RECEIVE);
			if (savedNum != 8) {
				throw new Exception("TEST09_03: fail");
			}
		}
		System.out.println("Please send short message from terminal.");
		bFull = false;
		while (!bFull) {
			Thread.sleep(100);
		}
		System.out.println("TEST09_03: pass");
	}
	public void Test09_04() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		for (int i = 1; i <= smsBox.getTotalMessageNumber(ShortMessageBox.ACTION_TYPE_SEND); i++) {
			ShortMessage sms = new ShortMessage();
			sms.setMessage("message" + String.valueOf(i));
			sms.setToPhoneNumber("0123456");
			smsBox.save(sms);
		}
		ShortMessage sms = new ShortMessage();
		sms.setMessage("message" + String.valueOf(21));
		sms.setToPhoneNumber("0123456");
		try {
			smsBox.save(sms);
		} catch (ShortMessageException e) {
			int status = e.getStatus();
			System.out.println("status = " + String.valueOf(status));
			System.out.println("TEST09_04: pass");
			return;
		}
		throw new Exception("TEST09_04: fail");
	}
	public void Test09_05() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		smsBox.send(ShortMessageFunctions.PREFIX_SHORTMESSAGE | ShortMessageFunctions.PREFIX_UIM | 1, false, 1);
		smsBox.delete(ShortMessageBox.DELETE_TYPE_READ_SENT);
		ShortMessage sms = new ShortMessage();
		sms.setMessage("message" + String.valueOf(21));
		sms.setToPhoneNumber("0123456");
		smsBox.save(sms);
		System.out.println("TEST09_05: pass");
	}
	public void Test09_06() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		int number = 3;
		File file = new File(messageBoxModuleDir + String.valueOf(number));
		if (!file.exists()) {
			throw new Exception("TEST09_06: fail");
		}
		smsBox.delete(ShortMessageFunctions.PREFIX_SHORTMESSAGE | number);
		if (file.exists()) {
			throw new Exception("TEST09_06: fail");
		}
		System.out.println("TEST09_06: pass");
	}
	public void Test09_07() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		List<ShortMessage> list = smsBox.get(ShortMessage.STAT_READ);
		if (list.size() != 0) {
			throw new Exception("TEST09_07: fail");
		}
		list = smsBox.get(ShortMessage.STAT_UNREAD);
		if (list.size() != 7) {
			throw new Exception("TEST09_07: fail");
		}
		list = smsBox.get(ShortMessage.STAT_UNREAD);
		if (list.size() != 0) {
			throw new Exception("TEST09_07: fail");
		}
		list = smsBox.get(ShortMessage.STAT_READ);
		if (list.size() != 7) {
			throw new Exception("TEST09_07: fail");
		}
		System.out.println("TEST09_07: pass");
	}
	private class Test09_02_Litener implements ShortMessageListener {
		@Override
		public void onSMSReceived(MessageBox messageBox, int messageNumber,
				boolean override) {
			receiveMessageNumber = messageNumber;
			receiveMessageBox = messageBox;
		}
		@Override
		public void onAreaMailReceived(ShortMessage message, boolean override) {
			// TODO 自動生成されたメソッド・スタブ

		}
		@Override
		public void onSMSBoxFull(MessageBox messageBox) {
			receiveMessageBox = messageBox;
			bFull = true;
		}
	}
	public void Test09_08() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		smsMan.setMessageFormat(ShortMessageManager.FORMAT_PDU);
		ShortMessage sms = new ShortMessage();
		if (!sms.getFormat().equals(ShortMessageManager.FORMAT_PDU)) {
			throw new Exception("TEST09_08: fail");
		}
		smsMan.setMessageFormat(ShortMessageManager.FORMAT_TEXT);
		if (!sms.getFormat().equals(ShortMessageManager.FORMAT_PDU)) {
			throw new Exception("TEST09_08: fail");
		}
		sms.setMessage("abcdef");
		try {
			smsMan.getShortMessageBox().send(sms, false, 1);
		}
		catch (IllegalSettingException e) {
			throw new Exception("TEST09_08: fail");
		}
		System.out.println("TEST09_08: pass");
	}
	public void Test09_09() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setShortMessageListener(new Test09_02_Litener());
		smsMan.setMessageFormat(ShortMessageManager.FORMAT_TEXT);
		ShortMessage sms = new ShortMessage();
		if (!sms.getFormat().equals(ShortMessageManager.FORMAT_TEXT)) {
			throw new Exception("TEST09_09: fail");
		}
		sms.setMessage("abcdef");
		boolean exception = false;
		try {
			smsMan.getShortMessageBox().send(sms, false, 1);
		}
		catch (IllegalSettingException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST09_09: fail");
		}
		System.out.println("TEST09_09: pass");
	}

	public void Test09_10() throws Exception {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		smsMan.setMessageFormat(ShortMessageManager.FORMAT_TEXT);
		ShortMessageBox smsBox = smsMan.getShortMessageBox();
		ShortMessage sm = new ShortMessage();
		try {
			smsBox.save(sm);
			throw new Exception("TEST09_10: fail");
		} catch (IllegalArgumentException e) {
			System.out.println("IllegalArgumentException is occurred.");
		}
		try {
			sm.setMessage("01234567890123456789012345678901234567890123456789012345678901234567890");
			throw new Exception("TEST09_10: fail");
		} catch (IllegalArgumentException e) {
			System.out.println("IllegalArgumentException is occurred.");
		}
		try {
			sm.setMessage("0123456789012345678901234567890123456789012345678901234567890123456789");
		} catch (IllegalArgumentException e) {
			System.out.println("IllegalArgumentException is occurred.");
			throw new Exception("TEST09_10: fail");
		}
		System.out.println("TEST09_10: pass");
	}
}
