﻿import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.Serial;
import com.docomo_um.module.connection.SerialConnection;
import com.docomo_um.module.connection.SerialListener;
import com.docomo_um.module.connection.SerialSpec;


public class SerialConnectionTest implements SerialListener {
	private boolean ER = false;
	private int totalRecv;
	public void Test06_01() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		List<SerialSpec> list = sio.getSerialSpec();
		for (int i = 0; i < list.size(); i++) {
			spec = list.get(i);
			System.out.print("DeviceName = " + spec.getDeviceName());
			List<Long> speedlist = spec.getCommSpeedList();
			for (int j = 0; j < speedlist.size(); j++) {
				System.out.print(", " + String.valueOf(speedlist.get(j)));
			}
			System.out.println();
		}
		List<String> enalist = ConnectionProperties.getInstance().getEnableSerialList();
		for (int i = 0; i < enalist.size(); i++) {
			System.out.println(enalist.get(i));
		}
		System.out.println("TEST06_01: pass");
	}
	public void Test06_02() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		int totalSend = 0;
		List<SerialSpec> list = sio.getSerialSpec();
		// USB01
		spec = list.get(0);
		Serial usb01 = sio.getSerial(spec);
		usb01.setCommSpeed(115200);
		if (usb01.isEnabled()) {

		}
		usb01.setEnable(true);
		OutputStream os = usb01.getOutputStream();
		byte[] buf = new byte[1024];
		for (int i = 0; i < 1024; i++) {
			if (i % 16 < 10)
				buf[i] = (byte) ('0' + (i % 16));
			else
				buf[i] = (byte) ('A' + (i % 16) - 10);
		}
		for (int i = 0; i < 1024; i++) {
			os.write(buf);
			totalSend += 1024;
			System.out.println("totalSend = " + totalSend);
		}
		os.close();
		usb01.setEnable(false);
		System.out.println("TEST06_02: pass");
	}
	public void Test06_03() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		List<SerialSpec> list = sio.getSerialSpec();
		// USB01
		spec = list.get(0);
		Serial usb01 = sio.getSerial(spec);
		usb01.setCommSpeed(115200);
		usb01.setEnable(true);
		totalRecv = 0;
		usb01.setSerialListener(new Test06_03_Listener());
		ER = usb01.getERStatus();
		while (ER) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST06_03: fail");
			}
		}
		System.out.println("Please start terminal soft for send data.");
		while (!ER) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST06_01: fail");
			}
		}
		System.out.println("Start recieve. Please send 1M data!");
		while (totalRecv < 1024 * 1024) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST06_03: fail");
			}
		}
		System.out.println("TEST06_03: pass");
		usb01.setEnable(false);
	}
	public class Test06_03_Listener implements SerialListener {
		byte[] buf;
		Test06_03_Listener() {
			buf = new byte[1024];
		}
		@Override
		public void onReceived(Serial serial) {
			int recv = 0;
			InputStream is = serial.getInputStream();
			while (true) {
				try {
					recv = is.read(buf);
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				if (recv <= 0) {
					break;
				}
				totalRecv += recv;
				System.out.println("recv = " + recv + ", TotalRecv = " + totalRecv);
			}
		}

		@Override
		public void onChangedERStatus(Serial serial, boolean er) {
			System.out.println("Change ER Status = " + String.valueOf(er));
			ER = er;
		}
	}
	public void Test06_04() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		List<SerialSpec> list = sio.getSerialSpec();
		// USB01
		spec = list.get(0);
		Serial usb01 = sio.getSerial(spec);
		usb01.setCommSpeed(115200);
		usb01.setEnable(true);
		usb01.setSerialListener(this);
		while (!ER) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST06_04: fail");
			}
		}
		while (totalRecv < 1024*1024) {
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {
				throw new Exception("TEST06_04: fail");
			}
		}
		System.out.println("TEST06_04: pass");
	}
	public void Test06_05() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		List<SerialSpec> list = sio.getSerialSpec();
		byte[] buf = new byte[1024];
		// USB01
		spec = list.get(1);
		Serial usb01 = sio.getSerial(spec);
		usb01.setCommSpeed(115200);
		usb01.setEnable(true);
		usb01.setSerialListener(this);
		InputStream is = usb01.getInputStream();
		OutputStream os = usb01.getOutputStream();
		usb01.setEnable(false);
		try {
			is.read();
			throw new Exception("TEST06_05: fail");
		} catch (IOException e) {
		}
		try {
			is.read(buf,0,1024);
			throw new Exception("TEST06_05: fail");
		} catch (IOException e) {
		}
		try {
			os.write(buf[0]);
			throw new Exception("TEST06_05: fail");
		} catch (IOException e) {
		}
		try {
			os.write(buf,0,1024);
			throw new Exception("TEST06_05: fail");
		} catch (IOException e) {
		}
		
		System.out.println("TEST06_05: pass");
	}
	public void Test06_06() throws Exception {
		SerialConnection sio = (SerialConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SERIAL);
		SerialSpec spec;
		List<SerialSpec> list = sio.getSerialSpec();
		byte[] buf = new byte[1024];
		// UART01
		spec = list.get(0);
		Serial uart01 = sio.getSerial(spec);
		uart01.setCommSpeed(115200);
		uart01.setEnable(true);
		uart01.setSerialListener(this);
		InputStream is = uart01.getInputStream();
		OutputStream os = uart01.getOutputStream();
		uart01.setEnable(false);
		try {
			is.read();
		} catch (IOException e) {
			throw new Exception("TEST06_06: fail");
		}
		try {
			is.read(buf,0,1024);
		} catch (IOException e) {
			throw new Exception("TEST06_06: fail");
		}
		try {
			os.write(buf[0]);
		} catch (IOException e) {
			throw new Exception("TEST06_06: fail");
		}
		try {
			os.write(buf,0,1024);
		} catch (IOException e) {
			throw new Exception("TEST06_06: fail");
		}
		
		System.out.println("TEST06_06: pass");
	}

	@Override
	public void onReceived(Serial serial) {
		InputStream is;
		OutputStream os;
		int data;
		int recv = 0;
		is = serial.getInputStream();
		os = serial.getOutputStream();
		try {
			while ((data = is.read()) > 0) {
				os.write(data);
				recv++;
			}
		} catch (IOException e) {

		}
		totalRecv += recv;
	}

	@Override
	public void onChangedERStatus(Serial serial, boolean er) {
		ER = er;
	}
}
