import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.net.ssl.IllegalCertificateException;
import com.docomo_um.module.net.ssl.KeyStore;
import com.docomo_um.module.net.ssl.SSLProperties;
import com.docomo_um.module.net.ssl.SecureContext;
import com.docomo_um.module.net.ssl.SecureHandshakeException;
import com.docomo_um.module.net.ssl.SecureSocket;
import com.docomo_um.module.net.ssl.SecureSocketFactory;
import com.docomo_um.module.net.ssl.X509Certificate;
import com.docomo_um.module.net.ssl.X509CertificateFactory;


public class SSLTest {
	public void Test17_01() throws Exception {

		SecureContext context = SecureContext.getInstance();
		SecureSocketFactory factory = context.getSocketFactory();
		SecureSocket socket = factory.createSocket("127.0.0.1", 8080);
		socket.startHandshake();
		OutputStream os = socket.getOutputStream();
		InputStream is = socket.getInputStream();
		os.close();
		is.close();
		socket.close();
		System.out.println("TEST17_01: pass");
	}
	public void Test17_02() throws Exception {
		SecureContext context = SecureContext.getInstance();
		SecureSocketFactory factory = context.getSocketFactory();
		SecureSocket socket = factory.createSocket("127.0.0.1", 8080);
		System.out.println("Please set enable SecureHandshakeException on Terminal.");
		while (!SSLProperties.getInstance().getSecureHandshakeException()) {
			Thread.sleep(100);
		}
		try {
			socket.startHandshake();
		}
		catch (SecureHandshakeException e) {
			System.out.println("TEST17_02: pass");
			return;
		}
		throw new Exception("TEST17_02: fail");

	}
	public void Test17_03() throws Exception {
		X509CertificateFactory factory = X509CertificateFactory.getInstance();
		FileInputStream is = new FileInputStream("/nano/X509Certificate.txt");
		X509Certificate certificate = factory.generateCertificate(is);
		KeyStore keyStore = KeyStore.getInstance();
		keyStore.setCertificate(certificate, true);
		keyStore.setCertificate(null, true);
		System.out.println("TEST17_03: pass");
	}
	public void Test17_04() throws Exception {
		X509CertificateFactory factory = X509CertificateFactory.getInstance();
		FileInputStream is = new FileInputStream("/nano/X509Certificate.txt");
		System.out.println("Please set enable IllegalCertificateException on Terminal.");
		while (!SSLProperties.getInstance().getIllegalCertificateException()) {
			Thread.sleep(100);
		}
		try {
			X509Certificate certificate = factory.generateCertificate(is);
		}
		catch (IllegalCertificateException e) {
			System.out.println("TEST17_04: pass");
			return;
		}
		throw new Exception("TEST17_04: fail");
	}

	public void Test17_05() throws Exception {
		Test17_05_server server = new Test17_05_server();
		server.start();
		SecureContext context = SecureContext.getInstance();
		SecureSocketFactory factory = context.getSocketFactory();
		SecureSocket socket;
		try {
			String msg = "abcd";
			socket = factory.createSocket("127.0.0.1", 8080);
			socket.startHandshake();

			OutputStream os = socket.getOutputStream();
			os.write(msg.getBytes());
			os.close();
		} catch (UnknownHostException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (SecureHandshakeException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (CommunicationFailureException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		System.out.println("TEST17_05: pass");
	}
	public class Test17_05_server extends Thread {
		public void run() {
			byte[] buf = new byte[4];
			ServerSocket server;
			try {
				server = new ServerSocket(8080);
				Socket socket = server.accept();
				InputStream is = socket.getInputStream();
				is.read(buf);
				for (int i = 0; i < buf.length; i++) {
					System.out.println(String.valueOf(buf[i]));
				}
				is.close();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}
	}
}
