import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import jp.co.aplix.extra.util.HexUtil;

import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.SPICombinedFormatData;
import com.docomo_um.module.connection.SPIConnection;
import com.docomo_um.module.connection.SPIDevice;
import com.docomo_um.module.connection.SPIListener;
import com.docomo_um.module.connection.SPIMaster;
import com.docomo_um.module.connection.SPIMasterSettingInfo;
import com.docomo_um.module.connection.SPISlave;
import com.docomo_um.module.connection.SPISpec;


public class SPITest {
	/**
	 * SPISpecのリストを取得
	 * @throws Exception
	 */
	public void Test21_01() throws Exception {
		System.out.println("TEST21_01: start");

		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		for (int i = 0; i < specList.size(); i++) {
			SPISpec spec = specList.get(i);
			List<Long> freqList = spec.getClockFrequencyList();
			String name = spec.getDeviceName();
			int mode = spec.getCommMode();
			System.out.println("Device name = " + name);
			System.out.println("mode = " + String.valueOf(mode));
			if (freqList.size() > 0) {
				System.out.print("freq = " + String.valueOf(freqList.get(0)));
				for (int j = 1; j < freqList.size(); j++) {
					System.out.print(", " + freqList.get(j));
				}
				System.out.println();
			}
		}
		try {
			SPICombinedFormatData data = new SPICombinedFormatData(99, new byte[10]);
			throw new Exception("TEST21_01: IllegalArgumentException not occur");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST21_01: IllegalArgumentException occur");
		}
		System.out.println("TEST21_01: pass");
	}
	boolean bReceived;
	SPIDevice dev;
	boolean sig;
	/**
	 * スレーブの入出力
	 * @throws Exception
	 */
	public void Test21_02() throws Exception {
		SPIListener listener = new SPIListener() {
			@Override
			public void onChangedStatus(SPIDevice device, boolean signal) {
				synchronized (this) {
					dev = device;
					sig = signal;
					notifyAll();
				}
			}
		};
		System.out.println("TEST21_02: start");
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPISlave slave = spi.getSPISlave(specList.get(0));
		slave.setSPIListener(listener);
		dev = null;
		sig = false;
		System.out.println("Please start SPI on terminal.");
		synchronized (listener) {
			listener.wait(60000);
		}
		if (!dev.equals(slave)) {
			throw new Exception("TEST21_02: fail device");
		}
		if (sig != true) {
			throw new Exception("TEST21_02: fail signal");
		}
		byte[] buf1 = new byte[4];
		byte[] buf2 = new byte[4];
		byte[] buf3 = new byte[16];
		byte[] buf4 = new byte[16];
		for (int i = 0; i < 16; i++) {
			buf3[i] = (byte)i;
			buf4[i] = (byte)(16+i);
		}
		SPICombinedFormatData[] data = new SPICombinedFormatData[4];
		data[0] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf1);
		data[1] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf2);
		data[2] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf3);
		data[3] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf4);
		SPICombinedFormatData[] recv = slave.sendCombinedFormat(data);
		if (recv.length != 2) {
			throw new Exception("TEST21_02: fail length");
		}
		for (int i = 0; i < recv.length; i++) {
			byte[] recvBuf = recv[i].getTransmissionData();
			HexUtil.dump(recvBuf);
		}
		dev = null;
		System.out.println("Please stop SPI on terminal.");
		synchronized (listener) {
			listener.wait(60000);
		}
		if (!dev.equals(slave)) {
			throw new Exception("TEST21_02: fail");
		}
		if (sig != false) {
			throw new Exception("TEST21_02: fail");
		}

		System.out.println("TEST21_02: pass");
	}
	public void Test21_03() throws Exception {
		System.out.println("TEST21_03: start");
		SPIListener listener = new SPIListener() {
			@Override
			public void onChangedStatus(SPIDevice device, boolean signal) {
				synchronized (this) {
					dev = device;
					sig = signal;
					notifyAll();
				}
			}
		};
		Thread interruptThread = new Thread() {
			@Override
			public void run() {
				try {
					Thread.sleep(10000);
					System.out.println("TEST21_03: interrupt");
					((SPISlave)dev).interrupt();
				} catch (InterruptedException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				} catch (ConnectionException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
			}
		};
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPISlave slave = spi.getSPISlave(specList.get(0));
		slave.setSPIListener(listener);
		dev = null;
		sig = false;
		System.out.println("Please start SPI on terminal.");
		synchronized (listener) {
			listener.wait(60000);
		}
		byte[] buf1 = new byte[1024];
		SPICombinedFormatData[] data = new SPICombinedFormatData[1];
		data[0] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf1);

		try {
			interruptThread.start();
			SPICombinedFormatData[] recv = slave.sendCombinedFormat(data);
			byte[] recvBuf = recv[0].getTransmissionData();
			HexUtil.dump(recvBuf);
			throw new Exception("TEST21_03: IOException not occur");
		} catch (IOException e) {
			System.out.println("TEST21_03: IOException occur");
		}
		System.out.println("TEST21_03: pass");
	}
	public void Test21_04() throws Exception {
		System.out.println("TEST21_04: start");
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPISlave slave = spi.getSPISlave(specList.get(0));
		byte[] buf1 = new byte[4];
		byte[] buf2 = new byte[4];
		SPICombinedFormatData[] data = new SPICombinedFormatData[2];
		data[0] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf1);
		data[1] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf2);

		try {
			ConnectionProperties.getInstance().setConnectionException(true, null);
			SPICombinedFormatData[] recv = slave.sendCombinedFormat(data);
			byte[] recvBuf = recv[0].getTransmissionData();
			HexUtil.dump(recvBuf);
			throw new Exception("TEST21_04: ConnectionException not occur");
		} catch (ConnectionException e) {
			System.out.println("TEST21_04: ConnectionException occur");
		} finally {
			ConnectionProperties.getInstance().setConnectionException(false, null);
		}

		System.out.println("TEST21_04: pass");
	}
	/**
	 * マスタ側入出力
	 * @throws Exception
	 */
	public void Test21_05() throws Exception {
		System.out.println("TEST21_05: start");
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPIMasterSettingInfo info = new SPIMasterSettingInfo();
		SPIMaster master = spi.getSPIMaster(specList.get(0), info);
		master.start();
		byte[] buf1 = new byte[4];
		byte[] buf2 = new byte[4];
		byte[] buf3 = new byte[16];
		byte[] buf4 = new byte[16];
		for (int i = 0; i < 16; i++) {
			buf3[i] = (byte)i;
			buf4[i] = (byte)(16+i);
		}
		SPICombinedFormatData[] data = new SPICombinedFormatData[4];
		data[0] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf1);
		data[1] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_READ, buf2);
		data[2] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf3);
		data[3] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf4);
		SPICombinedFormatData[] recv = master.sendCombinedFormat(data);
		if (recv.length != 2) {
			throw new Exception("TEST21_05: fail length");
		}
		for (int i = 0; i < recv.length; i++) {
			byte[] recvBuf = recv[i].getTransmissionData();
			HexUtil.dump(recvBuf);
		}
		data = new SPICombinedFormatData[2];
		data[0] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf3);
		data[1] = new SPICombinedFormatData(SPICombinedFormatData.TYPE_WRITE, buf4);
		recv = master.sendCombinedFormat(data);
		if (recv != null) {
			throw new Exception("TEST21_05: not null");
		}
		
		try {
			data = new SPICombinedFormatData[0];
			recv = master.sendCombinedFormat(data);
			throw new Exception("TEST21_05: IllegalArgumentException not occur");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST21_05: IllegalArgumentException occur");
		}
		
		master.stop();
		System.out.println("TEST21_05: pass");
	}
	public void Test21_06() throws Exception {
		System.out.println("TEST21_06: start");
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPIMasterSettingInfo info = new SPIMasterSettingInfo();
		
		try {
			info.setClockFrequency(2000);
			throw new Exception("TEST21_06: IllegalArgumentException not occur");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST21_06: IllegalArgumentException occur");
		}
		
		try {
			info.setDelay(SPIMasterSettingInfo.DELAY_TYPE_CS_HEAD, 1000000000);
			throw new Exception("TEST21_06: IllegalArgumentException not occur");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST21_06: IllegalArgumentException occur");
		}
		
		try {
			info.setDelay(SPIMasterSettingInfo.DELAY_TYPE_CS_HEAD, -100);
			throw new Exception("TEST21_06: IllegalArgumentException not occur");
		} catch (IllegalArgumentException e) {
			System.out.println("TEST21_06: IllegalArgumentException occur");
		}
		
		SPIMaster master = spi.getSPIMaster(specList.get(0), info);
		master.start();
		byte[] send = new byte[4];
		for (int i = 0; i < 4; i++) {
			send[i] = (byte)(0x30 + i);
		}
		byte[] recv = master.sendFullduplexFormat(send);
		if (recv.length != 4) {
			throw new Exception("TEST21_06: fail length");
		}
		HexUtil.dump(recv);
		master.stop();
		System.out.println("TEST21_06: pass");
	}
	public void Test21_07() throws Exception {
		System.out.println("TEST21_07: start");
		SPIConnection spi = (SPIConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_SPI);
		List<SPISpec> specList = spi.getSPISpec();
		SPIMasterSettingInfo info = new SPIMasterSettingInfo();
		SPIMaster master = spi.getSPIMaster(specList.get(0), info);
		byte[] send = new byte[4];
		for (int i = 0; i < 4; i++) {
			send[i] = (byte)(0x30 + i);
		}
		try {
			byte[] recv = master.sendFullduplexFormat(send);
			throw new Exception("TEST21_07: IllegalStateException not occur");
		} catch (IllegalStateException e) {
			System.out.println("TEST21_07: IllegalStateException occur");
		}
		System.out.println("TEST21_07: pass");

	}
}
