import java.io.File;
import java.util.List;


import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.net.AreaMailBox;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.SMSStatusReportBox;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageException;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.module.net.ShortMessageListener;
import com.docomo_um.module.net.ShortMessageManager;


public class SMSStatusReportTest {
	public void Test16_Initialize() {
		File file;
		for (int i = 1; i <= 8; i++) {
			file = new File(NetProperties.getInstance().getSMSDir() + "STATUS/" + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
	}
	boolean Test16_01_recv;
	boolean Test16_01_override;
	ShortMessage Test16_01_message;
	boolean bFull;
	public void Test16_01() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		SMSStatusReportBox statusBox = SMSMan.getSMSStatusReportBox();
		File file = new File(NetProperties.getInstance().getSMSDir() + "STATUS/");
		if (!file.exists()) {
			throw new Exception("TEST16_01: fail");
		}
		SMSMan.setShortMessageListener(new Test16_01_listener());
		for (int i = 1; i <= statusBox.getTotalMessageNumber(); i++) {
			Test16_01_recv = false;
			System.out.println("Please send status report mail from terminal.");
			while (!Test16_01_recv) {
				Thread.sleep(100);
			}
			int messageNumber = Test16_01_message.getMessageNumber();
			System.out.println("TEST16_01: receive message = " + String.valueOf((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER)));
			if ((messageNumber & ShortMessageFunctions.PREFIX_STATUSREPORT) == 0) {
				throw new Exception("TEST16_01: fail : not status report mail");
			}
			if ((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER) != i) {
				throw new Exception("TEST16_01: fail : invalid message number");
			}
			int num = statusBox.getSavedMessageNumber();
			System.out.println("TEST16_01: saved message number = " + String.valueOf(num));
			if (num != i) {
				throw new Exception("TEST16_01: fail : number of messages is invalid");
			}
			if (Test16_01_override) {
				throw new Exception("TEST16_01: fail : override is invalid");
			}
		}

		List<ShortMessage> list = statusBox.get(ShortMessage.STAT_UNREAD);
		if (list.size() != 0) {
			throw new Exception("TEST16_01: fail");
		}
		list = statusBox.get(ShortMessage.STAT_READ);
		if (list.size() != 8) {
			throw new Exception("TEST16_01: fail");
		}
		System.out.println("TEST16_01: pass");
	}
	public class Test16_01_listener implements ShortMessageListener {

		@Override
		public void onSMSReceived(MessageBox messageBox, int messageNumber,
				boolean override) {
			try {
				Test16_01_message = messageBox.get(messageNumber);
			} catch (DeviceException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (ExternalStatusException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (ShortMessageException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			Test16_01_override = override;
			Test16_01_recv = true;
		}

		@Override
		public void onAreaMailReceived(ShortMessage message,
				boolean override) {
			// TODO 自動生成されたメソッド・スタブ

		}

		@Override
		public void onSMSBoxFull(MessageBox messageBox) {
			bFull = true;
		}

	}
	public void Test16_02() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		SMSStatusReportBox statusBox = SMSMan.getSMSStatusReportBox();
		SMSMan.setShortMessageListener(new Test16_02_listener());
		for (int i = 1; i <= statusBox.getTotalMessageNumber(); i++) {
			Test16_01_recv = false;
			System.out.println("Please send status report mail from terminal.");
			while (!Test16_01_recv) {
				Thread.sleep(100);
			}
			int num = statusBox.getSavedMessageNumber();
			System.out.println("TEST16_01: saved message number = " + String.valueOf(num));
			if (num != 8) {
				throw new Exception("TEST16_02: fail : number of messages is invalid");
			}
			if (!Test16_01_override) {
				throw new Exception("TEST16_02: fail : override is invalid");
			}
		}
		bFull = false;
		System.out.println("Please send status report mail from terminal.");
		while (!bFull) {
			Thread.sleep(100);
		}
		System.out.println("mail box full");
		System.out.println("delete mail");
		statusBox.delete(ShortMessageFunctions.PREFIX_STATUSREPORT | 3);
		File file = new File(NetProperties.getInstance().getSMSDir() + "STATUS/3");
		if (file.exists()) {
			throw new Exception("TEST16_02: fail : override is invalid");
		}
		Test16_01_recv = false;
		System.out.println("Please send status report mail from terminal.");
		while (!Test16_01_recv) {
			Thread.sleep(100);
		}
		List<ShortMessage> list = statusBox.get(ShortMessage.STAT_READ);
		System.out.println("get STAT_READ = " + String.valueOf(list.size()));
		if (list.size() != 0) {
			throw new Exception("TEST16_02: fail");
		}
		list = statusBox.get(ShortMessage.STAT_UNREAD);
		System.out.println("get STAT_UNREAD = " + String.valueOf(list.size()));
		if (list.size() != 8) {
			throw new Exception("TEST16_02: fail");
		}
		list = statusBox.get(ShortMessage.STAT_READ);
		System.out.println("get STAT_READ = " + String.valueOf(list.size()));
		if (list.size() != 8) {
			throw new Exception("TEST16_02: fail");
		}
		statusBox.delete(SMSStatusReportBox.DELETE_TYPE_ALL);
		int num = statusBox.getSavedMessageNumber();
		if (num != 0) {
			throw new Exception("TEST16_02: fail");
		}
		System.out.println("TEST16_02: pass");
	}
	public class Test16_02_listener implements ShortMessageListener {

		@Override
		public void onSMSReceived(MessageBox messageBox, int messageNumber,
				boolean override) {
			Test16_01_override = override;
			Test16_01_recv = true;
		}

		@Override
		public void onAreaMailReceived(ShortMessage message,
				boolean override) {
			// TODO 自動生成されたメソッド・スタブ

		}

		@Override
		public void onSMSBoxFull(MessageBox messageBox) {
			bFull = true;
		}

	}
}
