import java.io.File;
import java.io.FileOutputStream;
import java.util.List;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.net.Mail;
import com.docomo_um.module.net.MailManager;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.POPClient;
import com.docomo_um.module.net.POPServerInfo;
import com.docomo_um.module.net.SMTPServerInfo;


public class PopClientTest {
	public void Test13_Initialize() {
		File file;
		for (int i = 0; i < 100; i++) {
			file = new File(NetProperties.getInstance().getMailDirectory() + "inbox/" + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
		file = new File(NetProperties.getInstance().getMailDirectory() + "inbox");
		if (file.exists()) {
			file.delete();
		}
		file = new File(NetProperties.getInstance().getMailDirectory());
		if (file.exists()) {
			file.delete();
		}
	}

	public void Test13_01() throws Exception {
		POPServerInfo popServer = new POPServerInfo("192.168.10.2", "account", "password");
		if (!popServer.getPOPServerName().equals("192.168.10.2")) {
			throw new Exception("TEST13_01: fail");
		}
		if (!popServer.getAccount().equals("account")) {
			throw new Exception("TEST13_01: fail");
		}
		if (!popServer.getPassword().equals("password")) {
			throw new Exception("TEST13_01: fail");
		}
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		System.out.println("accout =" + NetProperties.getInstance().getPOPAccount());
		System.out.println("passwd =" + NetProperties.getInstance().getPOPPassword());
		popClient.login();
		int num = popClient.receiveTotalMailNumbers();
		System.out.println("mail num = " + String.valueOf(num));
		if (num != 0) {
			throw new Exception("TEST13_01: fail : number of mail is not 0");
		}
		popClient.logout();
		System.out.println("TEST13_01: pass");
	}
	public void Test13_02() throws Exception {
		for (int i = 0; i < 6; i++) {
			File file = new File(NetProperties.getInstance().getMailDirectory() + "inbox/" + String.valueOf(i));
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			String from = "FROM=from" + String.valueOf(i) + "\n";
			fos.write(from.getBytes());
			String to = "TO=aa,bb,cc" + String.valueOf(i) + "\n";
			fos.write(to.getBytes());
			String cc = "CC=aaa,bbb,ccc" + String.valueOf(i) + "\n";
			fos.write(cc.getBytes());
			String bcc = "CC=aaaa,bbbb,cccc" + String.valueOf(i) + "\n";
			fos.write(bcc.getBytes());
			String subject = "SUBJECT=subject" + String.valueOf(i) + "\n";
			fos.write(subject.getBytes());
			String body = "BODY=mail" + String.valueOf(i) + "\n";
			fos.write(body.getBytes());
			fos.close();
		}

		POPServerInfo popServer = new POPServerInfo("ServerName", "account", "password");
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		System.out.println("accout =" + NetProperties.getInstance().getPOPAccount());
		System.out.println("passwd =" + NetProperties.getInstance().getPOPPassword());
		popClient.login();
		int num = popClient.receiveTotalMailNumbers();
		System.out.println("mail num = " + String.valueOf(num));
		if (num != 6) {
			throw new Exception("TEST13_02: fail : number of mail is not 6");
		}
		for (int i = 0; i < num; i++) {
			Mail mail = popClient.receiveMail(i);
			System.out.println("From = " + mail.getFromAddress());
			List<String> toList = mail.getToAddresses();
			String to = "TO = ";
			for (int j = 0; j < toList.size(); j++) {
				to += toList.get(j);
				to += ",";
			}
			System.out.println(to);
			List<String> ccList = mail.getCcAddresses();
			String cc = "CC = ";
			for (int j = 0; j < ccList.size(); j++) {
				cc += ccList.get(j);
				cc += ",";
			}
			System.out.println(cc);
			List<String> bccList = mail.getBccAddresses();
			String bcc = "BCC = ";
			for (int j = 0; j < bccList.size(); j++) {
				bcc += bccList.get(j);
				bcc += ",";
			}
			System.out.println(bcc);
			System.out.println("SUBJECT = " + mail.getSubject());
			System.out.println("BODY = " + mail.getBody());
		}
		popClient.logout();
		System.out.println("TEST13_02: pass");
	}
	public void Test13_03() throws Exception {
		POPServerInfo popServer = new POPServerInfo("ServerName", "_account", "_password");
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		try {
			popClient.login();
		}
		catch (IllegalSettingException e) {
			System.out.println("TEST13_03: pass");
			return;
		}
		throw new Exception("TEST13_03: fail");
	}
	public void Test13_04() throws Exception {
		POPServerInfo popServer = new POPServerInfo("ServerName", "account", "password");
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		try {
			// Loginせずにメール受信
			popClient.receiveMail(0);
		}
		catch (IllegalStateException e) {
			System.out.println("TEST13_04: pass");
			return;
		}
		throw new Exception("TEST13_04: fail");
	}
	public void Test13_05() throws Exception {
		POPServerInfo popServer = new POPServerInfo("ServerName", "account", "password");
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		popClient.login();
		popClient.deleteMail(0);
		File file = new File(NetProperties.getInstance().getMailDirectory() + "inbox/0");
		if (file.exists()) {
			throw new Exception("TEST13_05: fail");
		}
		int num = popClient.receiveTotalMailNumbers();
		System.out.println("mail num = " + String.valueOf(num));
		if (num != 5) {
			throw new Exception("TEST13_01: fail : number of mail is not 5");
		}
		popClient.logout();
		System.out.println("TEST13_05: pass");
	}
	public void Test13_06() throws Exception {
		POPServerInfo popServer = new POPServerInfo("ServerName", "account", "password");
		MailManager mailMan = MailManager.getInstance();
		POPClient popClient = mailMan.getPOPClient(popServer, false);
		popClient.login();
		System.out.println("Please set enable CommunicationFailureException on terminal");
		while (!ModuleProperties.getInstance().getCommunicationFailureException()) {
			Thread.sleep(100);
		}
		try {
			popClient.receiveMail(0);
		}
		catch (CommunicationFailureException e) {
			System.out.println("TEST13_06: pass");
			ModuleProperties.getInstance().setCommunicationFailureException(false);
			return;
		}
		throw new Exception("TEST13_06: fail");
	}
}
