
import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.net.IPSettingInfo;
import com.docomo_um.module.net.ModemController;
import com.docomo_um.module.net.ModemControllerListener;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.PDPTypeInfo;
import com.docomo_um.module.net.PPPSettingInfo;
import com.docomo_um.module.net.PacketController;
import com.docomo_um.module.net.PacketSession;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;


public class PacketControllerTest {
	Session receivedSession;
	int sessionStatus;
	public void Test08_01() throws Exception {
		IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_NONE, null, null);
		settingInfo.setAllocatingIP(IPSettingInfo.ALLOCATING_IP_STATIC);
		settingInfo.setIPAddress("192.168.10.1");
		String ipaddr = settingInfo.getIPAddress();
		if (!ipaddr.equals("192.168.10.1")) {
			throw new Exception("TEST08_01: fail");
		}
		boolean exception = false;
		try {
			settingInfo.setIPAddress("192.168.10.a");
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_01: fail");
		}
		exception = false;
		try {
			settingInfo.setIPAddress("192.168.10");
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_01: fail");
		}
		exception = false;
		try {
			settingInfo.setIPAddress("192.300.10.1");
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_01: fail");
		}
		exception = false;
		try {
			settingInfo.setIPAddress("127.0.0.1");
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_01: fail");
		}
		PacketController packetController = ModuleManager.getInstance().getPacketController();
		packetController.setModemControllerListener(new Test08_01_Listener());
		PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
		sessionStatus = session.getConnectedStatus();
		if (sessionStatus != Session.CONNECTION_STATUS_DISCONNECT) {
			throw new Exception("TEST08_01: fail");
		}
		session.setPDPTypeInfo(settingInfo);
		settingInfo = (IPSettingInfo) session.getPDPTypeInfo();
		if (settingInfo.getPDPType() != PDPTypeInfo.PDP_TYPE_IP) {
			throw new Exception("TEST08_01: fail");
		}
		if (settingInfo.getIPAuthentication() != IPSettingInfo.IP_AUTHENTICATION_NONE) {
			throw new Exception("TEST08_01: fail");
		}

		session.send();
		sessionStatus = session.getConnectedStatus();
		if (sessionStatus != Session.CONNECTION_STATUS_OUTGOING_CALL) {
			throw new Exception("TEST08_01: fail");
		}
		System.out.println("TEST08_01: CONNECTION_STATUS_OUTGOING_CALL");
		System.out.println("TEST08_01: Please receive on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		Session connected = packetController.getConnectedSession();
		if (connected != null) {
			System.out.println("TEST08_01: connected " + connected.getDestination());
		}
		else {
			throw new Exception("TEST08_01: fail");
		}
		System.out.println("TEST08_01: Please disconnect on terminal ");
		while (session.getConnectedStatus() != Session.CONNECTION_STATUS_DISCONNECT) {
			Thread.sleep(100);
		}
		System.out.println("TEST08_01: disconnected aaa.co.jp");
		System.out.println("TEST08_01: pass");

	}
	private class Test08_01_Listener implements ModemControllerListener {
		@Override
		public void onReceived(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST08_01: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}
		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			int prevStatus = sessionStatus;
			sessionStatus = session.getConnectedStatus();
			System.out.println("TEST08_01: onChangedStatus " + prevStatus + "->" + sessionStatus);
		}
	}
	public void Test08_02() throws Exception {
		PacketController packetController = ModuleManager.getInstance().getPacketController();
		packetController.setModemControllerListener(new Test08_02_Listener());
//		PacketSession session = (PacketSession) packetController.createSession("AAA.NE.JP");
//		sessionStatus = session.getConnectedStatus();
//		session.setPDPTypeInfo(new myPDP());
		receivedSession = null;
		System.out.println("Prease send form Terminal.");
		while (receivedSession == null) {
			Thread.sleep(100);
		}
		receivedSession.disconnect();
		while (receivedSession.getConnectedStatus() == Session.CONNECTION_STATUS_CONNECT) {
			Thread.sleep(100);
		}
		System.out.println("TEST08_02: pass");

	}
	private class Test08_02_Listener implements ModemControllerListener {

		@Override
		public void onReceived(ModemController controller, Session session) {
			sessionStatus = session.getConnectedStatus();
			receivedSession = session;
			System.out.println("TEST08_02: onReceived " + session.getDestination());
			try {
				((PacketSession)session).setPDPTypeInfo(new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_NONE, null, null));
				session.receive();
			} catch (SessionException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (CommunicationFailureException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (IllegalSettingException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}

		@Override
		public void onChangedStatus(ModemController controller, Session session) {
			// TODO 自動生成されたメソッド・スタブ

		}
	}
	public void Test08_03() throws Exception {
		IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_NONE, null, null);
		PacketController packetController = ModuleManager.getInstance().getPacketController();
		packetController.setModemControllerListener(new Test08_01_Listener());
		PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
		sessionStatus = session.getConnectedStatus();
		if (sessionStatus != Session.CONNECTION_STATUS_DISCONNECT) {
			throw new Exception("TEST08_01: fail");
		}
		session.setPDPTypeInfo(settingInfo);
		System.out.println("Please set enable CommunicationFailureException on terminal.");
		while (!ModuleProperties.getInstance().getCommunicationFailureException()) {
			Thread.sleep(100);
		}
		boolean exception = false;
		try {
			session.send();
		} catch (CommunicationFailureException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_03: fail");
		}
		System.out.println("Please set disable CommunicationFailureException on terminal.");
		while (ModuleProperties.getInstance().getCommunicationFailureException()) {
			Thread.sleep(100);
		}
		System.out.println("Please set enable SessionException on terminal.");
		while (!NetProperties.getInstance().getSessionException()) {
			Thread.sleep(100);
		}
		exception = false;
		try {
			session.send();
		} catch (SessionException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_03: fail");
		}
		System.out.println("Please set disable SessionException on terminal.");
		while (NetProperties.getInstance().getSessionException()) {
			Thread.sleep(100);
		}
		System.out.println("Please set to false UIM on terminal.");
		while (ModuleProperties.getInstance().getUIM()) {
			Thread.sleep(100);
		}
		exception = false;
		try {
			session.send();
		} catch (ExternalStatusException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST08_03: fail");
		}
		ModuleProperties.getInstance().setUIM(true);
		System.out.println("TEST08_03: pass");
	}
	public void Test08_04() throws Exception {
		boolean bException = false;
		try {
			IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_04: fail");
		}
		bException = false;
		try {
			IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.a");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_04: fail");
		}
		bException = false;
		try {
			IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_PAP, "user", "passwd", "127.0.0.1");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_04: fail");
		}
		bException = false;
		try {
			IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.10", "aaa", "10.10.10.10");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_04: fail");
		}
		bException = false;
		try {
			IPSettingInfo settingInfo = new IPSettingInfo(IPSettingInfo.IP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.10", "192.168.22.22", "127.0.0.1");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_04: fail");
		}
		System.out.println("TEST08_04: pass");
	}
	public void Test08_05() throws Exception {
		boolean bException = false;
		try {
			PPPSettingInfo settingInfo = new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_CHAP, "user", "passwd", "10.10.10");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_05: fail");
		}
		bException = false;
		try {
			PPPSettingInfo settingInfo = new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.a");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_05: fail");
		}
		bException = false;
		try {
			PPPSettingInfo settingInfo = new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_PAP, "user", "passwd", "127.0.0.1");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_05: fail");
		}
		bException = false;
		try {
			PPPSettingInfo settingInfo = new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.10", "aaa", "10.10.10.10");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_05: fail");
		}
		bException = false;
		try {
			PPPSettingInfo settingInfo = new PPPSettingInfo(PPPSettingInfo.PPP_AUTHENTICATION_PAP, "user", "passwd", "10.10.10.10", "192.168.22.22", "127.0.0.1");
			PacketController packetController = ModuleManager.getInstance().getPacketController();
			packetController.setModemControllerListener(new Test08_01_Listener());
			PacketSession session = (PacketSession) packetController.createSession("aaa.ne.jp");
			session.setPDPTypeInfo(settingInfo);
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST08_05: fail");
		}
		System.out.println("TEST08_05: pass");
	}
}
