﻿import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.PINManager;


public class PINManagerTest {
	/**
	 * PIN1コードの照合
	 * @throws Exception
	 */
	public void Test05_01() throws Exception {
		PINManager pin = ModuleManager.getInstance().getPINManager();
		pin.verifyPIN1Code("9876");
		if (pin.getPINStatus() != PINManager.STATUS_READY) {
			throw new Exception("TEST05_01: fail");
		}
		System.out.println("TEST05_01: pass");
	}
	/**
	 * PIN1コードの変更
	 * @throws Exception
	 */
	public void Test05_02() throws Exception {
		PINManager pin = ModuleManager.getInstance().getPINManager();
		try {
			//PIN1コードは4桁固定です
			//4桁以外の桁数を使用すると例外が発生します
			pin.changePIN1Code("98751243", "12345678");
		}
		catch (ExternalStatusException e) {
			throw new Exception("TEST05_02: fail");
		}
		if (pin.getPINStatus() != PINManager.STATUS_READY) {
			throw new Exception("TEST05_02: fail");
		}
		System.out.println("TEST05_02: pass");
	}
	/**
	 * PIN1コードの照合失敗
	 * @throws Exception
	 */
	public void Test05_03() throws Exception {
		boolean bException = false;
		PINManager pin = ModuleManager.getInstance().getPINManager();
		try {
			pin.verifyPIN1Code("99999999");
		}
		catch (IllegalArgumentException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST05_03: fail");
		}
		if (pin.getPINStatus() != PINManager.STATUS_WAIT_PIN1) {
			throw new Exception("TEST05_03: fail");
		}
		//PIN1コードは4桁固定です
		//4桁以外の桁数を使用すると例外が発生します
		pin.verifyPIN1Code("98751243");
		if (pin.getPINStatus() != PINManager.STATUS_READY) {
			throw new Exception("TEST05_03: fail");
		}
		System.out.println("TEST05_03: pass");
	}
	/**
	 * PIN1ロックの解除
	 * @throws Exception
	 */
	public void Test05_04() throws Exception {
		boolean bException = false;
		PINManager pin = ModuleManager.getInstance().getPINManager();
		for (int i = 0; i < 3; i++) {
			int pin1lockCount = pin.getPIN1LockRemainCount();
			System.out.println("Pin1 lock = " + String.valueOf(pin1lockCount));
			if (pin1lockCount != 3-i) {

			}
			bException = false;
			try {
				pin.verifyPIN1Code("9999");
			}
			catch (IllegalArgumentException e) {
				bException = true;
			}
			if (!bException) {
				throw new Exception("TEST05_04: fail");
			}
		}
		if (pin.getPINStatus() != PINManager.STATUS_LOCK_PIN1) {
			throw new Exception("TEST05_04: fail");
		}
		try {
			//PIN1ロック解除コードは8桁固定です
			//8桁以外の桁数を使用すると例外が発生します
			//PIN1コードは4桁固定です
			//4桁以外の桁数を使用すると例外が発生します
			pin.unlockPIN1Code("1242","1234");
		}
		catch (IllegalArgumentException e) {
			throw new Exception("TEST05_04: fail");
		}
		System.out.println("TEST05_04: pass");
	}
	/**
	 * フルロック
	 * @throws Exception
	 */
	public void Test05_05() throws Exception {
		boolean bException = false;
		PINManager pin = ModuleManager.getInstance().getPINManager();
		for (int i = 0; i < 3; i++) {
			bException = false;
			try {
				pin.verifyPIN1Code("9999");
			}
			catch (IllegalArgumentException e) {
				bException = true;
			}
			if (!bException) {
				throw new Exception("TEST05_05: fail");
			}
		}
		if (pin.getPINStatus() != PINManager.STATUS_LOCK_PIN1) {
			throw new Exception("TEST05_05: fail");
		}
		for (int i = 0; i < 10; i++) {
			bException = false;
			int fulllockCount = pin.getFullLockRemainCount();
			System.out.println("Full lock = " + String.valueOf(fulllockCount));
			if (fulllockCount != 10 - i) {
				throw new Exception("TEST05_05: fail");
			}
			try {
				pin.unlockPIN1Code("99999999","1234");
			}
			catch (IllegalArgumentException e) {
				bException = true;
			}
			if (!bException) {
				throw new Exception("TEST05_05: fail");
			}
		}
		if (pin.getPINStatus() != PINManager.STATUS_FULL_LOCK) {
			throw new Exception("TEST05_05: fail");
		}
		try {
			pin.unlockPIN1Code("99999999","1234");
			throw new Exception("TEST05_05: fail");
		}
		catch (ExternalStatusException e) {
		}

		System.out.println("TEST05_05: pass");
	}
	/**
	 * PIN1コードの無効化
	 * @throws Exception
	 */
	public void Test05_06() throws Exception {
		PINManager pin = ModuleManager.getInstance().getPINManager();
		pin.verifyPIN1Code("9876");
		if (pin.getPINStatus() != PINManager.STATUS_READY) {
			throw new Exception("TEST05_06: fail");
		}
		pin.setPIN1CodeEnable(false, "9876");
		if (ModuleProperties.getInstance().getPIN1Enable()) {
			throw new Exception("TEST05_06: fail");
		}
		System.out.println("TEST05_06: pass");

	}
}
