import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.docomo_um.io.IOProperties;
import com.docomo_um.io.NVMAccessManager;


public class NVMAccessManagerTest {
	String filename = "nvm";
	/**
	 * 初期化
	 * NVMのファイルおよびディレクトリを削除
	 */
	public void Test02_Initialize() {
		File file = new File(IOProperties.getInstance().getNVMDir() + filename);
		if (file.exists()) {
			file.delete();
		}
		file = new File(IOProperties.getInstance().getNVMDir());
		if (file.exists()) {
			file.delete();
		}
	}
	/**
	 * インスタンス生成時にNVMのディレクトリおよびファイルが作成されることを確認
	 *
	 * @throws Exception
	 */
	public void Test02_01() throws Exception {
		NVMAccessManager instance = NVMAccessManager.getInstance();
		System.out.println("TEST02_01: NVM available memory size = " + String.valueOf(instance.getAvailableMemorySize()));
		File file = new File(IOProperties.getInstance().getNVMDir() + filename);
		if (!file.exists()) {
			throw new Exception("TEST02_01: fail");
		}
		System.out.println("TEST02_01: check:" + file.getName() + " exists");
		int sz = (int) file.length();
		System.out.println("TEST02_01: file size = " + String.valueOf(sz));
		if (sz != IOProperties.getInstance().getNVMSize()) {
			throw new Exception("TEST02_01: fail");
		}
		System.out.println("TEST02_01: pass");
	}
	/**
	 * NVMへの入出力の確認
	 *
	 * @throws Exception
	 */
	public void Test02_02() throws Exception {
		NVMAccessManager instance = NVMAccessManager.getInstance();
		byte[] buf = new byte[256];
		for (int i = 0; i < 256; i++) {
			buf[i] = (byte)i;
		}
		OutputStream os = instance.openOutputStream(0);
		os.write(buf);
		System.out.println("TEST02_02: NVM available memory size = " + String.valueOf(instance.getAvailableMemorySize()));
		if (instance.getAvailableMemorySize() != IOProperties.getInstance().getNVMSize()) {
			throw new Exception("TEST02_02: fail");
		}
		os.close();
		System.out.println("TEST02_02: verify");
		InputStream is = instance.openInputStream(0);
		for (int i = 0; i < 256; i++) {
			int b = is.read();
			System.out.print(String.valueOf(b) + " ");
			if (b == -1) {
				throw new Exception("TEST02_02: fail");
			}
			if (buf[i] != (byte)b) {
				throw new Exception("TEST02_02: fail");
			}
		}
		is.close();
		System.out.println("\nTEST02_02: pass");
	}
	/**
	 * NVMの最大サイズを超えて書き込みを行った場合の確認
	 *
	 * @throws Exception
	 */
	public void Test02_03() throws Exception {
		boolean bCatch = false;
		NVMAccessManager instance = NVMAccessManager.getInstance();
		OutputStream os = instance.openOutputStream(IOProperties.getInstance().getNVMSize()-1);
		System.out.println("TEST02_03: 1 byte write");
		os.write(0xff);
		System.out.println("TEST02_03: 1 byte write ok");
		try {
			System.out.println("TEST02_03: 1 byte write");
			os.write(0xff);
		} catch (IOException e) {
			System.out.println("TEST02_03: cach IOException");
			bCatch = true;
		}
		if (!bCatch) {
			throw new Exception("TEST02_03: fail");
		}
		os.close();
		System.out.println("TEST02_03: pass");
	}
	/**
	 * NVMの最大サイズを超えて読み込みを行った場合の確認
	 *
	 * @throws Exception
	 */
	public void Test02_04() throws Exception {
		NVMAccessManager instance = NVMAccessManager.getInstance();
		InputStream is = instance.openInputStream(IOProperties.getInstance().getNVMSize()-1);
		System.out.println("TEST02_04: 1 byte read");
		int b = is.read();
		if (b == -1) {
			throw new Exception("TEST02_04: fail");
		}
		System.out.println("TEST02_04: 1 byte read:" + String.valueOf(b) + " OK");
		System.out.println("TEST02_04: 1 byte read");
		b = is.read();
		if (b != -1) {
			throw new Exception("TEST02_04: fail");
		}
		System.out.println("TEST02_04: 1 byte read:" + String.valueOf(b) + " OK");
		is.close();
		System.out.println("TEST02_04: pass");
	}
}
