import java.util.List;

import com.docomo_um.module.Application;
import com.docomo_um.module.ModuleListener;
import com.docomo_um.module.ModuleManager;


public class ModuleManagerTest {
	boolean bReset;
	boolean bSystemUpdate;
	boolean bSystemUpdateAbort;
	/**
	 * ターミナルからのイベントによりリスナが呼び出されることを確認
	 *
	 * @throws Exception
	 */
	public void Test04_01() throws Exception {
		ModuleManager instance = ModuleManager.getInstance();
		if (instance == null) {
			throw new Exception("TEST04_01: fail");
		}
		instance.setModuleListener(new moduleListener());
		bReset = false;
		System.out.println("TEST04_01: Please request RESET on Terminal.");
		while (!bReset) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST04_01: fail");
			}
		}
		bSystemUpdate = false;
		System.out.println("TEST04_01: Please request SYSTEMUPDATE on Terminal.");
		while (!bSystemUpdate) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST04_01: fail");
			}
		}
		bSystemUpdateAbort = false;
		System.out.println("TEST04_01: Please request SYSTEMUPDATEABORT on Terminal.");
		while (!bSystemUpdateAbort) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST04_01: fail");
			}
		}
		System.out.println("TEST04_01: pass");
	}
	public class moduleListener implements ModuleListener {

		@Override
		public void onReset() {
			bReset = true;
		}

		@Override
		public void onSystemUpdate() {
			bSystemUpdate = true;
		}

		@Override
		public void onSystemUpdateAbort(int abortStatus) {
			bSystemUpdateAbort = true;
		}

	}
	/**
	 * アプリケーションリストの取得
	 *
	 * @throws Exception
	 */
	public void Test04_02() throws Exception {
		ModuleManager instance = ModuleManager.getInstance();
		List<Application> appList = instance.getApplicationList();
		for (int i = 0; i < appList.size(); i++) {
			Application app = appList.get(i);
			System.out.println("area name = " + app.getApplicationAreaName());
			System.out.println("     name = " + app.getName());
		}
		System.out.println("TEST04_02: pass");
	}
	/**
	 * システムアップデートの実行状態
	 *
	 * @throws Exception
	 */
	public void Test04_03() throws Exception {
		ModuleManager instance = ModuleManager.getInstance();
		instance.setModuleListener(new moduleListener());
		int status;
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_IDLE) {
			throw new Exception("TEST04_03: fail");
		}
		instance.updateSystem();
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_DOWNLOADING) {
			throw new Exception("TEST04_03: fail");
		}
		bReset = false;
		System.out.println("TEST04_03: Please request RESET on Terminal.");
		while (!bReset) {
			Thread.sleep(100);
		}
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_DOWNLOAD_COMPLETE) {
			throw new Exception("TEST04_03: fail status = " + String.valueOf(status));
		}
		instance.reset();
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_REWRITING) {
			throw new Exception("TEST04_03: fail");
		}

		System.out.println("TEST04_03: pass");
	}
	/**
	 * システムアップデートの中断
	 *
	 * @throws Exception
	 */
	public void Test04_04() throws Exception {
		ModuleManager instance = ModuleManager.getInstance();
		instance.setModuleListener(new moduleListener());
		int status;
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_IDLE) {
			throw new Exception("TEST04_03: fail");
		}
		instance.updateSystem();
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_DOWNLOADING) {
			throw new Exception("TEST04_03: fail");
		}
		instance.cancelSystemUpdate();
		status = instance.getSystemUpdateStatus();
		if (status != ModuleManager.SYSTEM_UPDATE_IDLE) {
			throw new Exception("TEST04_03: fail");
		}
		System.out.println("TEST04_04: pass");
	}
	/**
	 * アプリケーションの変更と電源断
	 *
	 * @throws Exception
	 */
	public void Test04_05() throws Exception {
		ModuleManager instance = ModuleManager.getInstance();
		List<Application> appList = instance.getApplicationList();
		instance.changeApplication(appList.get(0));
		instance.turnOff();
		System.out.println("TEST04_05: pass");
	}

}
