import com.docomo_um.module.ModuleException;
import com.docomo_um.module.ModuleInfo;
import com.docomo_um.module.ModuleProperties;


public class ModuleInfoTest {
	public void Test03_01() throws Exception {
		ModuleInfo info = new ModuleInfo();
		System.out.println("TEST03_01:   Module Version: " + info.getModuleVersion());
		System.out.println("TEST03_01: Telephone Number: " + info.getTelephoneNumber());
		System.out.println("TEST03_01:      ICCID Number: " + info.getICCID());
		System.out.println("TEST03_01:             IMIE: " + info.getIMEI());
		System.out.println("TEST03_01:           IMIESV: " + info.getIMEISV());
		try {
			System.out.println("TEST03_01:        Area Info: " + info.getAreaInfo());
		} catch (ModuleException e) {
			throw new Exception("TEST03_01: fail");
		}
		System.out.println("TEST03_01:   Received Power: " + info.getReceivedPowerIndicator());
		try {
			System.out.println("TEST03_01:       Regulation: " + info.getRegulationStatus());
		} catch (ModuleException e) {
			throw new Exception("TEST03_01: fail");
		}
		System.out.println("TEST03_01:    Signal Status: " + info.getSignalStatus());

		System.out.println("TEST03_01: pass");
	}
	public void Test03_02() throws Exception {
		ModuleInfo info = new ModuleInfo();
		int status = info.getSignalStatus();
		int newStatus = status;
		System.out.println("TEST03_02: Signal Status: " + status);
		System.out.println("TEST03_02: Please change signal status on Terminal.");
		while (status == (newStatus = info.getSignalStatus())) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST03_02: fail");
			}
		}
		System.out.println("TEST03_02:" + status + " -> " + newStatus);
		System.out.println("TEST03_02: pass");
	}
	public void Test03_03() throws Exception {
		ModuleInfo info = new ModuleInfo();
		int area = info.getAreaInfo();
		int newArea;
		System.out.println("TEST03_03: Area Info: " + area);
		System.out.println("TEST03_03: Please change area info on Terminal.");
		while (area == (newArea = info.getAreaInfo())) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST03_03: fail");
			}
		}
		System.out.println("TEST03_03: " + area + " -> " + newArea);
		System.out.println("TEST03_03: pass");
	}
	public void Test03_04() throws Exception {
		ModuleInfo info = new ModuleInfo();
		int reg = info.getRegulationStatus();
		int newReg;
		System.out.println("TEST03_04: Regulation status: " + reg);
		System.out.println("TEST03_04: Please change regulation status on Terminal.");
		while (reg == (newReg = info.getRegulationStatus())) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST03_04: fail");
			}
		}
		System.out.println("TEST03_04: " + reg + " -> " + newReg);

		System.out.println("TEST03_04: pass");
		ModuleProperties.getInstance().setRegulation(0);
	}
	public void Test03_05() throws Exception {
		ModuleInfo info = new ModuleInfo();
		int power = info.getReceivedPowerIndicator();
		int newPower;
		System.out.println("TEST03_05: Received power: " + power);
		System.out.println("TEST03_05: Please change received power on Terminal.");
		while (power == (newPower = info.getReceivedPowerIndicator())) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST03_05: fail");
			}
		}
		System.out.println("TEST03_05: " + power + " -> " + newPower);
		System.out.println("TEST03_05: pass");
	}
	public void Test03_06() throws Exception {
		ModuleInfo info = new ModuleInfo();
		try {
			System.out.println("TEST03_06:    Area Info: " + info.getAreaInfo());
		} catch (ModuleException e) {
			throw new Exception("TEST03_06: fail");
		}
		try {
			System.out.println("TEST03_06:   Regulation: " + info.getRegulationStatus());
		} catch (ModuleException e) {
			throw new Exception("TEST03_06: fail");
		}
		System.out.println("TEST03_06: Please change ModuleException status on Terminal.");
		while (ModuleProperties.getInstance().getModuleException() == false) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new Exception("TEST03_06: fail");
			}
		}
		boolean bException = false;
		try {
			System.out.println("TEST03_06:    Area Info: " + info.getAreaInfo());
		} catch (ModuleException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST03_06: fail");
		}
		bException = false;
		try {
			System.out.println("TEST03_06:   Regulation: " + info.getRegulationStatus());
		} catch (ModuleException e) {
			bException = true;
		}
		if (!bException) {
			throw new Exception("TEST03_06: fail");
		}
		ModuleProperties.getInstance().setModuleException(false);
		System.out.println("TEST03_06: pass");
	}
}
