import com.docomo_um.util.MessageDigest;


public class MessageDigestTest {
	byte[] result1 = { (byte)0xd4, (byte)0x1d, (byte)0x8c, (byte)0xd9, (byte)0x8f, (byte)0x00, (byte)0xb2, (byte)0x04, (byte)0xe9, (byte)0x80, (byte)0x09, (byte)0x98, (byte)0xec, (byte)0xf8, (byte)0x42, (byte)0x7e };
	byte[] result2 = { (byte)0x0c, (byte)0xc1, (byte)0x75, (byte)0xb9, (byte)0xc0, (byte)0xf1, (byte)0xb6, (byte)0xa8, (byte)0x31, (byte)0xc3, (byte)0x99, (byte)0xe2, (byte)0x69, (byte)0x77, (byte)0x26, (byte)0x61 };
	byte[] result3 = { (byte)0x90, (byte)0x01, (byte)0x50, (byte)0x98, (byte)0x3c, (byte)0xd2, (byte)0x4f, (byte)0xb0, (byte)0xd6, (byte)0x96, (byte)0x3f, (byte)0x7d, (byte)0x28, (byte)0xe1, (byte)0x7f, (byte)0x72 };
	byte[] result4 = { (byte)0xf9, (byte)0x6b, (byte)0x69, (byte)0x7d, (byte)0x7c, (byte)0xb7, (byte)0x93, (byte)0x8d, (byte)0x52, (byte)0x5a, (byte)0x2f, (byte)0x31, (byte)0xaa, (byte)0xf1, (byte)0x61, (byte)0xd0 };
	byte[] result5 = { (byte)0xc3, (byte)0xfc, (byte)0xd3, (byte)0xd7, (byte)0x61, (byte)0x92, (byte)0xe4, (byte)0x00, (byte)0x7d, (byte)0xfb, (byte)0x49, (byte)0x6c, (byte)0xca, (byte)0x67, (byte)0xe1, (byte)0x3b };
	byte[] result6 = { (byte)0xd1, (byte)0x74, (byte)0xab, (byte)0x98, (byte)0xd2, (byte)0x77, (byte)0xd9, (byte)0xf5, (byte)0xa5, (byte)0x61, (byte)0x1c, (byte)0x2c, (byte)0x9f, (byte)0x41, (byte)0x9d, (byte)0x9f };
	byte[] result7 = { (byte)0x57, (byte)0xed, (byte)0xf4, (byte)0xa2, (byte)0x2b, (byte)0xe3, (byte)0xc9, (byte)0x55, (byte)0xac, (byte)0x49, (byte)0xda, (byte)0x2e, (byte)0x21, (byte)0x07, (byte)0xb6, (byte)0x7a };

	public void Test24_01() throws Exception {
		MessageDigest md5 = MessageDigest.getInstance(MessageDigest.HASH_ALGORITHM_TYPE_MD5);
		byte[] digest = new byte[MessageDigest.getInstance(MessageDigest.HASH_ALGORITHM_TYPE_MD5).getDigestLength()];
		String algorithm = md5.getAlgorithm();
		if (!algorithm.equals(MessageDigest.HASH_ALGORITHM_TYPE_MD5)) {
			throw new Exception("TEST24_01: faile");
		}

		String msg = "";
		md5.update(msg.getBytes());
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result1)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "a";
		md5.update((byte)'a');
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result2)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "a";
		digest = md5.digest(msg.getBytes());
		if (!MessageDigest.isEqual(digest, result2)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "a";
		md5.update(msg.getBytes());
		md5.reset();
		msg = "abc";
		md5.update(msg.getBytes());
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result3)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = " message digest ";
		md5.update(msg.getBytes(), 1, 14);
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result4)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "abcdefghijklmnopqrstuvwxyz";
		md5.update(msg.getBytes());
		md5.digest(digest, 0);
		if (!MessageDigest.isEqual(digest, result5)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
		md5.update(msg.getBytes());
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result6)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
		md5.update(msg.getBytes());
		digest = md5.digest();
		if (!MessageDigest.isEqual(digest, result7)) {
			throw new Exception("TEST24_01: faile");
		}
		msg = " message digest ";
		boolean exception = false;
		try {
			md5.update(msg.getBytes(), -1, 14);
		} catch (ArrayIndexOutOfBoundsException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST24_01: faile");
		}
		exception = false;
		try {
			md5.update(msg.getBytes(), 0, -1);
		} catch (ArrayIndexOutOfBoundsException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST24_01: faile");
		}
		exception = false;
		try {
			md5.update(new byte[0], 0, -1);
		} catch (ArrayIndexOutOfBoundsException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST24_01: faile");
		}
		exception = false;
		try {
			md5.update(null, 0, 14);
		} catch (NullPointerException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST24_01: faile");
		}
		System.out.println("TEST24_01: pass");
	}

}
