﻿import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.I2CConnection;
import com.docomo_um.module.connection.I2CDevice;
import com.docomo_um.module.connection.I2CListener;
import com.docomo_um.module.connection.I2CMaster;
import com.docomo_um.module.connection.I2CSlave;
import com.docomo_um.module.connection.I2CSpec;


public class I2CTest {
	/**
	 * I2CSpecのリストを取得
	 * @throws Exception
	 */
	public void Test18_01() throws Exception {
		I2CConnection i2c = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_I2C);
		List<I2CSpec> specList = i2c.getI2CSpec();
		for (int i = 0; i < specList.size(); i++) {
			I2CSpec spec = specList.get(i);
			System.out.println("DeviceName = " + spec.getDeviceName());
			List<Integer> sizeList = spec.getAddressSizeList();
			System.out.println("AddressSizeList = " + sizeList.toString());
			List<Long> speedList = spec.getCommSpeedList();
			System.out.println("SpeedList = " + speedList.toString());
			int mode = spec.getCommMode();
			System.out.println("CommMode = " + String.valueOf(mode));
		}
		System.out.println("TEST18_01: pass");
	}
	/**
	 * マスタの入出力を確認
	 * @throws Exception
	 */
	public void Test18_02() throws Exception {
		boolean exception = false;
		I2CConnection i2c = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_I2C);
		List<I2CSpec> specList = i2c.getI2CSpec();
		I2CMaster master = i2c.getI2CMaster(specList.get(0), 10);
		try {
			master.setCommSpeed(1);
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST18_02: fail");
		}
		master.setCommSpeed(3400000);
		if (master != i2c.getI2CMaster(specList.get(0), 10)) {
			throw new Exception("TEST18_02: fail");
		}
		master.start();
		InputStream is = master.getInputStream();
		OutputStream os = master.getOutputStream();
		int data = 0;
		for (int i = 0; i < 256; i++) {
			if ((data = is.read()) == -1) {
				break;
			}
			System.out.println("data = " + String.valueOf(data));
			os.write(data);
		}
		master.stop();
		master = i2c.getI2CMaster(specList.get(0), 5);
		master.setCommSpeed(3400000);
		master.start();
		is = master.getInputStream();
		os = master.getOutputStream();
		exception = false;
		try {
			is.read();
		}
		catch (IOException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST18_02: fail");
		}
		exception = false;
		try {
			os.write(data);
		}
		catch (IOException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST18_02: fail");
		}
		master.stop();
		System.out.println("TEST18_02: pass");
	}
	/**
	 * 書き込みと読み込みの組み合わせ
	 *
	 * @throws Exception
	 */
	public void Test18_03() throws Exception {
		I2CConnection i2c = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_I2C);
		List<I2CSpec> specList = i2c.getI2CSpec();
		I2CMaster master = i2c.getI2CMaster(specList.get(0), 10);
		master.start();
		byte[] readbuf;
		byte[] writebuf = new byte[2];
		for (int i = 0; i < 256; i+=2) {
			writebuf[0] = (byte)i;
			writebuf[1] = (byte)(i+1);
			readbuf = master.sendCombinedFormat(writebuf, 2);
			System.out.println(String.valueOf((int)readbuf[0]) + "," + String.valueOf((int)readbuf[1]));
		}
		System.out.println("Please set TRUE IOException on terminal.");
		while (!ConnectionProperties.getInstance().getIOException()) {
			Thread.sleep(100);
		}
		boolean exception = false;
		try {
			for (int i = 0; i < 256; i+=2) {
				writebuf[0] = (byte)i;
				writebuf[1] = (byte)(i+1);
				readbuf = master.sendCombinedFormat(writebuf, 2);
				System.out.println(String.valueOf((int)readbuf[0]) + "," + String.valueOf((int)readbuf[1]));
			}
		}
		catch (IOException e) {
			exception = true;
		}
		ConnectionProperties.getInstance().setIOExcepton(false, null);
		if (!exception) {
			throw new Exception("TEST18_03: fail");
		}
		master.stop();
		System.out.println("TEST18_03: pass");
	}
	/**
	 * マスタとして実行後、スレーブのインスタンスを取得できないこと
	 * @throws Exception
	 */
	public void Test18_04() throws Exception {
		I2CConnection i2c = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_I2C);
		List<I2CSpec> specList = i2c.getI2CSpec();
		try {
			int data = 0;
			I2CSlave slave = i2c.getI2CSlave(specList.get(0), 10);
			OutputStream os = slave.getOutputStream();
			os.write(data);
		} catch (IllegalStateException e) {
			System.out.println("TEST18_04: pass");
			return;
		}
		throw new Exception("TEST18_04: fail");
	}
	/**
	 * スレーブの入出力
	 */
/*
	boolean received;
	public void Test18_05() throws Exception {
		I2CConnection i2c = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_I2C);
		List<I2CSpec> specList = i2c.getI2CSpec();
		I2CSlave slave = i2c.getI2CSlave(specList.get(0), 10);
		slave.setI2CListener(new Test18_05_listener());
		System.out.println("Please send data from terminal.");
		received = false;
		while (!received) {
			Thread.sleep(100);
		}
		System.out.println("TEST18_05: pass");
	}
	public class Test18_05_listener implements I2CListener {
		@Override
		public void onReceived(I2CDevice device) {
			InputStream is = device.getInputStream();
			OutputStream os = device.getOutputStream();
			int data;
			try {
				data = is.read();
				os.write(data);
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			received = true;
		}
	}
*/
}
