import java.util.ArrayList;
import java.util.List;

import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.GPIOConnection;
import com.docomo_um.module.connection.GPIOFunctions;
import com.docomo_um.module.connection.GPIOListener;


public class GPIOTest {
	/**
	 * 入出力ポートの取得
	 * @throws Exception
	 */
	public void Test20_01() throws Exception {
		GPIOConnection gpio = (GPIOConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_GPIO);
		List<Integer> inport = gpio.getAvailableInPort();
		List<Integer> outport = gpio.getAvailableOutPort();
		System.out.print("inport ");
		for (int i = 0; i < inport.size(); i++) {
			System.out.print(" " + String.valueOf(inport.get(i)));
		}
		System.out.println();
		System.out.print("outport ");
		for (int i = 0; i < outport.size(); i++) {
			System.out.print(" " + String.valueOf(outport.get(i)));
		}
		System.out.println();
		System.out.println("TEST20_01: pass");
	}
	/**
	 * 出力ポートの状態変更
	 * @throws Exception
	 */
	public void Test20_02() throws Exception {
		boolean signal;
		GPIOConnection gpio = (GPIOConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_GPIO);
		List<Integer> outport = gpio.getAvailableOutPort();
		for (int i = 0; i < outport.size(); i++) {
			gpio.sendControlSignal(outport.get(i), true);
			signal = gpio.getControlSignal(outport.get(i));
			if (!signal) {
				throw new Exception("TEST20_02: false");
			}
		}
		for (int i = 0; i < outport.size(); i++) {
			gpio.sendControlSignal(outport.get(i), false);
			signal = gpio.getControlSignal(outport.get(i));
			if (signal) {
				throw new Exception("TEST20_02: false");
			}
		}
		System.out.println("TEST20_02: pass");
	}
	/**
	 * 入力ポートの状態変更
	 */
	boolean onChange;
	public void Test20_03() throws Exception {
		GPIOConnection gpio = (GPIOConnection)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_GPIO);
		List<Integer> inport = gpio.getAvailableInPort();
		List<Integer> inquiryPorts = new ArrayList<Integer>();
		inquiryPorts.add(1);
		inquiryPorts.add(3);
		boolean exception = false;
		try {
			gpio.setGPIOListener(inquiryPorts, new Test20_03_listener());
		}
		catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST20_03: false");
		}
		inquiryPorts.clear();
		inquiryPorts.add(inport.get(0));
		inquiryPorts.add(inport.get(2));
		for (int i = 0; i < inport.size(); i++) {
			GPIOFunctions.setReceiveControlSignal(inport.get(i), false);
		}
		gpio.setGPIOListener(inquiryPorts, new Test20_03_listener());
		onChange = false;
		System.out.println("Please change signal GPIO port 0 to true from terminal.");
		while (!gpio.receiveControlSignal(0)) {
			Thread.sleep(100);
		}
		if (!onChange) {
			throw new Exception("TEST20_03: fail");
		}
		onChange = false;
		System.out.println("Please change signal GPIO port 1 to true from terminal.");
		while (!gpio.receiveControlSignal(1)) {
			Thread.sleep(100);
		}
		if (onChange) {
			throw new Exception("TEST20_03: fail");
		}
		System.out.println("TEST20_03: pass");
	}
	public class Test20_03_listener implements GPIOListener {

		@Override
		public void onChangedStatus(int port, boolean signal) {
			onChange = true;
		}

	}
}
