import com.docomo_um.lang.Degree;


public class DegreeTest {
	/**
	 * DMSを指定してインスタンスを生成
	 *
	 * @throws Exception
	 */
	public void Test22_01() throws Exception {
		Degree deg = new Degree(135, 46, 1090);
		System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		long longdeg = deg.getFixedPointNumber();
		int degree = (int)(longdeg >> 31);
		int minute = (int)((((longdeg & 0x7FFFFFFF) * 360000)) >> 31) / 6000;
		int centisecond = (int)((((longdeg & 0x7FFFFFFF) * 360000)) >> 31) % 6000;
		System.out.println("degree = " + String.valueOf(degree) + ", minute = " + String.valueOf(minute) + ", centisecond = " + String.valueOf(centisecond));

		Degree deg2 = new Degree(longdeg);
		System.out.println("degree = " + String.valueOf(deg2.getDegreePart()) + ", minute = " + String.valueOf(deg2.getMinutePart()) + ", centisecond = " + String.valueOf(deg2.getCentisecondPart()));

		if (degree != 135) {
			throw new Exception("TEST22_01: fail");
		}
		System.out.println("TEST22_01: pass");
	}
	/**
	 * DEGREE単位の最大値、最小値を指定してインスタンスを生成
	 *
	 * @throws Exception
	 */
	public void Test22_02() throws Exception {
		Degree deg = new Degree(-1099511627776L);
		System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		deg = new Degree(1099511627775L);
		System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		System.out.println("TEST22_02: pass");
	}
	/**
	 * DEGREE単位の範囲外の値を指定してインスタンスを生成
	 *
	 * @throws Exception
	 */
	public void Test22_03() throws Exception {
		boolean exception = false;
		Degree deg;
		try {
			deg = new Degree(-1099511627777L);
			System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST22_03: fail");
		}
		exception = false;
		try {
			deg = new Degree(1099511627776L);
			System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST22_03: fail");
		}
		System.out.println("TEST22_03: pass");

	}
	/**
	 * DMSの最大値、最小値を指定してインスタンスを生成
	 *
	 * @throws Exception
	 */
	public void Test22_04() throws Exception {
		Degree deg = new Degree(-512, 0, 0);
		System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		long longdeg = deg.getFixedPointNumber();
		System.out.println("Fixed point number = " + String.valueOf(longdeg));
		if (longdeg != -1099511627776L) {
			throw new Exception("TEST22_04: fail");
		}
		deg = new Degree(511, 59, 5999);
		longdeg = deg.getFixedPointNumber();
		System.out.println("Fixed point number = " + String.valueOf(longdeg));
		int degree = (int)(longdeg >> 31);
		int minute = (int)((((longdeg & 0x7FFFFFFF) * 360000)) >> 31) / 6000;
		int centisecond = (int)((((longdeg & 0x7FFFFFFF) * 360000)) >> 31) % 6000;
		System.out.println("degree = " + String.valueOf(degree) + ", minute = " + String.valueOf(minute) + ", centisecond = " + String.valueOf(centisecond));
// 誤差あり
//		if (longdeg != 1099511627775L) {
//			throw new Exception("TEST22_04: fail");
//		}
		System.out.println("TEST22_04: pass");
	}
	/**
	 * DMSの範囲外の値を指定してインスタンスを生成
	 *
	 * @throws Exception
	 */
	public void Test22_05() throws Exception {
		boolean exception = false;
		Degree deg;
		try {
			deg = new Degree(-512,0,1);
			System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST22_05: fail");
		}
		exception = false;
		try {
			deg = new Degree(512,0,0);
			System.out.println("degree = " + String.valueOf(deg.getDegreePart()) + ", minute = " + String.valueOf(deg.getMinutePart()) + ", centisecond = " + String.valueOf(deg.getCentisecondPart()));
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		if (!exception) {
			throw new Exception("TEST22_05: fail");
		}
		System.out.println("TEST22_05: pass");

	}
}
