﻿import java.io.File;
import java.util.List;

import com.docomo_um.module.net.AreaMailBox;
import com.docomo_um.module.net.MessageBox;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.ShortMessage;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.module.net.ShortMessageListener;
import com.docomo_um.module.net.ShortMessageManager;


public class AreaMailBoxTest {
	/**
	 * エリアメールボックスのファイルおよびディレクトリの削除
	 */
	public void Test12_Initialize() {
		File file;
		for (int i = 1; i <= 8; i++) {
			file = new File(NetProperties.getInstance().getSMSDir() + "AREA/" + String.valueOf(i));
			if (file.exists()) {
				file.delete();
			}
		}
	}
	boolean Test12_01_recv;
	boolean Test12_01_override;
	ShortMessage Test12_01_message;
	/**
	 * エリアメールの受信
	 * @throws Exception
	 */
	public void Test12_01() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		AreaMailBox areaBox = SMSMan.getAreaMailBox();
		File file = new File(NetProperties.getInstance().getSMSDir() + "AREA/");
		if (!file.exists()) {
			throw new Exception("");
		}
		SMSMan.setShortMessageListener(new Test12_01_listener());
		for (int i = 1; i <= areaBox.getTotalMessageNumber(); i++) {
			Test12_01_recv = false;
			System.out.println("Please send area mail from terminal.");
			while (!Test12_01_recv) {
				Thread.sleep(100);
			}
			int messageNumber = Test12_01_message.getMessageNumber();
			System.out.println("TEST12_01: receive message = " + String.valueOf((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER)));
			if ((messageNumber & ShortMessageFunctions.PREFIX_AREAMAIL) == 0) {
				throw new Exception("TEST12_01: fail : not area mail");
			}
			if ((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER) != i) {
				throw new Exception("TEST12_01: fail : invalid message number");
			}
			int num = areaBox.getSavedMessageNumber();
			System.out.println("TEST12_01: saved message number = " + String.valueOf(num));
			if (num != i) {
				throw new Exception("TEST12_01: fail : number of messages is invalid");
			}
			if (Test12_01_override) {
				throw new Exception("TEST12_01: fail : override is invalid");
			}
		}
		System.out.println("TEST12_01: pass");
	}
	/**
	 * 保存可能なメッセージ数のメールが既に存在する場合
	 * @throws Exception
	 */
	public void Test12_02() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		AreaMailBox areaBox = SMSMan.getAreaMailBox();
		File file = new File(NetProperties.getInstance().getSMSDir() + "AREA/");
		if (!file.exists()) {
			throw new Exception("");
		}
		for (int i = 1; i <= 8; i++) {
			Test12_01_recv = false;
			System.out.println("Please send area mail from terminal.");
			while (!Test12_01_recv) {
				Thread.sleep(100);
			}
			int messageNumber = Test12_01_message.getMessageNumber();
			System.out.println("TEST12_02: receive message = " + String.valueOf((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER)));
			if ((messageNumber & ShortMessageFunctions.PREFIX_AREAMAIL) == 0) {
				throw new Exception("TEST12_02: fail : not area mail");
			}
			if ((messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER) != i) {
				throw new Exception("TEST12_02: fail : invalid message number");
			}
			int num = areaBox.getSavedMessageNumber();
			System.out.println("TEST12_02: saved message number = " + String.valueOf(num));
			if (num != 8) {
				throw new Exception("TEST12_02: fail : number of messages is invalid");
			}
			if (!Test12_01_override) {
				throw new Exception("TEST12_02: fail : override is invalid");
			}
		}
		System.out.println("TEST12_02: pass");
	}
	/**
	 * メッセージリストの取得
	 * @throws Exception
	 */
	public void Test12_03() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		AreaMailBox areaBox = SMSMan.getAreaMailBox();
		int messageNumber = ShortMessageFunctions.PREFIX_AREAMAIL + 2;
		ShortMessage message = areaBox.get(messageNumber);
		if (messageNumber != message.getMessageNumber()) {
			throw new Exception("TEST12_03: fail : invalid message number");
		}

		List<ShortMessage> list = areaBox.get(ShortMessage.STAT_READ);
		System.out.println("TEST12_03: list size = " + String.valueOf(list.size()));

		for (int i = 0; i < list.size(); i++) {
			message = list.get(i);
			System.out.println("UNREAD = " + String.valueOf(message.getMessageNumber() & ShortMessageFunctions.MASK_MESSAGE_NUMBER));
		}
		if (list.size() != 8) {
			throw new Exception("TEST12_03: fail : READ list is invalid");
		}
		System.out.println("TEST12_03: pass");
	}
	/**
	 * メールの削除
	 * @throws Exception
	 */
	public void Test12_04() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		AreaMailBox areaBox = SMSMan.getAreaMailBox();
		int messageNumber = ShortMessageFunctions.PREFIX_AREAMAIL + 2;
		areaBox.delete(messageNumber);
		int num = areaBox.getSavedMessageNumber();
		if (num != 7) {
			throw new Exception("TEST12_04: number of files invalid");
		}
		Test12_01_recv = false;
		System.out.println("Please send area mail from terminal.");
		while (!Test12_01_recv) {
			Thread.sleep(100);
		}
		num = areaBox.getSavedMessageNumber();
		if (num != 8) {
			throw new Exception("TEST12_04: number of files invalid");
		}
		System.out.println("TEST12_04: pass");
	}
	/**
	 * 存在しないメール番号を指定してメールを取得
	 * @throws Exception
	 */
	public void Test12_05() throws Exception {
		ShortMessageManager SMSMan = ShortMessageManager.getInstance();
		AreaMailBox areaBox = SMSMan.getAreaMailBox();
		int messageNumber = ShortMessageFunctions.PREFIX_AREAMAIL + 2;
		ShortMessage message;
		message = areaBox.get(messageNumber);
		areaBox.delete(messageNumber);
		try {
			message = areaBox.get(messageNumber);
		}
		catch (IllegalArgumentException e) {
			System.out.println("TEST12_05: pass");
			return ;
		}
		throw new Exception("TEST12_05: fail");
	}
	public class Test12_01_listener implements ShortMessageListener {
		@Override
		public void onSMSReceived(MessageBox messageBox, int messageNumber,
				boolean override) {
		}

		@Override
		public void onAreaMailReceived(ShortMessage message, boolean override) {
			Test12_01_message = message;
			Test12_01_override = override;
			Test12_01_recv = true;
		}

		@Override
		public void onSMSBoxFull(MessageBox messageBox) {
			// TODO 自動生成されたメソッド・スタブ

		}

	}

}