import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import jp.co.aplix.avm.LoadableModule;
import jp.co.aplix.avm.LoadableModuleException;

import com.docomo_um.io.ApplicationInstallManager;
import com.docomo_um.io.FFSFile;
import com.docomo_um.io.IOProperties;


public class ApplicationInstallManagerTest {
	public void Test11_Initialize() {
		File file = new File("/nano/download/dltemp.cap");
		if (file.exists()) {
			file.delete();
		}
		file = new File(file.getParent());
		if (file.exists()) {
			file.delete();
		}
	}
	/**
	 * ダウンロード領域にファイルを書き込めることを確認
	 * @throws Exception
	 */
	public void Test11_01() throws Exception {
		ApplicationInstallManager appMan = ApplicationInstallManager.getInstance();
		List<FFSFile> dlList = appMan.getFileList();
		int remain = appMan.getRemainSize();
		System.out.println("TEST11_01: remain = " + String.valueOf(remain));
		if (remain != 1024 * 1024) {
			throw new Exception("TEST11_01: fail");
		}
		// CAPファイルをロード
		File file = new File("/nano/app/testapp/testapp.cap");
		FileInputStream fis = new FileInputStream(file);
		byte[] buf = new byte[(int) file.length()];
		fis.read(buf);
		fis.close();
		// ダウンロード領域にCAPファイルを書き込み
		OutputStream fos = appMan.openOutputStream(dlList.get(0), false);
		fos.write(buf);
		fos.flush();
		System.out.println("length = " + String.valueOf(dlList.get(0).length()));
		fos.close();
		System.out.println("length = " + String.valueOf(dlList.get(0).length()));
		file = new File("/nano/download/dltemp.cap");
		if (!file.exists()) {
			throw new Exception("TEST11_01: fail");
		}
		remain = appMan.getRemainSize();
		System.out.println("TEST11_01: remain = " + String.valueOf(remain));
		if (remain != 1024 * 1024 - file.length()) {
			throw new Exception("TEST11_01: fail");
		}
		System.out.println("TEST11_01: pass");
	}
	/**
	 * アプリケーションのインストールが行えることを確認
	 */
	public void Test11_02() throws Exception {
		ApplicationInstallManager appMan = ApplicationInstallManager.getInstance();
		List<FFSFile> appList = appMan.getApplicationAreaList();
		for (int i = 0; i < appList.size(); i++) {
			FFSFile file = appList.get(i);
			System.out.println(file.getName());
		}
		appList.remove(0);
		appList = appMan.getApplicationAreaList();
		for (int i = 0; i < appList.size(); i++) {
			FFSFile file = appList.get(i);
			System.out.println(file.getName());
		}
		FFSFile app;
		try {
			app = appList.get(0);
			appMan.updateApplicationArea(app);
		} catch (LoadableModuleException e) {
			System.out.println("LoadableModuleException case = " + String.valueOf(e.getCause()));
			System.out.println("TEST11_02: fail");
			throw e;
		}
		File file = new File(IOProperties.getInstance().getAppDir() + app.getName());
		if (!file.exists()) {
			throw new Exception("TEST11_02: fail");
		}
		file = new File("/nano/download/dltemp.cap");
		if (file.exists()) {
			throw new Exception("TEST11_02: fail");
		}
		System.out.println("TEST11_02: pass");
	}
	/**
	 * ダウンロード領域にファイルが存在しない場合、インストールを行うとIllegalStateExceptionが発生することを確認
	 * @throws Exception
	 */
	public void Test11_03() throws Exception {
		ApplicationInstallManager appMan = ApplicationInstallManager.getInstance();
		List<FFSFile> appList = appMan.getApplicationAreaList();
		try {
			FFSFile app = appList.get(0);
			appMan.updateApplicationArea(app);
		} catch (IllegalStateException e) {
			System.out.println("TEST11_03: pass");
			return;
		}
		throw new Exception("TEST11_03: fail");
	}
	/**
	 * LoadableModuleExceptionが発生することを確認
	 * @throws Exception
	 */
	public void Test11_04() throws Exception {
		ApplicationInstallManager appMan = ApplicationInstallManager.getInstance();
		List<FFSFile> dlList = appMan.getFileList();
		List<FFSFile> appList = appMan.getApplicationAreaList();
		// CAPファイルをロード
		File file = new File("/nano/app/testapp/testapp.cap");
		FileInputStream fis = new FileInputStream(file);
		byte[] buf = new byte[(int) file.length()];
		fis.read(buf);
		fis.close();
		// ダウンロード領域にCAPファイルを書き込み
		OutputStream fos = appMan.openOutputStream(dlList.get(0), false);
		fos.write(buf);
		fos.close();
		System.out.println("Please set enable LoadableModuleException from terminal.");
		while (!IOProperties.getInstance().getLoadableModuleException()) {
			Thread.sleep(100);
		}

		try {
			FFSFile app = appList.get(0);
			appMan.updateApplicationArea(app);
		} catch (LoadableModuleException e) {
			System.out.println("LoadableModuleException case = " + String.valueOf(e.getCause()));
			System.out.println("TEST11_04: pass");
			return;
		}
		System.out.println("TEST11_04: fail");
	}
	public void Test11_05() throws Exception {
		ApplicationInstallManager aim = ApplicationInstallManager.getInstance();
		List<FFSFile> list = aim.getFileList();
		OutputStream fos = aim.openOutputStream(list.get(0), false);
		fos.write("TEST".getBytes());
		fos.flush();
		fos.close();
		InputStream fis = aim.openInputStream(list.get(0));
		byte[] buf = new byte[4];
		fis.read(buf);
		fis.close();
		System.out.println("TEST11_05: pass");
	}
	public void Test11_06() throws Exception {
		ApplicationInstallManager aim = ApplicationInstallManager.getInstance();
		List<FFSFile> list = aim.getFileList();
		List<FFSFile> applist = aim.getApplicationAreaList();
		File dlfile = new File(IOProperties.getInstance().getDLDir() + list.get(0).getName());
		if (dlfile.exists()) {
			dlfile.delete();
		}
		try {
			aim.updateApplicationArea(applist.get(0));
		}
		catch (IllegalStateException e) {
			System.out.println("TEST11_06: pass");
			return;
		}
		throw new Exception("TEST11_06: fail");
	}
	public void Test11_07() throws Exception {
	    ApplicationInstallManager aim = null;
        aim = ApplicationInstallManager.getInstance();
        try {
            List<FFSFile> list1 = aim.getApplicationAreaList();
            List<FFSFile> list2 = aim.getApplicationAreaList();
            for (int i = 0; i < list1.size(); i++) {
                if (list1.get(i) == list2.get(i)) {
            		throw new Exception("TEST11_07: fail");
                }
            }
        } catch (Exception e) {
    		throw new Exception("TEST11_07: fail");
        }
        try {
            List<FFSFile> list1 = aim.getFileList();
            List<FFSFile> list2 = aim.getFileList();
            for (int i = 0; i < list1.size(); i++) {
                if (list1.get(i) == list2.get(i)) {
            		throw new Exception("TEST11_07: fail");
                }
            }
        } catch (Exception e) {
    		throw new Exception("TEST11_07: fail");
        }
		System.out.println("TEST11_07: pass");
	}
}
