import java.util.List;

import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.connection.ADChannel;
import com.docomo_um.module.connection.ADConverter;
import com.docomo_um.module.connection.ConnectionManager;


public class ADTest {
	/**
	 * ADチャネルリストの取得
	 * @throws Exception
	 */
	public void Test19_01() throws Exception {
		ADConverter ad = (ADConverter)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_ADCONVERTER);
		List<ADChannel> chList = ad.getADChannelList();
		for (int i = 0; i < chList.size(); i++) {
			ADChannel ch = chList.get(i);
			System.out.println("name = " + ch.getChannelName());
			System.out.println("resolution = " + String.valueOf(ch.getResolution()));
		}
		System.out.println("TEST19_01: pass");
	}
	/**
	 * ターミナルからAD値の変更ができること
	 * @throws Exception
	 */
	public void Test19_02() throws Exception {
		ADConverter ad = (ADConverter)ModuleManager.getInstance().getConnectionManager().getConnection(ConnectionManager.CONNECTION_TYPE_ADCONVERTER);
		List<ADChannel> chList = ad.getADChannelList();
		ADChannel ch = chList.get(0);
		int value1 = ad.getAD(ch);
		int value2;
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value1));
		System.out.println("Please change value of AD0 from terminal.");
		while ((value2 = ad.getAD(ch)) == value1) {
			Thread.sleep(100);
		}
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value2));
		ch = chList.get(1);
		value1 = ad.getAD(ch);
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value1));
		System.out.println("Please change value of AD1 from terminal.");
		while ((value2 = ad.getAD(ch)) == value1) {
			Thread.sleep(100);
		}
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value2));
		ch = chList.get(2);
		value1 = ad.getAD(ch);
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value1));
		System.out.println("Please change value of AD2 from terminal.");
		while ((value2 = ad.getAD(ch)) == value1) {
			Thread.sleep(100);
		}
		System.out.println(ch.getChannelName() + " = " + String.valueOf(value2));
		System.out.println("TEST19_02: pass");
	}
}
