import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * PC側のサーバソケット(TCP/IP)サンプルクラスです。
 * <p>
 * サーバソケットのインスタンスを作成する{@link ServerSocket#ServerSocket(int)}
 * 受信ソケットのインスタンスを作成する{@link ServerSocket#accept()}
 * 入力ストリームを作成する{@link Socket#getInputStream()}
 * 受信データを取得する{@link InputStream#read(byte[])}
 * </p>
 * @see InputStream
 * @see ServerSocket
 * @see Socket
 */
public class Main {
	/**ソケットポート定義*/
	private static final int SOCKET_PORT = 5550;

	/**
	 * サーバソケットのメイン処理
	 * <P>
	 * サーバソケットのインスタンスを作成する{@link ServerSocket#ServerSocket(int)}
	 * 受信ソケットのインスタンスを作成する{@link ServerSocket#accept()}
	 * 入力ストリームを作成する{@link Socket#getInputStream()}
	 * 受信データを取得する{@link InputStream#read(byte[])}
	 * </p>
	 * @param  arg　　コマンドラインパラメータ(利用しない)
	 * @throws なし
	 */
	public static void main(String[] arg) {
		// ServerSocketのインスタンスを定義する
		ServerSocket serverSocket = null;
		System.out.println("The socket of the server is Opened at port=5550.");
		try {
			// サーバソケットのインスタンスを作成する
			serverSocket = new ServerSocket(SOCKET_PORT);
			while (true) {
				//ソケット受信待ち
				System.out.println("The listener of the server is listening.");
				// サーバソケットを受信待ちにする
				Socket socket = serverSocket.accept();
				// 受信データのバイト配列を作成する
				byte[] buf = new byte[1024];
				System.out.println("InputStream.read() start.");
				// 受信データを取得する
				InputStream is = socket.getInputStream();
				while (is.read(buf) != -1) {
					is.read(buf);
					// ループで受信データを出力する
					for (int i = 0 ; i < buf.length; i++) {
						// 受信終了を判断する
						if (buf[i] != 0) {
							// 終了以外の場合、受信メッセージを出力する
							System.out.println("buf["+ i + "] =" + buf[i]);
						} else {
							// 終了の場合、受信データ出力処理ループを抜ける
							break;
						}
					}
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			// ServerSocketのインスタンスを判定する
			if (serverSocket != null) {
				// null以外の場合
				System.out.println("ServerSocket close start.");
				try {
					// ソケットをクローズする
					serverSocket.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
				System.out.println("ServerSocket close end.");
			}
		}
	}
}
