import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.InetAddress;

/**
 * PC側のクライアントソケット(TCP/IP)サンプルクラスです。
 * <p>
 * クライアントソケットのインスタンスを作成する{@link Socket#Socket(String, int)}
 * 出力ストリームのインスタンスを作成する{@link Socket#getOutputStream()}
 * 出力データを送信する{@link OutputStream#write(byte[])}
 * </p>
 * @see OutputStream
 * @see Socket
 */
public class Main {
	/**ソケットポート定義*/
	private static final int SOCKET_PORT = 5550;
	/**サーバのIPアドレス定義*/
	private static final String HOSTADDRESS = "192.168.1.1";
	/**
	 * クライアントソケットのメイン処理
	 * <P>
	 * クライアントソケットのインスタンスを作成する{@link Socket#Socket(String, int)}
	 * 出力ストリームのインスタンスを作成する{@link Socket#getOutputStream()}
	 * 出力データを送信する{@link OutputStream#write(byte[])}
	 * </p>
	 * @param  args　　コマンドラインパラメータ(利用しない)
	 * @throws なし
	 */
	public static void main(String[] args) {
		// Socketのインスタンスを定義する
		Socket clientSocket = null;
		try {
			System.out.println("Create client socket start.");
			// ホストのIPアドレスとポートを指定して、Socketのインスタンスを作成する。
			clientSocket = new Socket(InetAddress.getByName(HOSTADDRESS), SOCKET_PORT);
			System.out.println("Create client socket end.");
			// 送信データを作成する
			for (int j = 0; j < 10; j++) {
				byte[] buf = new byte[10];
				for (int i = 0; i < buf.length; i++) {
					// 送信データを配列に設定する
					buf[i] = (byte) ((byte)'a' + (byte)j);
				}
				System.out.println("OutputStream.write() start.");
				for (int l = 0 ; l < buf.length; l++) {
					System.out.println("buf[" + l + "]=" + buf[l]);
				}
				// OutputStreamのインスタンスを作成する
				OutputStream os = clientSocket.getOutputStream();
				// 送信処理を行う
				os.write(buf);
				System.out.println("OutputStream.write() end.");
			}
		} catch (ConnectException e) {
			System.out.println("The Server is receiving! try again.");
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			// Socketインスタンスを判定する
			if (clientSocket != null) {
				// null以外の場合
				System.out.println("Socket close start.");
				try {
					// Socketをクローズする
					clientSocket.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
				System.out.println("Socket close end.");
			}
			System.out.println("The client send is over.");
		}
	}
}
