/*
 * Copyright 2005-2009 Aplix Corporation. All rights reserved.
 */
#ifndef CONSTANT_H
#define CONSTANT_H

/**
 * METHOD_TABLE_ENABLE  1 ɂƁC
 * eNXɉz\bhe[uāC
 * invokevirtual ̎s܂B
 * ʁCe[û߂̃KvƂȂ܂B
 */
#ifndef METHOD_TABLE_ENABLE
  #define METHOD_TABLE_ENABLE       (0)
#endif /* METHOD_TABLE_ENABLE */
/* checkcast oCgR[hŐ`FbNs */

/**
 * ENABLE_CHECKCAST  1 ɂƁC
 * checkcast oCgR[hł̃`FbNLɂ܂B
 */
#ifndef ENABLE_CHECKCAST
  #define ENABLE_CHECKCAST          (0)
#endif /* ENABLE_CHECKCAST */

#ifndef LOADABLE
  #define LOADABLE                  (1)
#endif /* LOADABLE */

#ifndef REALLOC_ENABLE
  #define REALLOC_ENABLE            (1)
#endif /* REALLOC_ENABLE */

#ifndef WARM_REBOOTABLE
  #define WARM_REBOOTABLE			(0)
#endif /* WARM_REBOOTABLE */

/**
 * DIRECT_OFFSCREEN  1 ɂ,
 * OiP ŃItXN[A
 * ^[QbgŗpӂItXN[C[Wɕ`悵܂B
 * unsigned char * JSI_GLCD_getOffScreenAddress() ̎KvłB
 */
#ifndef DIRECT_OFFSCREEN
  #define DIRECT_OFFSCREEN            (0)
#endif /* DIRECT_OFFSCREEN */

#ifndef MAX_USER_EXTSIGNALS
  #define MAX_USER_EXTSIGNALS 16
#endif /* MAX_USER_EXTSIGNALS */
#define MAX_EXTSIGNAL_HANDLERS	(MAX_USER_EXTSIGNALS + 4)

#ifdef JAVASTACK_SIZE
  #error JAVASTACK_SIZE was Deprecated, USE JAVASTACK_INITIAL_SIZE and JAVASTACK_DELTA_SIZE.
#endif /* JAVASTACK_SIZE */

/* Xbh̏X^bNTCYiPʁFoCgj*/
#ifndef JAVASTACK_INITIAL_SIZE
  #define JAVASTACK_INITIAL_SIZE	(1024)
#endif

/* Xbh̃X^bNTCYliPʁFoCgj*/
#ifndef JAVASTACK_DELTA_SIZE
  #define JAVASTACK_DELTA_SIZE	(4096)
#endif

/* notifyInterruptŒʒmL[̃TCY (2^N) */
#define SIZE_QUEUE  16

/* XbhEhrŎsƂ̈Xbh̍őAsԁiP:msj */
#define TIMESLICE   10

/* JE^i[Xpj*/
#ifndef RESTRICTION_COUNTER_LIMIT
  #define RESTRICTION_COUNTER_LIMIT	0
#endif

#ifndef USE_DRAW_CHARS
  #define USE_DRAW_CHARS 0
#endif

/* ɎgpłNX[_̐iɎsłAv̐j */
#if (LOADABLE == 0)
  #define   MAX_LOADERS 1
#else
  #define   MAX_LOADERS 10
#endif

/* USE_TICK_EVENT = 1: XbhXPW[̃^C~OO̒ʒmōsꍇ. */
#ifndef USE_TICK_EVENT
  #define USE_TICK_EVENT 0
#endif

#ifndef REFERENCE_TRACE
  #define REFERENCE_TRACE 0
#endif /* REFERENCE_TRACE */

#endif                          // CONSTANT_H
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef VMDEFS_H
#define VMDEFS_H

#include "typedefs.h"

#ifndef NANO_ASSERT
  #if ((defined(_MSC_VER) && (DEBUG == 1)) && !defined(CPPTEST)) || (defined(__BORLANDC__) && (DEBUG == 1))
    #include <assert.h>
    #define NANO_ASSERT(x) assert(x)
  #else /* _MSC_VER */
    #define NANO_ASSERT(x)
  #endif /* _MSC_VER */
#endif /* NANO_ASSERT */

typedef struct _ClassLoader ClassLoaderT;

typedef struct _ClassFile ClassFileT;
typedef struct _ClassStatus ClassStatusT;

typedef struct _Utf8Info Utf8InfoT;
typedef struct _Ucs2Info Ucs2InfoT;

typedef struct _FieldInfo FieldInfoT;

typedef struct _MethodInfo MethodInfoT;
typedef struct _MethodDefBytecode MethodDefBytecodeT;
typedef struct _MethodDefNative MethodDefNativeT;
typedef struct _ExceptionHandler ExceptionHandlerT;
typedef struct _LineNumber LineNumberT;
typedef struct _AddrCvtTbl AddrCvtTblT;
typedef struct _VariableTbl VariableTblT;

typedef struct _Page PageT;
typedef struct _Heap HeapT;
typedef struct _Cell CellT;
typedef struct _Memory MemoryT;
typedef struct _Monitor MonitorT;
typedef struct _Instance InstanceT;
typedef struct _Array ArrayT;
typedef struct _RomizeInstance RomizeInstanceT;

typedef struct _Thread ThreadT;
typedef struct _StackBlock StackBlockT;
typedef struct _ExternalSignalHandler ExternalSignalHandlerT;
typedef struct _Frame FrameT;
typedef struct _Cpu CpuT;

typedef Utf8InfoT JdwpStringT;
typedef struct _JdwpLocation JdwpLocationT;
typedef struct _JdwpResponse JdwpResponseT;
typedef union  _JdwpEvent JdwpEventT;
typedef struct _JdwpEventHeader JdwpEventHeaderT;
typedef struct _JdwpEventBreakpoint JdwpEventBreakpointT;
typedef struct _JdwpEventStep JdwpEventStepT;
typedef struct _JdwpEventException JdwpEventExceptionT;
typedef struct _JdwpEventField JdwpEventFieldT;
typedef struct _JdwpTransport JdwpTransportT;
typedef struct _JdwpCommand JdwpCommandT;

typedef struct _ObjectHeader {
  #if (JDWP == 1)
    nano_u4 type_id;
  #endif /* JDWP == 1 */
    CellT *cell;
    const ClassFileT *cf;
    CellT *monitor;
} ObjectHeaderT;

typedef struct _NameAndDesc {
    const Utf8InfoT *name;
    const Utf8InfoT *desc;
} NameAndDescT;

/* SimpleNative in vmlib. */
int nano_KeyPdSetHandler(int hndr);
void nano_KeyPdStop(void);
void nano_KeyPdStart(void);

/*ftHg͕_̓T|[gȂ */
#ifndef FLOAT_SUPPORT
  #define FLOAT_SUPPORT 0
#endif /* FLOAT_SUPPORT */

/* m̃NXt@C̃CfbNX
 * ̃NXCfbNXpāC
 * cl0.cfs[CLASSINDEX_Object] Ƃ΁CړI ClassFile* 擾ł܂B
 * ̏Ԃ́C擪Ƀv~eBuȔzNXC
 * ɑC}CU romizer.java Œ`Ă NECESSARY_CLASSES ̏ԂƂȂ܂B
 * KvȃNXǉꍇ́C̔ԍƁCromizer.java Ƃ̓ɒӂ܂傤B
 */
#define CLASSINDEX_BOOLEAN_ARRAY                    (0)
#define CLASSINDEX_CHAR_ARRAY                       (1)
#define CLASSINDEX_BYTE_ARRAY                       (2)
#define CLASSINDEX_SHORT_ARRAY                      (3)
#define CLASSINDEX_INT_ARRAY                        (4)
#define CLASSINDEX_LONG_ARRAY                       (5)

#if (FLOAT_SUPPORT == 1)
  #define CLASSINDEX_FLOAT_ARRAY					(6)
  #define CLASSINDEX_DOUBLE_ARRAY					(7)
  #define START_OF_INDISPENSABLE_CLASS              (8)
#else
  #define START_OF_INDISPENSABLE_CLASS              (6)
#endif /* (FLOAT_SUPPORT == 1) */

//

#define CLASSINDEX_NullPointerException             (START_OF_INDISPENSABLE_CLASS + 0)
#define CLASSINDEX_ArithmeticException              (START_OF_INDISPENSABLE_CLASS + 1)
#define CLASSINDEX_ArrayIndexOutOfBoundsException   (START_OF_INDISPENSABLE_CLASS + 2)
#define CLASSINDEX_OutOfMemoryError                 (START_OF_INDISPENSABLE_CLASS + 3)
#define CLASSINDEX_IndexOutOfBoundsException        (START_OF_INDISPENSABLE_CLASS + 4)
#define CLASSINDEX_StringIndexOutOfBoundsException  (START_OF_INDISPENSABLE_CLASS + 5)
#define CLASSINDEX_ArrayStoreException              (START_OF_INDISPENSABLE_CLASS + 6)
#define CLASSINDEX_InterruptedException             (START_OF_INDISPENSABLE_CLASS + 7)
#define CLASSINDEX_ClassNotFoundException           (START_OF_INDISPENSABLE_CLASS + 8)
#define CLASSINDEX_NoClassDefFoundError             (START_OF_INDISPENSABLE_CLASS + 9)
#define CLASSINDEX_ExceptionInInitializerError      (START_OF_INDISPENSABLE_CLASS + 10)
#define CLASSINDEX_VirtualMachineError              (START_OF_INDISPENSABLE_CLASS + 11)
#define CLASSINDEX_ClassCastException               (START_OF_INDISPENSABLE_CLASS + 12)
#define CLASSINDEX_IllegalArgumentException         (START_OF_INDISPENSABLE_CLASS + 13)
#define CLASSINDEX_UnsupportedEncodingException	 (START_OF_INDISPENSABLE_CLASS + 14)

#define CLASSINDEX_Object                           (START_OF_INDISPENSABLE_CLASS + 15)
#define CLASSINDEX_String                           (START_OF_INDISPENSABLE_CLASS + 16)
#define CLASSINDEX_StringBuilder                    (START_OF_INDISPENSABLE_CLASS + 17)
#define CLASSINDEX_Thread                           (START_OF_INDISPENSABLE_CLASS + 18)
#define CLASSINDEX_Throwable                        (START_OF_INDISPENSABLE_CLASS + 19)

#define CLASS_INDEX_ObjectArray                     (START_OF_INDISPENSABLE_CLASS + 20)

#define CLASSINDEX_startup                          (START_OF_INDISPENSABLE_CLASS + 21)
#define CLASSINDEX_StringArray                      (START_OF_INDISPENSABLE_CLASS + 22)
#define END_OF_INDISPENSABLE_CLASS                  (START_OF_INDISPENSABLE_CLASS + 23)


// for ROMIZER
#define Java_java_lang_StringBuffer_toString					Java_java_lang_StringBuilder_toString
#define Java_java_lang_StringBuffer_append__Ljava_lang_String_2 Java_java_lang_StringBuilder_append__Ljava_lang_String_2
#define Java_java_lang_StringBuffer_append__C					Java_java_lang_StringBuilder_append__C
#define Java_java_lang_StringBuffer_delete						Java_java_lang_StringBuilder_delete
#define Java_java_lang_StringBuffer_deleteCharAt				Java_java_lang_StringBuilder_deleteCharAt
#define Java_java_lang_StringBuffer_charAt						Java_java_lang_StringBuilder_charAt
#define Java_java_lang_StringBuffer_alloc						Java_java_lang_StringBuilder_alloc
#define Java_java_lang_StringBuffer_setLength					Java_java_lang_StringBuilder_setLength
#define Java_java_lang_StringBuffer_insert__ILjava_lang_String_2 Java_java_lang_StringBuilder_insert__ILjava_lang_String_2
#define Java_java_lang_StringBuffer_insert__IC					Java_java_lang_StringBuilder_insert__IC
#define Java_java_lang_StringBuffer_getChars					Java_java_lang_StringBuilder_getChars
#define Java_java_lang_StringBuffer_setCharAt					Java_java_lang_StringBuilder_setCharAt
#define Java_java_lang_StringBuffer_reverse						Java_java_lang_StringBuilder_reverse
#define Java_java_lang_StringBuffer_ensureCapacity				Java_java_lang_StringBuilder_ensureCapacity
#define Java_java_lang_StringBuffer_append___3CII				Java_java_lang_StringBuilder_append___3CII

#endif                          /* VMDEFS_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef MONITOR_H
#define MONITOR_H

#include "typedefs.h"

struct _Monitor {
    CellT *cell;
    
    ThreadT *owner;
    int lockcount;
    ThreadT *wait_enter_list;
    ThreadT *wait_notify_list;
};

MonitorT *nano_Monitor_new(void);

int nano_ObjectMonitorEnter(CellT *obj_cell);

int nano_ObjectMonitorExit(CellT *obj_cell);


#endif                          /* MONITOR_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef BYTECODES_H
#define BYTECODES_H

#include "typedefs.h"

int nano_invoke_inner(FrameT *fp, const MethodDefBytecodeT *target_bmethod, int bcodesize);

int nano_interpreter_loop(void);

#endif                          /* BYTECODES_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef EXCEPTIONS_H
#define EXCEPTIONS_H

#define NormalExit                             (1)
#define VmExit                                 (-1)

#endif                          /* EXCEPTIONS_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef CELL_H
#define CELL_H

#include "typedefs.h"

#define dereference(c)  nano_dereference(c)
void *nano_dereference(const CellT *cell);

typedef struct _CellMembers {
    unsigned pageID:16;
    unsigned pageIndex:8;
    unsigned type:4;
    unsigned padding:2;
    unsigned gcMarkGray:1;
    unsigned gcMarkBlack:1;
} CellMembersT;

struct _Cell {
    union {
        CellMembersT m;
        nano_u4 val;
    } a;
};

#define CELL_setVal(c,v)            ((c)->a.val = (v))
#define CELL_getVal(c)              ((c)->a.val)
#define CELL_getPageIndex(c)        ((c)->a.m.pageIndex)
#define CELL_setPageIndex(c,i)      ((c)->a.m.pageIndex = (i))
#define CELL_getPageId(c)           ((c)->a.m.pageID)
#define CELL_setPageId(c,i)         ((c)->a.m.pageID = (i))
#define CELL_getType(c)             ((c)->a.m.type)
#define CELL_setType(c,i)           ((c)->a.m.type = (i))
#define CELL_getGcMarkGray(c)       ((c)->a.m.gcMarkGray)
#define CELL_setGcMarkGray(c,v)     ((c)->a.m.gcMarkGray = (v))
#define CELL_getGcMarkBlack(c)      ((c)->a.m.gcMarkBlack)
#define CELL_setGcMarkBlack(c,v)    ((c)->a.m.gcMarkBlack = (v))

#define CELL_swapValue(x,y)         \
    {                               \
        nano_u4 xval = CELL_getVal(x);   \
        nano_u4 yval = CELL_getVal(y);   \
        CELL_setVal((x), yval);     \
        CELL_setVal((y), xval);     \
    }                               
        

struct _RomizeInstance {
    const char *name;
    InstanceT *instance;
    CellT cell;
};

#endif                          /* CELL_H */
/*
 * Copyright 2005-2009 Aplix Corporation. All rights reserved.
 */
#ifndef __CPU_H
#define __CPU_H

#include <setjmp.h>
#include "typedefs.h"

// TODO NativeSupport.h ɈڂB̂͏B
void nano_pushStack(nano_s4 value);
nano_s4 nano_popStack(void);

struct _Frame { /* parasoft-suppress OPT-13 */
    const ClassLoaderT *current_loader;
    const MethodInfoT *current_method;
    CellT *monitor;
    FrameT *return_fp;           // Õt[
    nano_u2 return_pc_add;           // t[한A pc ɉZl
    nano_u1 native_pc_add;           // lCeBu\bhI pc ɉZl
    nano_u1 is_bayoned_stackblock;	 // Ot[ʂ̃X^bNubNɂꍇ
    nano_s4 *lp;
    nano_s4 *sp;
    const nano_u1 *pc;               // ɎsׂR[h
    
#if (JDWP == 1)
    const nano_u1 *breaked_pc;       // BREAKPOINT Œ~ӏ PC
    nano_u1 breaked_pc_instruction;  // ̖{̃CXgNV
    nano_u1 pad0, pad1, pad2;
#endif /* (JDWP == 1) */
#ifdef JAVA_PROFILER
	nano_s8 method_start_time;
	nano_s8 method_away_time;
	nano_s8 method_spent_away_sum;
#endif
};

/** 1 Õt[̎擾 */
#define FRAME_getReturnFP(fp)	((fp)->return_fp)

/** 1 Õt[ƁCt[CقȂX^bNubNǂ */
#define FRAME_isBeyondStackBlock(fp) ((fp)->is_bayoned_stackblock)

#define FRAME_setReturnFP(fp, returnFP)	((fp)->return_fp = (returnFP))
#define FRAME_setBeyonedStackBlock(fp, v) ((fp)->is_bayoned_stackblock = (v))

#define FRAME_getClass(fp)      (fp->current_method->cf)
#define FRAME_getLoader(fp)     (fp->current_loader)

enum THREAD_STATUS {
    TS_RUNNABLE,
    TS_WAIT_MONITOR,
    TS_SLEEP,
    TS_WAIT_NOTIFY,
    TS_TIMED_WAIT_NOTIFY,
    TS_JOIN,
    TS_WAIT_EXTSIGNAL,
    TS_WAIT_CLASS_INITIALIZE
};

struct _StackBlock {
	/** ̃X^bNubN */
	StackBlockT *next;
	/** ÕX^bNubN */
	StackBlockT *prev;
	/** ̃X^bNubN̍ŏIAhX */
	nano_s4 *end_addr;
	/** X^bN̈̎ */
	nano_s4 data[1];
};

struct _Thread { /* parasoft-suppress OPT-13 */
    volatile enum THREAD_STATUS th_status;  // Xbh̏

    FrameT *frame;                   // s

    ThreadT *lst_next;               // Xg\ ` join_threads_listCMonitor.lock_threads_listKC
                                    // Monitor.wait_threads_listK ̎vf
    ThreadT *cpu_next;               // Xg\ ` Cpu.vm_threads_list ̎vf

    CellT *thread_instance;
    CellT *target_instance;
    CellT *thrown_obj;
    
    ThreadT *join_threads_list;      // ̃XbhuɁv join() ĂXbh
    nano_u1 is_interrupted;              // ꂽǂ
    nano_u1 req_interruption;            // InterruptedException() ̃X[v
    nano_u1 block_sync_method;           // synchronized \bh̃j^擾ŃubNꂽ
    nano_u1 oufofmemerr_throwing;        // OutOfMemoryError X[
    nano_u4 tmout_counter;               // ^CAEgJE^FSLEEP, TIMED_WAIT_NOTIFY ɗL
    int lockcount_bk;               // Monitor#lockcount̃obNAbvF
                                    // WAIT_NOTIFY, TIMED_WAIT_NOTIFY, WAIT_MONITOR ɗL
    
    union {
        MonitorT *waiting_monitor;   // wait() Ă郂j^FWAIT_NOTIFY, TIMED_WAIT_NOTIFY ɗL
        ThreadT *join_tgt_thread;    // ̃Xbhuv join() ĂXbhFJOIN ɗL
    } ux;
    
    StackBlockT *stackblock_top;
    StackBlockT *stackblock_cur;
    
  #if (JDWP == 1)
    int started;
    int suspend_count;
#endif
};

#if (JDWP == 1)
  void nano_Thread_suspend(ThreadT *this);
  void nano_Thread_resume(ThreadT *this);
  #define THREAD_isJDWPSuspend(t)   ((t)->suspend_count != 0)
#else
  #define THREAD_isJDWPSuspend(t)   (0)
#endif

struct _ExternalSignalHandler { /* parasoft-suppress OPT-13 */
    nano_s4 id;
    ThreadT *waiting_thread;
    nano_s4 *waiting_sp;
    int inp, outp;
    nano_s4 resultsW[SIZE_QUEUE * 2];
};

#define CPU_NOT_READY   0U
#define CPU_RUNNING     1U
#define CPU_FINISHED    2U

struct _Cpu { /* parasoft-suppress OPT-13 */
    nano_u1 isRunning;

    /**
     * System.exit()̈͂̃oɃZbgB 
     */
    int nano_exit_status;

    int vm_exit_status;

    nano_u4 prev_tick;
    ThreadT *vm_threads_list;        // VM ̑SXbh̃Xgi擪JgXbhj
    ThreadT **tail_ptr;              // XbhXg̍Ōւ̃|C^

    ExternalSignalHandlerT *extsignal_handlers[MAX_EXTSIGNAL_HANDLERS];

    const ClassLoaderT *class_loaders[MAX_LOADERS];

	ThreadT* mainThread;

#if (USE_TICK_EVENT == 1)
	volatile nano_u4 cur_tick;
	volatile int fTicked;
  #define GET_TICK()	(gcpu_.cur_tick)
#else
  #define GET_TICK()	JSI_getTick()
#endif /* (USE_TICK_EVENT == 1) */
    
#if (JDWP == 1)
    nano_u1 disable_jdwp;
    nano_u1 cpu_blocking;
    int hold_jdwp_events;
    JdwpEventStepT *stepEvent;
#endif
#ifdef JAVA_PROFILER
	int javaProfilerThreadDead;
	int javaProfilerThreadSpawned;
	int javaProfilerEnabled;
#endif
};

// ClassLoader
int nano_addClassLoader(const ClassLoaderT *cl);

// Thraed
/* Xbh\̂쐬 VM ɒǉ */
ThreadT *nano_beginThread(CellT *thread_instance, CellT *target_instance, 
                         const MethodInfoT *startup_method);
void nano_exitThread(void);

#if (JDWP == 1)
void nano_suspendAllThreads(void);
void nano_resumeAllThreads(void);
#endif

void nano_sleepThread(nano_u4 millis);
void nano_joinThread(const CellT *thread_instance);
void nano_interruptThread(const CellT *thread_instance);

// external signal
void nano_setExternalSignalHandler(int id);
void nano_waitExternalSignal(int id);
int nano_externalSignal2(int id, nano_s4 resultHI, nano_s4 resultLO);
void nano_clearExternalSignalQueue(int id);
int nano_availableExternalSignal(int id);

// Monitor
int nano_monitorEnter(CellT *monitor);
void nano_monitorExit(CellT *monitor);
nano_s4 nano_checkMonitorByMonitor(CellT *monitor);
int nano_checkMonitor(CellT *monitor);
void nano_waitMonitor(CellT *monitor, nano_u4 timeout);
void nano_notifyMonitor(CellT *monitor);
void nano_notifyMonitorAll(CellT *monitor);

// instance
CellT *nano_createInstance(int class_index, nano_u4 additional_size);
//nano_s4 nano_getFieldValue(CellT *target, const NameAndDescT *nad);
int nano_getFieldValue(CellT *target, const NameAndDescT *nad, nano_s4 *first, nano_s4 *second);

InstanceT* nano_createThreadInstanceForMainThread(void);
//
int nano_schedule(void);
void nano_exitVm(int status);
void nano_throwException(int e);

#define VM_getCurrentThread()  (gcpu_.vm_threads_list)
#define VM_getCurrentFrame()   (VM_getCurrentThread()->frame)
#define VM_setCurrentFrame(f)  (VM_getCurrentThread()->frame = (f))

void nano_getStack(const ThreadT *thread, nano_s4 **stack_top, nano_s4 **stack_bottom);

void nano_init(void);
#if TEST == 1
/**
 * sԂ܂B
 * NX[hStaticInitialize͍s܂B 
 */
void nano_executionStateInit(void);
#endif
int nano_clinit(const ClassFileT *target);
int nano_interpret(void);

int nano_makeStackTrace(InstanceT *in, FrameT *fp);

/**
 * ̊֐ exception ZbgꍇAԂl push ́AĂȂĂAǂłǂB
 */
void nano_setException(int exception_classID);

#if ((TEST == 1) || (VERBOSE == 1))
void nano_nativePrintStackTrace(CellT *thrown_cell);
#endif

/* K{NX̏ */
int nano_initIndispensableClass(void);
int nano_checkInstanceOf(const ClassFileT *cf_S, const ClassFileT *cf_T);

#if (WARM_REBOOTABLE == 1)
  /* BSCL ̊eNX̏B*/
  void nano_initClassStatus(void);
  extern volatile int nano_req_reboot;
#endif /* (WARM_REBOOTABLE == 1) */

void nano_showStackTrace(void);

extern CpuT gcpu_;
#endif                          // __CPU_H
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef MEMORY_H
#define MEMORY_H

struct _Memory {
    CellT **cells;
    int count;
    int size;
    CellT *cell_cells;
};

void nano_Memory_init(void);
MemoryT *nano_Memory_new(void);

/**
 * mۂłȂꍇ́AJavaAvOutOfMemoryErrorthrowB
 * @return mۂłȂꍇNULL 
 */
void *nano_Memory_alloc(int size);

void nano_Memory_free(void *ptr);

extern MemoryT gmem_;


#endif                          /* MEMORY_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef INSTANCE_H
#define INSTANCE_H

#include "typedefs.h"

struct _Instance {
    ObjectHeaderT h;
    
    nano_s4 field[1];
    #define INSTANCE_BASE_SIZE (sizeof(InstanceT) - sizeof(nano_s4))
};

InstanceT *nano_instance_create(const ClassFileT *cf, nano_u4 additional_size);

CellT *nano_instance_getMonitor(InstanceT *instance);
#define nano_instance_getMonitorNoAlloc(in) ((in)->h.monitor)


InstanceT *nano_string_newWithUtf8(const Utf8InfoT *utf8);
InstanceT *nano_string_newWithPtr(const char *ptr, nano_u4 length);

InstanceT *nano_string_newWithUcs2CP(const Ucs2InfoT *ucs2);

#if (JDWP == 1)
nano_s4 nano_string_toUtf8(nano_u1 *dst, InstanceT *in);
#define nano_string_getUtf8Length(in) nano_string_toUtf8(NULL, in)
#endif /* (JDWP == 1) */

/* ROMIZER defines these parameters. */
extern const nano_u1 FieldIndex_JAVA_LANG_STRING_length;
extern const nano_u1 FieldIndex_JAVA_LANG_STRING_str;
extern const nano_u1 FieldSize_JAVA_LANG_STRING;

extern const nano_u1 FieldIndex_JAVA_LANG_OBJECT_outofmemoryerror;

extern const nano_u1 FieldIndex_JAVA_LANG_THREAD_lockObj;
extern const nano_u1 FieldIndex_JAVA_LANG_THREAD_not_startable;
extern const nano_u1 FieldIndex_JAVA_LANG_THREAD_name;

extern const nano_u1 FieldIndex_JAVA_LANG_THROWABLE_stackTrace;
extern const nano_u1 FieldIndex_JAVA_LANG_THROWABLE_message;

extern const nano_u1 FieldIndex_JAVA_LANG_STRINGBUILDER_buffer;
extern const nano_u1 FieldIndex_JAVA_LANG_STRINGBUILDER_bufferLength;
extern const nano_u1 FieldIndex_JAVA_LANG_STRINGBUILDER_length;

extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_width;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_height;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_clipX;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_clipY;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_clipWidth;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_clipHeight;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_colorVal;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_fontHandle;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_vram;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_offsetX;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_offsetY;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_screenWidth;
extern const nano_u1 FieldIndex_JP_CO_APLIX_AWT_GRAPHICSIMPL_screenHeight;

extern const nano_u1 MethodIndex_JAVA_LANG_THREAD_run;

extern const nano_u1 FieldIndex_JAVA_IO_DIRENT_d_type;
extern const nano_u1 FieldIndex_JAVA_IO_DIRENT_d_name;

#endif                          /* INSTANCE_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef LOG_H
#define LOG_H

#include <stddef.h>
#include "JBI.h"

#define LOG_ERR 1
#define LOG_WARN    1
#if (VERBOSE == 1)
#define LOG_INFO    1
#else
#define LOG_INFO    0
#endif

extern int Snprintf(char *s, size_t size, const char *format, ...);
extern int nano_log_printf(const char *format, ...);
#if (LOG_INFO == 1)
extern int log_level;
#endif

#define LOG_header()    nano_log_printf("%s:%d: ", __FILE__, __LINE__)

#if (LOG_ERR == 1)
#define LOGe(x)     {LOG_header(); x;}
#else
#define LOGe(x)
#endif

#if (LOG_WARN == 1)
#define LOGw(x)     {LOG_header(); x;}
#else
#define LOGw(x)
#endif

#if (LOG_INFO == 1)
#define LOGl(l, x)  {if (log_level & l) {LOG_header(); x;}}
#define LOGb(l, x)  {if (log_level & l) {x;}}
#else
#define LOGl(l, x)
#define LOGb(l, x)
#endif

#define FORCE_DIE()    while(1)

#endif                          /* LOG_H */
/*
 * Copyright 2007-2008 Aplix Corporation. All rights reserved.
 */
#ifndef UTF8_INFO_H
#define UTF8_INFO_H

#include "typedefs.h"

typedef nano_u1 stringchar;

#define SIZEOF_STRING_ELEMENT sizeof(stringchar)

struct _Ucs2Info {
    nano_u2 length;
    const nano_u2 chars[1];
};

struct _Utf8Info {
	/**
	 * oCgB
	 */
    nano_u2 length;
    const stringchar bytesX[1];
};

#define DEF_STRUCT_UTF8_INFO(N) \
typedef struct _Utf8Info ## N { \
    nano_u2 length; \
    const stringchar bytes[N]; \
} Utf8InfoT ## N;

DEF_STRUCT_UTF8_INFO(2)
DEF_STRUCT_UTF8_INFO(3)
DEF_STRUCT_UTF8_INFO(4)
DEF_STRUCT_UTF8_INFO(6)
DEF_STRUCT_UTF8_INFO(8)
DEF_STRUCT_UTF8_INFO(18)
DEF_STRUCT_UTF8_INFO(19)
DEF_STRUCT_UTF8_INFO(22)
DEF_STRUCT_UTF8_INFO(36)
DEF_STRUCT_UTF8_INFO(256) // for JDWP

typedef struct _Utf8Info0 {
    nano_u2 length;
}Utf8Info0T;

#define UTF8_BOOLEAN_ARRAY              ((const Utf8InfoT*) &_UTF8_BOOLEAN_ARRAY)
#define UTF8_CHAR_ARRAY                 ((const Utf8InfoT*) &_UTF8_CHAR_ARRAY)
#define UTF8_FLOAT_ARRAY                ((const Utf8InfoT*) &_UTF8_FLOAT_ARRAY)
#define UTF8_DOUBLE_ARRAY               ((const Utf8InfoT*) &_UTF8_DOUBLE_ARRAY)
#define UTF8_BYTE_ARRAY                 ((const Utf8InfoT*) &_UTF8_BYTE_ARRAY)
#define UTF8_SHORT_ARRAY                ((const Utf8InfoT*) &_UTF8_SHORT_ARRAY)
#define UTF8_INT_ARRAY                  ((const Utf8InfoT*) &_UTF8_INT_ARRAY)
#define UTF8_LONG_ARRAY                 ((const Utf8InfoT*) &_UTF8_LONG_ARRAY)
#define UTF8_VOIDVOID                   ((const Utf8InfoT*) &_UTF8_VOIDVOID)
#define UTF8_STARTUP_METHOD             ((const Utf8InfoT*) &_UTF8_STARTUP_METHOD)
#define UTF8_INIT                   	 ((const Utf8InfoT*) &_UTF8_INIT)
#define UTF8_CLINIT                     ((const Utf8InfoT*) &_UTF8_CLINIT)
#define UTF8_CLASS_STRING               ((const Utf8InfoT*) &_UTF8_CLASS_STRING)
#define UTF8_ARRAY_OF_JAVA_LANG_STRING  ((const Utf8InfoT*) &_UTF8_ARRAY_OF_JAVA_LANG_STRING)
#define UTF8_ARRAY_OF_JAVA_LANG_THREAD  ((const Utf8InfoT*) &_UTF8_ARRAY_OF_JAVA_LANG_THREAD)
#define UTF8_STARTUP_METHOD_DESCRIPTOR  ((const Utf8InfoT*) &_UTF8_STARTUP_METHOD_DESCRIPTOR)
#define UTF8_AssertionFailedError       ((const Utf8InfoT*) &_UTF8_AssertionFailedError)

extern const Utf8InfoT2  _UTF8_BOOLEAN_ARRAY;
extern const Utf8InfoT2  _UTF8_CHAR_ARRAY;
extern const Utf8InfoT2  _UTF8_FLOAT_ARRAY;
extern const Utf8InfoT2  _UTF8_DOUBLE_ARRAY;
extern const Utf8InfoT2  _UTF8_BYTE_ARRAY;
extern const Utf8InfoT2  _UTF8_SHORT_ARRAY;
extern const Utf8InfoT2  _UTF8_INT_ARRAY;
extern const Utf8InfoT2  _UTF8_LONG_ARRAY;
extern const Utf8InfoT3  _UTF8_VOIDVOID;
extern const Utf8InfoT4  _UTF8_STARTUP_METHOD;
extern const Utf8InfoT6  _UTF8_INIT;
extern const Utf8InfoT8  _UTF8_CLINIT;
extern const Utf8InfoT18 _UTF8_CLASS_STRING;
extern const Utf8InfoT19 _UTF8_ARRAY_OF_JAVA_LANG_STRING;
extern const Utf8InfoT19 _UTF8_ARRAY_OF_JAVA_LANG_THREAD;
extern const Utf8InfoT22 _UTF8_STARTUP_METHOD_DESCRIPTOR;
extern const Utf8InfoT36 _UTF8_AssertionFailedError;

/**
 * 2  utf8 r܂.
 * @param x r utf8 
 * @param y r utf8 
 * @return 2  utf8 񂪓ꍇ 0 CقȂꍇ 0 ԋp܂B
 */
int nano_utf8_equals(const Utf8InfoT *x, const Utf8InfoT *y);

/**
 * w UTF8 񂪁Cprefix JnĂ邩ׂ.
 */
int nano_utf8_startsWith(const Utf8InfoT *s, const Utf8InfoT *prefix);

int nano_utf8_equals_for_classfile(const Utf8InfoT *x, const Utf8InfoT *y);


#endif /* UTF8_INFO_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef ARRAY_H
#define ARRAY_H

#include "typedefs.h"

#define ARRAY_T_BOOLEAN     4U
#define ARRAY_T_CHAR        5U
#define ARRAY_T_FLOAT       6U
#define ARRAY_T_DOUBLE      7U
#define ARRAY_T_BYTE        8U
#define ARRAY_T_SHORT       9U
#define ARRAY_T_INT         10U
#define ARRAY_T_LONG        11U

struct _Array { /* parasoft-suppress OPT-13 */
    ObjectHeaderT h;
    nano_u1 isPrimitive;
    nano_u4 length;
    void *elem_ptr;
    /* java heap 犄蓖ĂꍇČɔzvfێ */
};

void nano_array_initObject2(ArrayT *a, const ClassFileT *arraycls, nano_s4 count);

ArrayT *nano_array_new(unsigned atype, nano_s4 count);
ArrayT *nano_array_new_bysize(unsigned elementsize, nano_s4 count);
void nano_array_initWithPtr(ArrayT *a, nano_u1 *addr, nano_s4 count);
void nano_array_initPrimitive(ArrayT *a, unsigned atype, nano_s4 count);
int nano_array_initMulti2(ArrayT *a, const ClassFileT *arraycls, const nano_s4 *count, unsigned dimensions);

#define array_getLength(a)  ((a)->length)
#define array_getPtr(a)     ((a)->elem_ptr)
#define array_isPrimitive(a) ((a)->isPrimitive)
#define array_getClass(a)       ((a)->h.cf)

unsigned nano_array_getElementSize(const ArrayT *a);
void nano_array_copy(ArrayT *dst, const ArrayT *src, nano_s4 srcPos, nano_s4 destPos, nano_s4 length);


#endif                          /* ARRAY_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef CLASS_LOADER_H_
#define CLASS_LOADER_H_

#include "typedefs.h"

struct _ClassLoader {
    const nano_u4 *cpool;                /* RX^gv[ւ̃|C^ */
    nano_u2 cp_string_end_index;         /* ȉ̃CfbNX String */
    nano_u2 cp_long_start_index;         /* ȏ̃CfbNX Long */
    int utf8_table_size;
    const nano_u1 *utf8_table;
    const nano_u2 *ucs2_table;
    const ClassFileT **cfs;
    CellT **runtime;
    unsigned int count;                      /* NXt@C̐ */
    
  #if (LOADABLE == 1)
    /* module info */
    const Utf8InfoT *maker;         /* [J[ */
    const Utf8InfoT *module;        /* W[ */
    nano_u4 version;                     /* o[W */
    CellT *loadableApp;              /* CX^X */
    nano_u1 *depend_modules;             /* ˑ郂W[̃rbg}bv */
    unsigned used;
  #endif /* (LOADABLE == 1) */
  #if (METHOD_TABLE_ENABLE == 1)
    void *mt_memory;
  #endif /* (METHOD_TABLE_ENABLE == 1) */
};

// ̂ClassData.cŒ`
extern const ClassLoaderT cl0;

#define LOADER_getClassFromCPOOL(cl, i) ((const ClassFileT*) ((cl)->cpool[(i)]))
#define LOADER_getFieldFromCPOOL(cl, i) ((const FieldInfoT*) ((cl)->cpool[(i)]))
#define LOADER_getMethodFromCPOOL(cl, i) ((const MethodInfoT*) ((cl)->cpool[(i)]))
#define LOADER_getUtf8FromCPOOL(cl, i) ((const Utf8InfoT*) ((cl)->cpool[(i)]))
#define LOADER_getUcs2FromCPOOL(cl, i) ((const Ucs2InfoT*) ((cl)->cpool[(i)]))

/** NXNX擾. */
const ClassFileT *nano_getClass(const Utf8InfoT *name);

/** cf NX̔zT. */
const ClassFileT *nano_getArrayClass(const ClassFileT *cf);

/** zNX cf ̔zvf̃NXT. */
const ClassFileT *nano_getSubArrayClass(const ClassFileT *cf);

/** Onh pc ʒuT܂. */
const nano_u1 *nano_getExceptionHandlerPc(const MethodDefBytecodeT *method,
                                     const ClassFileT *exception, const nano_u1 *pc);

CellT *nano_ClassLoader_getConstantPoolString(const ClassLoaderT *cl, unsigned index);

#define nano_ClassLoader_isStringConstantPool(cl, index) ((index) < (cl)->cp_string_end_index)


#endif /* CLASS_LOADER_H_ */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef GLOBAL_H
#define GLOBAL_H

#include "typedefs.h"
#include "JSI.h"

extern nano_u4 global_type_id;

#endif                          /* GLOBAL_H */
/*
 * Copyright 2005 Aplix Corporation. All rights reserved.
 */
#ifndef JDWPTRANSPORT_H
#define JDWPTRANSPORT_H

#include "typedefs.h"

#define JDWP_Error_NONE         0
#define JDWP_Error_INVALID_THREAD   10
#define JDWP_Error_INVALID_THREAD_GROUP 11
#define JDWP_Error_INVALID_OBJECT   20
#define JDWP_Error_INVALID_CLASS    21
#define JDWP_Error_CLASS_NOT_PREPARED   22
#define JDWP_Error_INVALID_METHODID 23
#define JDWP_Error_INVALID_LOCATION 24
#define JDWP_Error_INVALID_FIELDID  25
#define JDWP_Error_INVALID_FRAMEID  30
#define JDWP_Error_NOT_IMPLEMENTED  99
#define JDWP_Error_ABSENT_INFORMATION   101
#define JDWP_Error_OUT_OF_MEMORY	110
#define JDWP_Error_INVALID_INDEX    503
#define JDWP_Error_INVALID_LENGTH   504


#define JDWP_EventKind_VM_DISCONNECTED  100
#define JDWP_EventKind_VM_START     90
#define JDWP_EventKind_THREAD_DEATH 7
#define JDWP_EventKind_SINGLE_STEP  1
#define JDWP_EventKind_BREAKPOINT   2
#define JDWP_EventKind_FRAME_POP    3
#define JDWP_EventKind_EXCEPTION    4
#define JDWP_EventKind_USER_DEFINED 5
#define JDWP_EventKind_THREAD_START 6
#define JDWP_EventKind_THREAD_END   7
#define JDWP_EventKind_CLASS_PREPARE    8
#define JDWP_EventKind_CLASS_UNLOAD 9
#define JDWP_EventKind_CLASS_LOAD   10
#define JDWP_EventKind_FIELD_ACCESS 20
#define JDWP_EventKind_FIELD_MODIFICATION   21
#define JDWP_EventKind_EXCEPTION_CATCH  30
#define JDWP_EventKind_METHOD_ENTRY 40
#define JDWP_EventKind_METHOD_EXIT  41
#define JDWP_EventKind_VM_INIT      90
#define JDWP_EventKind_VM_DEATH     99

#define JDWP_ThreadStatus_ZOMBIE    0
#define JDWP_ThreadStatus_RUNNING   1
#define JDWP_ThreadStatus_SLEEPING  2
#define JDWP_ThreadStatus_MONITOR   3
#define JDWP_ThreadStatus_WAIT      4

#define JDWP_SuspendStatus_SUSPEND_STATUS_SUSPENDED 0x01

#define JDWP_ClassStatus_VERIFIED   1
#define JDWP_ClassStatus_PREPARED   2
#define JDWP_ClassStatus_INITIALIZED    4
#define JDWP_ClassStatus_ERROR      8

#define JDWP_TypeTag_CLASS      1
#define JDWP_TypeTag_INTERFACE      2
#define JDWP_TypeTag_ARRAY      3

#define JDWP_Tag_ARRAY      '['
#define JDWP_Tag_BYTE       'B'
#define JDWP_Tag_CHAR       'C'
#define JDWP_Tag_OBJECT     'L'
#define JDWP_Tag_FLOAT      'F'
#define JDWP_Tag_DOUBLE     'D'
#define JDWP_Tag_INT        'I'
#define JDWP_Tag_LONG       'J'
#define JDWP_Tag_SHORT      'S'
#define JDWP_Tag_VOID       'V'
#define JDWP_Tag_BOOLEAN    'Z'
#define JDWP_Tag_STRING     's'
#define JDWP_Tag_THREAD     't'
#define JDWP_Tag_THREAD_GROUP   'g'
#define JDWP_Tag_CLASS_LOADER   'l'
#define JDWP_Tag_CLASS_OBJECT   'c'

#define JDWP_StepDepth_INTO 0
#define JDWP_StepDepth_OVER 1
#define JDWP_StepDepth_OUT  2
#define JDWP_StepDepth_INTO_RUN_CLINIT 3

#define JDWP_StepSize_MIN   0
#define JDWP_StepSize_LINE  1

#define JDWP_SuspendPolicy_NONE 0
#define JDWP_SuspendPolicy_EVENT_THREAD 1
#define JDWP_SuspendPolicy_ALL  2

#define JDWP_InvokeOptions_INVOKE_SINGLE_THREADED   0x01
#define JDWP_InvokeOptions_INVOKE_NONVIRTUAL        0x02


#ifndef JDWP_SLEEP_WHILE_WAITING_INPUT
  #define JDWP_SLEEP_WHILE_WAITING_INPUT	(0)
#endif /* JDWP_SLEEP_WHILE_WAITING_INPUT */

struct _JdwpLocation {
    nano_u1 typeTag;
    nano_u4 classID;
    nano_u4 methodID;
    nano_u8 index;
};

struct _JdwpCommand {
    nano_u4 length;
    nano_u4 id;
    nano_u1 flags;
    nano_u1 command_set;
    nano_u1 command;
    nano_u1 *data;

    int pos;
};


struct _JdwpResponse {
    nano_u4 length;
    nano_u4 id;
    nano_u1 flags;
    nano_u2 error_code;
    nano_u1 *data;
};



/* ʓI JDWP EVENT ̏
 * VMSTART, VMDEATH, THREADSTART, THREADDEATH ͂̂܂܎g */
struct _JdwpEventHeader {
    nano_u4 requestID;
    nano_u1 suspendPolicy;
    nano_u1 eventKind;
    nano_u4 count;
    nano_u4 clazz;
    JdwpStringT *classMatch_pattern;
    JdwpStringT *classExclude_pattern;
    nano_u4 instance;
    nano_u4 thread;
    JdwpLocationT loc;
};

struct _JdwpEventException {
    JdwpEventHeaderT h;
    nano_u4 exceptionOrNull;
    nano_u1 caught;
    nano_u1 uncaught;
};

struct _JdwpEventField {
    JdwpEventHeaderT h;
    nano_u4 declaring;
    nano_u4 fieldID;
};

struct _JdwpEventBreakpoint {
    JdwpEventHeaderT h;
    nano_u1 bytecode;
    ThreadT *suspending_thread;
};

struct _JdwpEventStep {
    JdwpEventHeaderT h;
    ThreadT *target_thread;
    FrameT *current_fp;
    FrameT *return_fp;
    nano_u4 step_begin;
    nano_u4 step_end;
    nano_u4 size;
    nano_u4 depth;
};

union _JdwpEvent {
    JdwpEventHeaderT        h;
    JdwpEventBreakpointT    breakpoint;
    JdwpEventStepT          step;
    JdwpEventFieldT         field;
    JdwpEventExceptionT     exception;
};

struct _JdwpTransport {
    int handshaked;
};

void nano_jdwpInitialize(void);
void nano_jdwpProc(void);

void nano_jdwpSendVmStartEvent(void);
void nano_jdwpSendVmDeathEvent(void);
void nano_jdwpSendThreadDeathEvent(nano_u4 type_id);

extern JdwpTransportT jdwp_;

#define EVT_BREAKPOINT      (1<<0)
#define EVT_STEP            (1<<1)
#define EVT_THREAD_START    (1<<2)
void nano_jdwpSendEvent(int jdwp_evt);
void nano_jdwpSendClassPrepareEvent(ClassLoaderT *loader);
void nano_jdwpSendClassUnloadEvent(ClassLoaderT *loader);

#endif                          /* JDWPTRANSPORT_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef METHOD_INFO_H
#define METHOD_INFO_H

#include "typedefs.h"

#define METHOD_ACC_PUBLIC       (0x0001U)
#define METHOD_ACC_PRIVATE      (0x0002U)
#define METHOD_ACC_PROTECTED    (0x0004U)
#define METHOD_ACC_STATIC       (0x0008U)
#define METHOD_ACC_FINAL        (0x0010U)
#define METHOD_ACC_SYNCHRONIZED (0x0020U)
#define METHOD_ACC_NATIVE       (0x0100U)
#define METHOD_ACC_ABSTRACT     (0x0400U)
#define METHOD_ACC_STRICT       (0x0800U)

/* \bhANZXtO̓ƎgȊÕrbg */
#define METHOD_ACC_STDMASK \
    (METHOD_ACC_PUBLIC | METHOD_ACC_PRIVATE | METHOD_ACC_PROTECTED \
    | METHOD_ACC_STATIC | METHOD_ACC_FINAL | METHOD_ACC_SYNCHRONIZED \
    | METHOD_ACC_NATIVE | METHOD_ACC_ABSTRACT | METHOD_ACC_STRICT)

/* ƎgtO */
#define METHOD_ACC_CLINIT       (0x4000U)
#define METHOD_ACC_CONSTRUCTOR  (0x8000U)

typedef void (*nativefunc) (void);

struct _MethodInfo { /* parasoft-suppress OPT-13 */
    const ClassFileT *cf;
    nano_u2 access_flags;
    nano_u2 arg_size;
  #if (METHOD_TABLE_ENABLE == 1)
    nano_u4 method_index;
  #endif /* (METHOD_TABLE_ENABLE == 1) */
    NameAndDescT nad;
};

struct _ExceptionHandler {
    nano_u2 start_pc;
    nano_u2 end_pc;
    nano_u2 handler_pc;
    nano_u2 catch_type;
};

struct _LineNumber {
    nano_u2 start_pc;
    nano_u2 line_number;
};

/* R[hύXOAhXƃR[hύX̃AhX̑Ήe[u */
struct _AddrCvtTbl {
    nano_u2 old_addr;
    nano_u2 new_addr;
};

struct _VariableTbl { /* parasoft-suppress OPT-13 */
    nano_u2 start_pc;
    nano_u2 length;
    nano_u2 index;
    const Utf8InfoT *name;
    const Utf8InfoT *desc;
};

struct _MethodDefBytecode { /* parasoft-suppress OPT-13 */
    MethodInfoT header;
    
    nano_u2 max_stack;
    nano_u2 max_locals;
    nano_u2 line_number_table_length;
    nano_u2 exception_handler_length;
    nano_u2 code_length;
    
  #if (JDWP == 1)
    nano_u1 *code;
    nano_u2 orinal_code_length;
    nano_u2 addr_cvt_tbl_size;
    nano_u2 variable_tbl_size;
    const AddrCvtTblT *addr_tbl;
    const VariableTblT *var_tbl;
  #else
    const nano_u1 *code;
  #endif /* JDWP */
    const LineNumberT *line_numbers;
    
    const ExceptionHandlerT exception_handlers[1];
};

struct _MethodDefNative {
    MethodInfoT header;
    const nativefunc func_ptr;
};

#define method_info_getName(m)  ((m)->nad.name)
#define method_info_getDescriptor(m) ((m)->nad.desc)
#define method_info_getNameAndDesc(m) (&(m)->nad)
#define method_info_getAccessFlags(m) ((m)->access_flags)

/* ̒ĺClong/double ^̈ 2CȊǑ^ 1 ƂĐlB
 * CX^X\bh̏ꍇ this ̕ 1 ZB*/
#define method_info_getArgSize(m) ((m)->arg_size)
#define method_info_getClassFile(m) ((m)->cf)

#endif                          /* METHOD_INFO_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef UNICODE_H
#define UNICODE_H

#include "typedefs.h"

/**
 * src  UTF-8  UCS-2 ɕϊ ucs Ɋi[B
 * @param src UTF-8 ւ̃|C^
 * @param length UTF-8 ̃oCg
 * @param ucs UCS-2󂯎obt@BNULL Ȃϊ̕ԂB
 * @param ucsCnt UCS-2󂯎obt@ɏ߂镶B
 * @param processedLen oCg̕ϊς݂̃oCgރobt@ւ̃|C^B
 * @return ϊ̕
 */
nano_s4 nano_Utf8_toUcs2(
	const nano_u1 *src, 
	nano_s4 length, 
	nano_u2 *ucs, 
	nano_s4 ucsCnt, 
	nano_s4* processedLen
);

/**
 * src  UTF-8  UCS-2 ɕΐA擾B
 * @param src UTF-8 ւ̃|C^
 * @param length UTF-8 ̃oCg
 * @return ԋp܂B
 */
#define nano_Utf8_getUcs2Count(src, length) nano_Utf8_toUcs2(src, length, NULL, 0, NULL)

/**
 * UCS2  UTF-8 ɕϊăobt@ɏށB
 * @param src UCS2 
 * @param length UCS2 ̕
 * @param dst o̓obt@BNULL͕sB
 * @return 񂾃oCgԋp܂B
 */
nano_s4 nano_Ucs2_toUtf8(const nano_u2 *src, nano_s4 length, nano_u1 *dst);

/**
 * UCS2  UTF-8 ɕϊ̃oCg擾B
 * @param ucs UCS2 
 * @param ucsCnt UCS2 ̕
 * @return oCgԋp܂B
 */
nano_s4 nano_Ucs2_getUtf8Length(const nano_u2* ucs, nano_s4 ucsCnt);

/**
 * UCS2  ASCII ɕϊăobt@ɏށB
 * @param ucs UCS2 
 * @param ucsCnt UCS2 ̕
 * @param bytes o̓obt@BNULL͕sB
 */
void nano_Ucs2_toAscii(const nano_u2* ucs, nano_s4 ucsCnt, nano_u1* bytes);

/**
 * ASCII  UCS2 ɕϊăobt@ɏށB
 * @param bytes ASCII
 * @param bytesLen ASCII ̕
 * @param ucs o̓obt@BNULL͕sB
 */
void nano_Ascii_toUcs2(const nano_u1* bytes, nano_s4 bytesLen, nano_u2* ucs);

#endif                          /* UNICODE_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef field_info_INFO_H
#define field_info_INFO_H

#include "typedefs.h"

#define FIELD_ACC_PUBLIC    0x0001U
#define FIELD_ACC_PRIVATE   0x0002U
#define FIELD_ACC_PROTECTED 0x0004U
#define FIELD_ACC_STATIC    0x0008U
#define FIELD_ACC_FINAL     0x0010U
#define FIELD_ACC_VOLATILE  0x0040U
#define FIELD_ACC_TRANSIENT 0x0080U

struct _FieldInfo { /* parasoft-suppress OPT-13 */
    const ClassFileT *cf;
    nano_u2 access_flags;
    nano_u2 constant_value_index;
    NameAndDescT nad;
    unsigned index; /* field index */
};

#define field_info_getName(f)   ((f)->nad.name)
#define field_info_getDescriptor(f) ((f)->nad.desc)
#define field_info_getNameAndDesc(f) (&(f)->nad)
#define field_info_getAccessFlags(f) ((f)->access_flags)
#if (FLOAT_SUPPORT == 1)
  #define field_info_is64(f) (((f)->nad.desc->bytesX[0] == (unsigned) 'J') || \
  							  ((f)->nad.desc->bytesX[0] == (unsigned) 'D'))
#else
  #define field_info_is64(f) ((f)->nad.desc->bytesX[0] == (unsigned) 'J')
#endif
#define field_info_getIndex(f) ((f)->index)

#endif                          /* FIELD_INFO_H */
/*
 * Copyright 2005-2009 Aplix Corporation. All rights reserved.
 */
#ifndef HEAP_H
#define HEAP_H

#include <stddef.h>
#include "typedefs.h"

/* 1 y[W̃oCg (2^N) */
#ifndef PAGE_SIZE
  #define PAGE_SIZE           1024U
#endif /* PAGE_SIZE */

/* ŏubNTCY (2^N) */
#define PAGE_GRANULARITY    16U

#define PAGE_FULL       (1UL << 31)

//#define Page_clearFlag(page, index) (page)->tags[(index) >> 3] |= (1U << ((index) & 7U))

struct _Page { /* parasoft-suppress OPT-13 */
	// y[WTCY
    nano_u4 size;
    // TCYʃy[WXgCgpXg̎vfiI[ NULL)
    PageT *next;
    // y[W^Oirbg ON:gp, OFF:gpj
    unsigned tags[PAGE_SIZE / PAGE_GRANULARITY / (sizeof(unsigned) * 8)];
};

#define    ALLOCTYPE_INSTANCE	 (1U)
#define    ALLOCTYPE_OTHER (2U)
#define    ALLOCTYPE_ARRAY (3U)
#define    IS_ALLOCTYPE_ARRAY_OR_INSTANCE(type) ((type) & ALLOCTYPE_INSTANCE)

#if (PAGE_SIZE == 32)
  #define NUM_SIZED_LIST	2
#elif (PAGE_SIZE == 64)
  #define NUM_SIZED_LIST	3
#elif (PAGE_SIZE == 128)
  #define NUM_SIZED_LIST	4
#elif (PAGE_SIZE == 256)
  #define NUM_SIZED_LIST	5
#elif (PAGE_SIZE == 512)
  #define NUM_SIZED_LIST	6
#elif (PAGE_SIZE == 1024)
  #define NUM_SIZED_LIST	7
#elif (PAGE_SIZE == 2048)
  #define NUM_SIZED_LIST	8
#elif (PAGE_SIZE == 4096)
  #define NUM_SIZED_LIST	9
#elif (PAGE_SIZE == 8192)
  #define NUM_SIZED_LIST	10
#elif (PAGE_SIZE == 16384)
  #define NUM_SIZED_LIST	11
#elif (PAGE_SIZE == 32768)
  #define NUM_SIZED_LIST	12
#elif (PAGE_SIZE == 65536)
  #define NUM_SIZED_LIST	13
#else
  #error It is not possible to correspond to PAGE_SIZE that you specified.
#endif

struct _Heap { /* parasoft-suppress OPT-13 */
    unsigned org_num_pages;
    unsigned num_pages;
    nano_u4 max_size;
    nano_u4 size;
    nano_u4 old_size;
    nano_u4 force_gc_size;
    nano_u1 *page_start_ptr;

    PageT *pageTable;
    CellT *cellTable_head;
    CellT *cellTable_end;
    CellT *find_cell;
    // TCYʃy[WXgCŏIvf͖gpy[WubNXg
    PageT *page_list[NUM_SIZED_LIST];
};

#if (DEBUG == 1) && (LOG_INFO == 1)
  #define HEAP_ALLOC(b, c)    nano_Heap_allocDebug(b, c, __FILE__, __LINE__)
  CellT *nano_Heap_allocDebug(unsigned tag, size_t size, const char *file, int line);
#else
  #define HEAP_ALLOC(b, c)    nano_Heap_alloc(b, c)
#endif

void nano_Heap_init(void *pool, size_t size);

/**
 * mۂꂽ̈̓NAĂȂ
 * sɂ Exception ZbgB
 * @return sŊmۂłȂꍇ NULL
 */
CellT *nano_Heap_alloc(unsigned tag, size_t size);

CellT *nano_Heap_realloc(CellT *cell, size_t size);

void nano_Heap_mark(void);
void nano_Heap_traverse(void);
void nano_Heap_clearMark(void);

// O gc 炱̒l gc CƂ臒l.
extern nano_u4 nano_gc_threshold_bytes;

/* C^v^̊֐Ăяo񐔂}邽߂ Heap_gc */
#define Heap_gc_m()														\
    if ((gheap_.force_gc_size) || (gheap_.size - gheap_.old_size >= nano_gc_threshold_bytes)) {		\
        nano_Heap_gc();													\
    }

void nano_Heap_gc(void);
void *nano_Heap_getPtr(nano_u4 pageId, nano_u4 pageIndex);

#define Heap_getSize()      (gheap_.size)
#define Heap_getMaxSize()   (gheap_.max_size)
#define Heap_getFreeSize()  (gheap_.max_size - gheap_.size)

#if (JDWP == 1)
CellT *Heap_getCellByTypeID(nano_u4 typeID);
#endif


#if (REFERENCE_TRACE == 1)
extern void nano_check_reftrace_gc(void);
extern void nano_reftrace_init(void);
#endif /* (REFERENCE_TRACE == 1) */

extern HeapT gheap_;

#endif                          /* HEAP_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef CLASS_FILE_H
#define CLASS_FILE_H

#include "typedefs.h"

#define CLASS_ACC_PUBLIC    0x0001U
#define CLASS_ACC_FINAL     0x0010U
#define CLASS_ACC_SUPER     0x0020U
#define CLASS_ACC_INTERFACE 0x0200U
#define CLASS_ACC_ABSTRACT  0x0400U

#define CLASS_NOT_INITIALIZED		0U
#define CLASS_VARIABLES_INITIALIZED	1U
#define CLASS_INITIALIZED			2U
#define CLASS_ERROR					3U

struct _ClassStatus { /* parasoft-suppress OPT-13 */
    CellT *monitor;
    union {
        /* threadId ̓NXɎgp邾ŁĈܑȂ̂ŁC
         * cls_status Ƌp̂ɂĐߖ񂷂B
         * cls_status  0 ` 3 ȊÔƂCCLASS_CLINIT_RUNNABLE ŁC
         * threadId L. */
        nano_u4 cls_status;
        ThreadT *threadId;
    } u;
    
    nano_s4 class_variable[1];
};

struct _ClassFile { /* parasoft-suppress OPT-13 */
    nano_u2 access_flags;
  #if (JDWP == 1) || (ENABLE_CHECKCAST == 1) || (LOADABLE == 1)
    nano_u2 interfaces_count;
  #endif /* (JDWP == 1) || (ENABLE_CHECKCAST == 1) || (LOADABLE == 1) */
    nano_u2 fields_count;
    nano_u2 methods_count;
    nano_u2 class_variable_count;
    nano_u2 isArray;
  #if (METHOD_TABLE_ENABLE != 1)
    nano_u2 packageLength;
  #endif /* (METHOD_TABLE_ENABLE != 1) */
  #if (LOADABLE == 1) && (METHOD_TABLE_ENABLE == 1)
    nano_u4 method_table_size;
  #endif /* (LOADABLE == 1) && (METHOD_TABLE_ENABLE == 1) */
    
    const Utf8InfoT *this_class;
    const ClassFileT *super_class;
    const FieldInfoT *fields;
    const MethodInfoT* const *methods;
    const Utf8InfoT *sourcefile;
//
    const ClassLoaderT *cl;
  #if (JDWP == 1)
    nano_u4 type_id;
  #endif /* (JDWP == 1) */
    int total_instance_variable_count;
    ClassStatusT *status;

  #if (METHOD_TABLE_ENABLE == 1)
    const MethodInfoT* const * method_table;
  #endif /* (METHOD_TABLE_ENABLE == 1) */
    
    const ClassFileT *interfaces[1];
};

#define CLASS_getSuperClass(c)              ((c)->super_class)
#define CLASS_getName(c)                    ((c)->this_class)
#define CLASS_getSourceFileName(c)          ((c)->sourcefile)
#define CLASS_isArray(c)                    ((c)->isArray)
#define CLASS_isInitialized(c)              ((c)->status->u.cls_status == CLASS_INITIALIZED)
#define CLASS_getInstanceVariableCount(c)	((size_t) (c)->total_instance_variable_count)
#define CLASS_getInstanceVariableSize(c)    (((size_t) (c)->total_instance_variable_count) * (sizeof(nano_s4)))


const MethodInfoT *nano_findMethod(const ClassFileT *this, const NameAndDescT *nad);

const MethodInfoT *nano_getExecMethod_super(const ClassFileT *target_class,
                                            const MethodInfoT *method);

const MethodInfoT *nano_getExecMethod(const ClassFileT *instance_cf,
                                      const MethodInfoT *resolve_method);

const MethodInfoT *nano_getExecMethod_pub(const ClassFileT *instance_cf,
                                          const MethodInfoT *resolve_method);


CellT *nano_getClassMonitor(const ClassFileT *cf);


typedef struct _ClassIterate {
	int i;
    unsigned int j;
} ClassIterateT;

void nano_ClassIterator_init(ClassIterateT *p);
const ClassFileT *nano_ClassIterator_getNext(ClassIterateT *p);
const MethodInfoT *nano_getExecMethod_interface(const ClassFileT *instance_cf,
                                                const MethodInfoT *resolve_method);

const MethodInfoT *nano_resolveMethod(const ClassFileT *target_class,
                                      const NameAndDescT *nad);


#if (JDWP == 1)
/**
 * X[p[NXAX[p[C^[tFCXΏۂƂB
 */
const FieldInfoT *nano_resolveField(const ClassFileT *cf, const NameAndDescT *nad);
#endif /* (JDWP == 1) */

#if (JDWP == 1) || (LOADABLE == 1)
/**
 * w肳ꂽNX݂̂ΏۂƂB
 */
const FieldInfoT *nano_findFieldFromClass(const ClassFileT *cf, const NameAndDescT *nad);
#endif /* (JDWP == 1) || (LOADABLE == 1) */

#endif                          /* CLASS_FILE_H */
/*
 * Copyright 2005-2008 Aplix Corporation. All rights reserved.
 */
#ifndef NATIVESUPPORT_H
#define NATIVESUPPORT_H

#include "typedefs.h"

/*
 * TODO: JBI.hƓedĂ邪Avmlibł̊֐ĝɕKv
 */
void nano_pushStack(nano_s4 value);
nano_s4 nano_popStack(void);
nano_u1 *nano_getByteArray(nano_s4 cell, nano_s4 *length);
const nano_u2 *nano_getString(nano_s4 cell, nano_s4 *length);
nano_s4 nano_newString(const nano_u1 *utf8);
nano_s4 nano_newStringUCS2(const nano_u2 *ucs2, nano_s4 length);
int notifyInterrupt(int id, nano_s4 value);


/**
 * oCgz̍쐬B
 * <p>
 * byte[] CX^X𐶐܂B<br>
 * @param ptr 
 *     oCg̔zvfƂȂf[^̃AhXw肵܂B
 * @param length oCg̒w肵܂B
 * @param isCopy 
 *   1 ̏ꍇ:<br>
 *     length ̔zvf byte[] CX^X𐶐C
 *     ̔zvf ptr[0] ` ptr[length - 1] ̒lRs[܂B<br>
 *     ̔zvf̎́ivfێ郁j Java q[vmۂ̂łC
 *     iRs[́jptr Ƃ͖֌WłB<br>
 *     łCiōsjJava vOł̂ byte[] CX^X̔zvf̓ǂݏɂāC
 *     ptr ANZX邱Ƃ͂܂B<br>
 *     ʏ isCopy = 1 Ŏgp邱Ƃz肵Ă܂B<br>
 *   0 ̏ꍇ:<br>
 *     uisCopy = 1vƓlɁClength ̔zvf byte[] CX^X𐶐܂C
 *     uisCopy = 1vƈقȂC̔zvf̎̂ ptr ̂̂łB<br>
 *     ܂CiōsjJava vOł̂ byte[] CX^X̔zvf̓ǂݏ́C
 *     ptr ̒ڂ̓ǂݏɑ܂B<br>
 *     łC̊֐IC
 *     uJava vO byte[] CX^X̔zvfANZXȂƂmMł܂Łv
 *      ptr ̃̈pđ݂Ȃ΂Ȃ܂B<br>
 *     ̂悤ɁuisCopy = 0vŐ byte[] CX^X́C
 *     gÂ炢_܂CtɈȉ̗_܂B<br>
 *     - Java q[vȂ
 *     - Rs[svł邱
 *     - lCeBu Java œ̎̂̃oCgf[^Lł邱
 * @return
 *   oCgz̃CX^X̃nhԋp܂B
 *   ̊֐́CJava q[vsĂƎs܂B<br>
 *   s 0 ԋpCjava.lang.OutOfMemoryError X[܂B
 *   i{֐ŃX[ꂽÓClCeBu\bhIɏ܂Bj
 */
//CellT *nano_newByteArray(nano_u1 *ptr, nano_u4 length, int isCopy);

#if defined(JSI_FILE_CHARSET_UTF8) || (FLOAT_SUPPORT == 1)
/**
 * This function returns utf8 string with null terminator.
 * The returned string will be allocated by nano_Memory_alloc().
 * So please free the string after you used it by nano_Memory_free().
 * If memory is insufficient to process then OutOfMemoryError will be set,
 * so you don't need to set Exception.
 * If Java String includes \u0000, this function translate \u0000 to \0,
 * so if these case may occur, check parameter named len.
 * @param cell_addr
 *   pointer to cell address pointer it indicates Java String instance.
 * @param len
 *   pointer to memory which will be set the number of translated characters.
 *   If this param are set as NULL, this function does not set it.
 * @return If memory is insufficient then null.
 */
nano_u1* nano_getUtf8CString(CellT* cell_addr, nano_s4* len);
#endif /* defined(JSI_FILE_CHARSET_UTF8) */

#if defined(JSI_FILE_CHARSET_UTF16)
/**
 * This function returns utf16 string with null terminator.
 * The returned string will be allocated by nano_Memory_alloc().
 * So please free the string after you used it by nano_Memory_free().
 * If memory is insufficient to process then OutOfMemoryError will be set,
 * so you don't need to set Exception.
 * If Java String includes \u0000, this function translate \u0000 to \0,
 * so if these case may occur, check parameter named len.
 * @param cell_addr
 *   pointer to cell address pointer it indicates Java String instance.
 * @param len
 *   pointer to memory which will be set the number of translated characters.
 *   If this param are set as NULL, this function does not set it.
 * @return If memory is insufficient then null.
 */
nano_u2* nano_getUtf16CString(const CellT* cell, nano_s4* len);
#endif /* defined(JSI_FILE_CHARSET_UTF16) */


////////////////////////////////////////////////////////////////
// NAtiveHelper.c ɂĎ

/**
 * CX^XtB[hAyуX^eBbNtB[h̃CfNX擾܂B
 * 
 * @param cls 
 *  class\nhlBnano_Instance_getClass() ̕ԂlȂǁB
 *  0 yѕsȒlnꍇ͕̓słB
 * @param fieldName 
 *  UTF-8ł̃tB[hBNULL terminated łKv͖B
 *  NULL nꍇ͕̓słB
 * @param fieldNameLen tB[h̃oCgBNULL܂܂B
 * @param fieldDescriptor 
 *  UTF-8ł̃tB[ȟ^`BNULL terminated łKv͖B
 *  NULL nꍇ͕̓słB
 * @param fieldDescriptorLen tB[ȟ^`̃oCgBNULL܂܂B
 * @return CX^XtB[h̃tB[hCfbNXBȂꍇ͕lB 
 */
int nano_Class_getFieldIndex(
	nano_s4 cls, 
	const char *fieldName, 
	int fieldNameLen, 
	const char *fieldDescriptor, 
	int fieldDescriptorLen
);

#endif                          /* NATIVESUPPORT_H */
