/*
 * Decompiled with CFR 0.152.
 */
package jp.co.hitachi_kokusai.terminal;

import com.docomo_um.io.IOProperties;
import com.docomo_um.lang.Degree;
import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.module.ModuleException;
import com.docomo_um.module.ModuleFunctions;
import com.docomo_um.module.ModuleManager;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.connection.ADChannel;
import com.docomo_um.module.connection.ADConverter;
import com.docomo_um.module.connection.ADConverterFunctions;
import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.GPIOConnection;
import com.docomo_um.module.connection.GPIOFunctions;
import com.docomo_um.module.connection.I2CConnection;
import com.docomo_um.module.connection.I2CSlave;
import com.docomo_um.module.connection.I2CSpec;
import com.docomo_um.module.connection.SPIFunctions;
import com.docomo_um.module.connection.Serial;
import com.docomo_um.module.connection.SerialConnection;
import com.docomo_um.module.connection.SerialListener;
import com.docomo_um.module.connection.SerialSpec;
import com.docomo_um.module.location.Location;
import com.docomo_um.module.location.LocationException;
import com.docomo_um.module.location.LocationProperties;
import com.docomo_um.module.location.LocationProviderImpl;
import com.docomo_um.module.net.IPSettingInfo;
import com.docomo_um.module.net.ModemController;
import com.docomo_um.module.net.ModemControllerTerminalListener;
import com.docomo_um.module.net.NetProperties;
import com.docomo_um.module.net.PPPSettingInfo;
import com.docomo_um.module.net.PacketControllerImpl;
import com.docomo_um.module.net.PacketSession;
import com.docomo_um.module.net.Session;
import com.docomo_um.module.net.SessionException;
import com.docomo_um.module.net.ShortMessageFunctions;
import com.docomo_um.module.net.USSDFunctions;
import com.docomo_um.module.net.USSDServiceTerminalListener;
import com.docomo_um.module.net.VoiceControllerImpl;
import com.docomo_um.module.net.VoiceSession;
import com.docomo_um.module.net.ssl.SSLProperties;
import com.docomo_um.win.LogListener;
import com.docomo_um.win.Logging;
import com.docomo_um.win.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.co.hitachi_kokusai.Version;

public class TerminalIF
extends Thread {
    Map<String, TerminalCommand> commandMap;
    Map<String, Session> sessionMap = new HashMap<String, Session>();
    List<String> commandList;
    String termPort = "COM8";
    String msg;
    Serial port = null;
    ModuleManager moduleMan;
    ConnectionManager connectionMan;
    VoiceControllerImpl voiceController;
    PacketControllerImpl packetController;

    public TerminalIF() {
        this.commandMap = new HashMap<String, TerminalCommand>();
        this.commandList = new ArrayList<String>();
        this.commandList.add("Quit");
        this.commandMap.put("QUIT", null);
        this.commandList.add("?");
        this.commandMap.put("?", new CommandHelp());
        this.commandMap.put("LOCALVERSION", new CommandLocalVersion());
        this.commandList.add("Reset");
        this.commandMap.put("RESET", new CommandReset());
        this.commandList.add("SystemUpdate");
        this.commandMap.put("SYSTEMUPDATE", new CommandSystemUpdate());
        this.commandList.add("SystemUpdateAbort");
        this.commandMap.put("SYSTEMUPDATEABORT", new CommandSystemUpdateAbort());
        this.commandList.add("CancelSystemUpdate");
        this.commandMap.put("CANCELSYSTEMUPDATE", new CommandCancelSystemUpdate());
        this.commandList.add("UpdateStatus");
        this.commandMap.put("UPDATESTATUS", new CommandUpdateSystemStatus());
        this.commandList.add("SignalStatus");
        this.commandMap.put("SIGNALSTATUS", new CommandSignalStatus());
        this.commandList.add("AreaInfo");
        this.commandMap.put("AREAINFO", new CommandAreaInfo());
        this.commandList.add("Regulation");
        this.commandMap.put("REGULATION", new CommandRegulation());
        this.commandList.add("ReceivedPower");
        this.commandMap.put("RECEIVEDPOWER", new CommandReceivedPower());
        this.commandList.add("Send");
        this.commandMap.put("SEND", new CommandSend());
        this.commandList.add("Receive");
        this.commandMap.put("RECEIVE", new CommandReceive());
        this.commandList.add("Disconnect");
        this.commandMap.put("DISCONNECT", new CommandDisconnect());
        this.commandList.add("USSDSend");
        this.commandMap.put("USSDSEND", new CommandUSSDSend());
        this.commandList.add("Guidance");
        this.commandMap.put("GUIDANCE", new CommandGuidance());
        this.commandList.add("SMSSend");
        this.commandMap.put("SMSSEND", new CommandSMSSend());
        this.commandList.add("I2Csend");
        this.commandMap.put("I2CSEND", new CommandI2CSend());
        this.commandList.add("AD");
        this.commandMap.put("AD", new CommandAD());
        this.commandList.add("GPIO");
        this.commandMap.put("GPIO", new CommandGPIO());
        this.commandList.add("SPIStart");
        this.commandMap.put("SPISTART", new CommandSPIStart());
        this.commandList.add("SPIStop");
        this.commandMap.put("SPISTOP", new CommandSPIStop());
        this.commandList.add("UIM");
        this.commandMap.put("UIM", new CommandUIM());
        this.commandList.add("Location");
        this.commandMap.put("LOCATION", new CommandLocation());
        this.commandList.add("ProvideLocation");
        this.commandMap.put("PROVIDELOCATION", new CommandProvideLocation());
        this.commandList.add("LocationStatus");
        this.commandMap.put("LOCATIONSTATUS", new CommandLocationStatus());
        this.commandList.add("ModuleException");
        this.commandMap.put("MODULEEXCEPTION", new CommandModuleException());
        this.commandList.add("CommunicationFailureException");
        this.commandMap.put("COMMUNICATIONFAILUREEXCEPTION", new CommandCommunicationFailureException());
        this.commandList.add("IOException");
        this.commandMap.put("IOEXCEPTION", new CommandIOException());
        this.commandList.add("DeviceException");
        this.commandMap.put("DEVICEEXCEPTION", new CommandDeviceException());
        this.commandList.add("ExternalStatusException");
        this.commandMap.put("EXTERNALSTATUSEXCEPTION", new CommandExternalStatusException());
        this.commandList.add("IllegalSettingException");
        this.commandMap.put("ILLEGALSETTINGEXCEPTION", new CommandIllegalSettingException());
        this.commandList.add("RegulationException");
        this.commandMap.put("REGULATIONEXCEPTION", new CommandRegulationException());
        this.commandList.add("LoadableModuleException");
        this.commandMap.put("LOADABLEMODULEEXCEPTION", new CommandLoadableModuleException());
        this.commandList.add("USSDServiceException");
        this.commandMap.put("USSDSERVICEEXCEPTION", new CommandUSSDServiceException());
        this.commandList.add("SecureHandshakeException");
        this.commandMap.put("SECUREHANDSHAKEEXCEPTION", new CommandSecureHandshakeException());
        this.commandList.add("IllegalCertificateException");
        this.commandMap.put("ILLEGALCERTIFICATEEXCEPTION", new CommandIllegalCertificateException());
        this.commandList.add("SessionException");
        this.commandMap.put("SESSIONEXCEPTION", new CommandSessionException());
        this.commandList.add("mailException");
        this.commandMap.put("MAILEXCEPTION", new CommandMailException());
        this.commandList.add("LocationException");
        this.commandMap.put("LOCATIONEXCEPTION", new CommandLocationException());
        this.commandList.add("TimerException");
        this.commandMap.put("TIMEREXCEPTION", new CommandTimerException());
        this.commandList.add("ConnectionException");
        this.commandMap.put("CONNECTIONEXCEPTION", new CommandConnectionException());
        this.commandList.add("ShortMessageException");
        this.commandMap.put("SHORTMESSAGEEXCEPTION", new CommandShortMessageException());
        TerminalSessionListener terminalSessionListener = new TerminalSessionListener();
        try {
            this.moduleMan = ModuleManager.getInstance();
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
        }
        this.connectionMan = this.moduleMan.getConnectionManager();
        this.voiceController = (VoiceControllerImpl)this.moduleMan.getVoiceController();
        this.voiceController.setModemControllerTerminalListener(terminalSessionListener);
        this.packetController = (PacketControllerImpl)this.moduleMan.getPacketController();
        this.packetController.setModemControllerTerminalListener(terminalSessionListener);
        USSDFunctions.setTerminalListener(new TerminalUSSDListener());
        this.termPort = SystemProperties.getInstance().getTerminalPort();
        Logging.getInstance().setLogListener(new LogMessageListener());
        SerialConnection serialConnection = (SerialConnection)this.connectionMan.getConnection(3);
        List<SerialSpec> list = serialConnection.getSerialSpec();
        String string = ConnectionProperties.getInstance().getTerminalPort(this.termPort);
        for (int i = 0; i < list.size(); ++i) {
            SerialSpec serialSpec = list.get(i);
            if (!serialSpec.getDeviceName().equals(string)) continue;
            System.out.println("Terminal I/F open port" + serialSpec.getDeviceName());
            try {
                this.port = serialConnection.getSerial(serialSpec);
            }
            catch (ConnectionException connectionException) {
                connectionException.printStackTrace();
            }
            break;
        }
    }

    @Override
    @Override
    public void run() {
        Logging.getInstance().start();
        if (this.port == null) {
            System.out.println("Error Terminal I/F cannot open serial port!");
            return;
        }
        TerminalMessageListener terminalMessageListener = new TerminalMessageListener();
        try {
            this.port.setCommSpeed(9600L);
            this.port.setEnable(true);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
            return;
        }
        this.port.setSerialListener(terminalMessageListener);
        this.println("==============================================");
        this.println("um03koVM Terminal I/F Start (SDK " + Version.getVersion() + ")");
        this.println("==============================================");
        while (true) {
            Object object;
            this.msg = terminalMessageListener.read();
            if (this.msg == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(this.msg, " ");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string = stringTokenizer.nextToken();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (this.commandMap.containsKey(string = string.toUpperCase())) {
                object = this.commandMap.get(string);
                if (object == null) break;
                try {
                    if (object.CommandProc(arrayList)) continue;
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        object.Usage();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
            }
            object = "\u30b3\u30de\u30f3\u30c9(" + string + ")\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\r\n";
            try {
                this.port.getOutputStream().write(((String)object).getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.println("===============================");
        this.println("um03koVM Terminal I/F Terminate");
        this.println("===============================");
        try {
            this.port.setEnable(false);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
        Logging.getInstance().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String string) {
        TerminalIF terminalIF = this;
        synchronized (terminalIF) {
            try {
                this.port.getOutputStream().write(string.getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        string = string + "\r\n";
        TerminalIF terminalIF = this;
        synchronized (terminalIF) {
            try {
                this.port.getOutputStream().write(string.getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class TerminalSessionListener
    implements ModemControllerTerminalListener {
        private TerminalSessionListener() {
        }

        @Override
        @Override
        public void onSend(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u97f3\u58f0\u767a\u4fe1\uff1a" + string);
                TerminalIF.this.sessionMap.put(string, voiceSession);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                PacketSession packetSession = (PacketSession)session;
                String string = packetSession.getDestination();
                TerminalIF.this.println("\u30d1\u30b1\u30c3\u30c8\u767a\u4fe1\uff1a" + string);
                if (packetSession.getPDPTypeInfo().getPDPType() == 1) {
                    IPSettingInfo iPSettingInfo = (IPSettingInfo)packetSession.getPDPTypeInfo();
                    TerminalIF.this.print("IP:  autthentication = ");
                    switch (iPSettingInfo.getIPAuthentication()) {
                        case 0: {
                            TerminalIF.this.println("NONE");
                            break;
                        }
                        case 1: {
                            TerminalIF.this.println("CHAP");
                            TerminalIF.this.println("    username = " + iPSettingInfo.getUserName());
                            TerminalIF.this.println("    password = " + iPSettingInfo.getPassword());
                            break;
                        }
                        case 2: {
                            TerminalIF.this.println("PAP");
                            TerminalIF.this.println("    username = " + iPSettingInfo.getUserName());
                            TerminalIF.this.println("    password = " + iPSettingInfo.getPassword());
                        }
                    }
                    TerminalIF.this.print("    Allocating IP = ");
                    switch (iPSettingInfo.getAllocatingIP()) {
                        case 1: {
                            TerminalIF.this.println("STATIC");
                            TerminalIF.this.println("    IP address = " + iPSettingInfo.getIPAddress());
                            break;
                        }
                        case 0: {
                            TerminalIF.this.println("DYNAMIC");
                        }
                    }
                    TerminalIF.this.print("    Allocating DNS = ");
                    switch (iPSettingInfo.getAllocatingDNS()) {
                        case 1: {
                            TerminalIF.this.println("STATIC");
                            TerminalIF.this.println("    primary DNS   = " + iPSettingInfo.getPrimaryDNS());
                            TerminalIF.this.println("    secondary DNS = " + iPSettingInfo.getSecondaryDNS());
                            break;
                        }
                        case 0: {
                            TerminalIF.this.println("DYNAMIC");
                        }
                    }
                } else if (packetSession.getPDPTypeInfo().getPDPType() == 0) {
                    PPPSettingInfo pPPSettingInfo = (PPPSettingInfo)packetSession.getPDPTypeInfo();
                    TerminalIF.this.print("PPP: autthentication = ");
                    switch (pPPSettingInfo.getPPPAuthentication()) {
                        case 0: {
                            TerminalIF.this.println("NONE");
                            break;
                        }
                        case 1: {
                            TerminalIF.this.println("CHAP");
                            TerminalIF.this.println("    username = " + pPPSettingInfo.getUserName());
                            TerminalIF.this.println("    password = " + pPPSettingInfo.getPassword());
                            break;
                        }
                        case 2: {
                            TerminalIF.this.println("PAP");
                            TerminalIF.this.println("    username = " + pPPSettingInfo.getUserName());
                            TerminalIF.this.println("    password = " + pPPSettingInfo.getPassword());
                        }
                    }
                    TerminalIF.this.print("    Allocating IP = ");
                    switch (pPPSettingInfo.getAllocatingIP()) {
                        case 1: {
                            TerminalIF.this.println("STATIC");
                            TerminalIF.this.println("    IP address = " + pPPSettingInfo.getIPAddress());
                            break;
                        }
                        case 0: {
                            TerminalIF.this.println("DYNAMIC");
                        }
                    }
                    TerminalIF.this.print("    Allocating DNS = ");
                    switch (pPPSettingInfo.getAllocatingDNS()) {
                        case 1: {
                            TerminalIF.this.println("STATIC");
                            TerminalIF.this.println("    primary DNS   = " + pPPSettingInfo.getPrimaryDNS());
                            TerminalIF.this.println("    secondary DNS = " + pPPSettingInfo.getSecondaryDNS());
                            break;
                        }
                        case 0: {
                            TerminalIF.this.println("DYNAMIC");
                        }
                    }
                }
                TerminalIF.this.sessionMap.put(string, packetSession);
            }
        }

        @Override
        @Override
        public void onDisconnect(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u97f3\u58f0\u5207\u65ad\uff1a" + string);
                TerminalIF.this.sessionMap.remove(string);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                PacketSession packetSession = (PacketSession)session;
                String string = packetSession.getDestination();
                TerminalIF.this.println("\u30d1\u30b1\u30c3\u30c8\u5207\u65ad\uff1a" + string);
                TerminalIF.this.sessionMap.remove(string);
            }
        }

        @Override
        @Override
        public void onHold(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u4fdd\u7559\uff1a" + string);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                // empty if block
            }
        }

        @Override
        @Override
        public void onReceive(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u97f3\u58f0\u5fdc\u7b54\uff1a" + string);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                PacketSession packetSession = (PacketSession)session;
                String string = packetSession.getDestination();
                TerminalIF.this.println("\u30d1\u30b1\u30c3\u30c8\u5fdc\u7b54\uff1a" + string);
            }
        }

        @Override
        @Override
        public void onDTMF(ModemController modemController, Session session, String string) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string2 = voiceSession.getDestination();
                TerminalIF.this.println("DTMF\uff1a" + string2 + "\uff1a" + string);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                // empty if block
            }
        }

        @Override
        @Override
        public void onReject(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u63a5\u7d9a\u62d2\u5426\uff1a" + string);
            } else if (modemController.equals(TerminalIF.this.packetController)) {
                // empty if block
            }
        }

        @Override
        @Override
        public void onSendAnswering(ModemController modemController, Session session) {
            if (modemController.equals(TerminalIF.this.voiceController)) {
                VoiceSession voiceSession = (VoiceSession)session;
                String string = voiceSession.getDestination();
                TerminalIF.this.println("\u7559\u5b88\u756a\u96fb\u8a71\uff1a" + string);
            }
        }
    }

    private class TerminalUSSDListener
    implements USSDServiceTerminalListener {
        private TerminalUSSDListener() {
        }

        @Override
        @Override
        public void onSend(String string) {
            TerminalIF.this.println("USSD\uff1a" + string);
        }
    }

    public class LogMessageListener
    implements LogListener {
        @Override
        @Override
        public void onMessage(String string) {
            TerminalIF.this.println(string);
        }
    }

    private static interface TerminalCommand {
        public boolean CommandProc(List<String> var1) throws IOException;

        public void Usage() throws IOException;
    }

    private class CommandLocationStatus
    implements TerminalCommand {
        private CommandLocationStatus() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            int n = 0;
            try {
                n = ModuleManager.getInstance().getLocationProvider(2).getStatus();
            }
            catch (ModuleException moduleException) {
                moduleException.printStackTrace();
            }
            catch (LocationException locationException) {
                locationException.printStackTrace();
            }
            if (list.size() == 0) {
                TerminalIF.this.println("status = " + String.valueOf(n));
                return true;
            }
            n = Integer.valueOf(list.get(0));
            try {
                LocationProviderImpl locationProviderImpl = (LocationProviderImpl)ModuleManager.getInstance().getLocationProvider(2);
                switch (n) {
                    case 0: 
                    case 1: 
                    case 4: {
                        locationProviderImpl.setStatus(n);
                        break;
                    }
                    default: {
                        TerminalIF.this.println("\u6e2c\u4f4d\u72b6\u614b\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002");
                        this.Usage();
                        break;
                    }
                }
            }
            catch (ModuleException moduleException) {
                moduleException.printStackTrace();
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "GPS\u306e\u6e2c\u4f4d\u72b6\u614b\u3092\u8868\u793a\uff0f\u8a2d\u5b9a\u3057\u307e\u3059\u3002\r\n\tlocationstatus <status>\r\n\t0:STATUS_IDLE\r\n\t1:STATUS_MESURMENT\r\n\t4:STATUS_EMERGENCY\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandProvideLocation
    implements TerminalCommand {
        private CommandProvideLocation() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            int n = 4;
            try {
                LocationProviderImpl locationProviderImpl = (LocationProviderImpl)ModuleManager.getInstance().getLocationProvider(2);
                if (locationProviderImpl.ProvideLocation(n) == null) {
                    TerminalIF.this.println("\u4f4d\u7f6e\u63d0\u4f9b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
            catch (ModuleException moduleException) {
                moduleException.printStackTrace();
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u4f4d\u7f6e\u63d0\u4f9b\u3092\u884c\u3044\u307e\u3059\u3002\r\n\tprovidelocation\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandLocation
    implements TerminalCommand {
        private CommandLocation() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() != 6) {
                Location location = LocationProperties.getInstance().getLocation();
                Degree degree = location.getLatitude();
                Degree degree2 = location.getLongitude();
                TerminalIF.this.println("\u7def\u5ea6: " + String.valueOf(degree.getDegreePart()) + ", " + String.valueOf(degree.getMinutePart()) + ", " + String.valueOf(degree.getCentisecondPart()));
                TerminalIF.this.println("\u7d4c\u5ea6: " + String.valueOf(degree2.getDegreePart()) + ", " + String.valueOf(degree2.getMinutePart()) + ", " + String.valueOf(degree2.getCentisecondPart()));
                return true;
            }
            Degree degree = new Degree(Integer.valueOf(list.get(0)), Integer.valueOf(list.get(1)), Integer.valueOf(list.get(2)));
            Degree degree3 = new Degree(Integer.valueOf(list.get(3)), Integer.valueOf(list.get(4)), Integer.valueOf(list.get(5)));
            Location location = new Location(degree, degree3);
            LocationProperties.getInstance().setLocation(location);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u73fe\u5728\u4f4d\u7f6e\u306e\u8868\u793a\uff0f\u8a2d\u5b9a\u3092\u884c\u3044\u307e\u3059\u3002\r\n\tlocation <latitude> <longitude>\r\n\t<latitude>:  \u7def\u5ea6\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\t<longitude>: \u7d4c\u5ea6\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSPIStop
    implements TerminalCommand {
        private CommandSPIStop() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            SPIFunctions.stop();
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "SPI\u901a\u4fe1\u3092\u505c\u6b62\u3057\u307e\u3059\u3002\r\n\tSPIStart\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSPIStart
    implements TerminalCommand {
        private CommandSPIStart() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            SPIFunctions.start();
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "SPI\u901a\u4fe1\u3092\u958b\u59cb\u3057\u307e\u3059\u3002\r\n\tSPIStart\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandGPIO
    implements TerminalCommand {
        private CommandGPIO() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            GPIOConnection gPIOConnection;
            try {
                gPIOConnection = (GPIOConnection)ModuleManager.getInstance().getConnectionManager().getConnection(1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (ModuleException moduleException) {
                return false;
            }
            List<Integer> list2 = gPIOConnection.getAvailableInPort();
            List<Integer> list3 = gPIOConnection.getAvailableOutPort();
            if (list.size() == 0) {
                int n;
                if (list2.size() > 0) {
                    TerminalIF.this.print("GPIO Inport : " + String.valueOf(list2.get(0)));
                    for (n = 1; n < list2.size(); ++n) {
                        TerminalIF.this.print(", " + String.valueOf(list2.get(n)));
                    }
                }
                if (list3.size() > 0) {
                    TerminalIF.this.print("\r\nGPIO Outport : " + String.valueOf(list3.get(0)));
                    for (n = 1; n < list3.size(); ++n) {
                        TerminalIF.this.print(", " + String.valueOf(list3.get(n)));
                    }
                    TerminalIF.this.println("");
                }
                return true;
            }
            int n = Integer.valueOf(list.get(0));
            if (list.size() == 1) {
                try {
                    if (list2.contains(n)) {
                        boolean bl = gPIOConnection.receiveControlSignal(n);
                        TerminalIF.this.println("GPIO Inport[" + String.valueOf(n) + "] = " + String.valueOf(bl));
                    } else if (list3.contains(n)) {
                        boolean bl = gPIOConnection.getControlSignal(n);
                        TerminalIF.this.println("GPIO Outport[" + String.valueOf(n) + "] = " + String.valueOf(bl));
                    }
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(1));
            if (list2.contains(n)) {
                GPIOFunctions.setReceiveControlSignal(n, bl);
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "GPIO\u306e\u30dd\u30fc\u30c8\u5024\u306e\u30bb\u30c3\u30c8\u3092\u884c\u3044\u307e\u3059\u3002\r\n\tGPIO <port> <signal>\r\n\t<port>\uff1a\u30dd\u30fc\u30c8\u756a\u53f7\r\n\t<signal>\uff1aTRUE/FALSE\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandAD
    implements TerminalCommand {
        private CommandAD() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            ADConverter aDConverter;
            try {
                aDConverter = (ADConverter)ModuleManager.getInstance().getConnectionManager().getConnection(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (ModuleException moduleException) {
                return false;
            }
            List<ADChannel> list2 = aDConverter.getADChannelList();
            if (list.size() == 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    ADChannel aDChannel = list2.get(i);
                    TerminalIF.this.println(String.valueOf(i) + ":" + aDChannel.getChannelName() + ":" + String.valueOf(aDChannel.getResolution()));
                }
                return true;
            }
            int n = Integer.valueOf(list.get(0));
            if (list.size() == 1) {
                try {
                    ADChannel aDChannel = list2.get(n);
                    TerminalIF.this.println(String.valueOf(n) + ":" + aDChannel.getChannelName() + ":" + String.valueOf(aDChannel.getResolution() + ":" + String.valueOf(aDConverter.getAD(aDChannel))));
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                return true;
            }
            int n2 = Integer.valueOf(list.get(1));
            ADConverterFunctions.setAD(n, n2);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "AD\u5024\u306e\u30bb\u30c3\u30c8\u3092\u884c\u3044\u307e\u3059\u3002\r\n\tAD <ch> <value>\r\n\t<ch>\uff1a\u30c1\u30e3\u30cd\u30eb\u756a\u53f7\r\n\t<value>\uff1aAD\u5024\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandI2CSend
    implements TerminalCommand {
        private CommandI2CSend() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            I2CConnection i2CConnection;
            try {
                i2CConnection = (I2CConnection)ModuleManager.getInstance().getConnectionManager().getConnection(2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (ModuleException moduleException) {
                return false;
            }
            List<I2CSpec> list2 = i2CConnection.getI2CSpec();
            I2CSlave i2CSlave = null;
            try {
                i2CSlave = i2CConnection.getI2CSlave(list2.get(0), 0);
            }
            catch (IllegalStateException illegalStateException) {
                TerminalIF.this.println("I2C\u30c7\u30d0\u30a4\u30b9\u306f\u30de\u30b9\u30bf\u3068\u3057\u3066\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                return true;
            }
            catch (ConnectionException connectionException) {
                return true;
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "I2C\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u3078\u306e\u9001\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\tI2CSend\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSMSSend
    implements TerminalCommand {
        private CommandSMSSend() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            try {
                ShortMessageFunctions.receiveSMS(list.get(0));
            }
            catch (DeviceException deviceException) {
                TerminalIF.this.println("DeviceException");
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "SMS\u306e\u9001\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\tsmssend <filename>\r\n\tfilename: \u30d5\u30a1\u30a4\u30eb\u540d\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandGuidance
    implements TerminalCommand {
        private CommandGuidance() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            String string = list.get(0);
            if (!TerminalIF.this.sessionMap.containsKey(string)) {
                TerminalIF.this.println("\u30bb\u30c3\u30b7\u30e7\u30f3(" + string + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                return true;
            }
            VoiceSession voiceSession = (VoiceSession)TerminalIF.this.sessionMap.get(string);
            TerminalIF.this.voiceController.guidance(voiceSession);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u97f3\u58f0\u30ac\u30a4\u30c0\u30f3\u30b9\u306e\u9001\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\tguidance <session>\r\n\tguidance: \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandUSSDSend
    implements TerminalCommand {
        private CommandUSSDSend() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            String string = list.get(0);
            if (!USSDFunctions.received(string)) {
                // empty if block
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "USSD\u306e\u9001\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\tussdsend <message>\r\n\tmessage: \u30e1\u30c3\u30bb\u30fc\u30b8\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandDisconnect
    implements TerminalCommand {
        private CommandDisconnect() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            String string = list.get(0);
            if (!TerminalIF.this.sessionMap.containsKey(string)) {
                TerminalIF.this.println("\u30bb\u30c3\u30b7\u30e7\u30f3(" + string + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                return true;
            }
            Session session = TerminalIF.this.sessionMap.get(string);
            if (NetProperties.isTelephonNumber(string)) {
                try {
                    VoiceControllerImpl voiceControllerImpl = (VoiceControllerImpl)ModuleManager.getInstance().getVoiceController();
                    voiceControllerImpl.disconnect((VoiceSession)session);
                }
                catch (ModuleException moduleException) {
                    moduleException.printStackTrace();
                }
                catch (SessionException sessionException) {
                    sessionException.printStackTrace();
                }
            } else {
                try {
                    PacketControllerImpl packetControllerImpl = (PacketControllerImpl)ModuleManager.getInstance().getPacketController();
                    packetControllerImpl.disconnect(session);
                }
                catch (ModuleException moduleException) {
                    boolean bl = false;
                    return bl;
                }
                catch (SessionException sessionException) {
                    boolean bl = false;
                    return bl;
                }
                catch (CommunicationFailureException communicationFailureException) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    TerminalIF.this.sessionMap.remove(string);
                }
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u5207\u65ad\u3092\u884c\u3044\u307e\u3059\r\n\tdisconnect <session>\r\n\tsession: \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSend
    implements TerminalCommand {
        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            String string = list.get(0);
            if (NetProperties.isTelephonNumber(string)) {
                TerminalIF.this.println("\u97f3\u58f0\u30bb\u30c3\u30b7\u30e7\u30f3\uff1a" + string);
                try {
                    Session session;
                    VoiceControllerImpl voiceControllerImpl = (VoiceControllerImpl)ModuleManager.getInstance().getVoiceController();
                    if (TerminalIF.this.sessionMap.containsKey(string)) {
                        session = TerminalIF.this.sessionMap.get(string);
                    } else {
                        session = voiceControllerImpl.createSession(string);
                        TerminalIF.this.sessionMap.put(string, session);
                    }
                    if (!voiceControllerImpl.incomingCall(session)) {
                        TerminalIF.this.println("\u7740\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002");
                        TerminalIF.this.sessionMap.remove(string);
                    }
                }
                catch (SessionException sessionException) {
                    TerminalIF.this.println("\u7740\u4fe1\u3092\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
                }
                catch (IllegalStateException illegalStateException) {
                    TerminalIF.this.println("IllegalStateException");
                    illegalStateException.printStackTrace();
                }
                catch (ModuleException moduleException) {
                    moduleException.printStackTrace();
                }
            } else {
                PacketControllerImpl packetControllerImpl;
                TerminalIF.this.println("\u30d1\u30b1\u30c3\u30c8\u30bb\u30c3\u30b7\u30e7\u30f3\uff1a" + string);
                try {
                    packetControllerImpl = (PacketControllerImpl)ModuleManager.getInstance().getPacketController();
                }
                catch (ModuleException moduleException) {
                    return false;
                }
                try {
                    Session session = packetControllerImpl.createSession(string);
                    TerminalIF.this.sessionMap.put(string, session);
                    if (!packetControllerImpl.incomingCall(session)) {
                        TerminalIF.this.println("\u7740\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002");
                        TerminalIF.this.sessionMap.remove(string);
                    }
                }
                catch (SessionException sessionException) {
                    TerminalIF.this.println("\u7740\u4fe1\u3092\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
                }
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u767a\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\tsend <session>\r\n\tsession: \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandReceive
    implements TerminalCommand {
        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            String string = list.get(0);
            if (!TerminalIF.this.sessionMap.containsKey(string)) {
                TerminalIF.this.println("\u30bb\u30c3\u30b7\u30e7\u30f3(" + string + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                return true;
            }
            Session session = TerminalIF.this.sessionMap.get(string);
            String string2 = session.getDestination();
            if (NetProperties.isTelephonNumber(string2)) {
                try {
                    VoiceControllerImpl voiceControllerImpl = (VoiceControllerImpl)ModuleManager.getInstance().getVoiceController();
                    voiceControllerImpl.receive((VoiceSession)session);
                }
                catch (ModuleException moduleException) {
                    moduleException.printStackTrace();
                }
            } else {
                try {
                    PacketControllerImpl packetControllerImpl = (PacketControllerImpl)ModuleManager.getInstance().getPacketController();
                    packetControllerImpl.receive(session);
                }
                catch (SessionException sessionException) {
                    sessionException.printStackTrace();
                    return false;
                }
                catch (CommunicationFailureException communicationFailureException) {
                    communicationFailureException.printStackTrace();
                    return false;
                }
                catch (IllegalSettingException illegalSettingException) {
                    illegalSettingException.printStackTrace();
                    return false;
                }
                catch (ModuleException moduleException) {
                    moduleException.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u7740\u4fe1\u3092\u884c\u3044\u307e\u3059\r\n\treceive <session>\r\n\tsession: \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandLoadableModuleException
    implements TerminalCommand {
        private CommandLoadableModuleException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            IOProperties.getInstance().setLoadableModuleExcepiton(bl, 0);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "LoadableModuleException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tLoadableModuleException <bool>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001LoadableModuleException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandLocationException
    implements TerminalCommand {
        private CommandLocationException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                LocationProperties.getInstance().setLocationException(bl, 0, null);
                return true;
            }
            int n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                LocationProperties.getInstance().setLocationException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            LocationProperties.getInstance().setLocationException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "LocationException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tlocationexception <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001LocationException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandShortMessageException
    implements TerminalCommand {
        private CommandShortMessageException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                NetProperties.getInstance().setShortMessageException(bl, 0, null);
                return true;
            }
            int n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                NetProperties.getInstance().setShortMessageException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            NetProperties.getInstance().setShortMessageException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "ShortMessageException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tshortmessageexception <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001SessionException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandMailException
    implements TerminalCommand {
        private CommandMailException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                NetProperties.getInstance().setMailException(bl, 0, null);
                return true;
            }
            int n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                NetProperties.getInstance().setMailException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            NetProperties.getInstance().setMailException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "MailException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tmailexception <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001MailException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSessionException
    implements TerminalCommand {
        private CommandSessionException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                NetProperties.getInstance().setSessionException(bl, 0, null);
                return true;
            }
            int n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                NetProperties.getInstance().setSessionException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            NetProperties.getInstance().setSessionException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "SessionException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tsessionexception <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001SessionException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandConnectionException
    implements TerminalCommand {
        private CommandConnectionException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setTimerExcepiton(bl, null);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ConnectionProperties.getInstance().setConnectionException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "ConnectionException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tConnectionException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001ConnectionException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandTimerException
    implements TerminalCommand {
        private CommandTimerException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setTimerExcepiton(bl, null);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setTimerExcepiton(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "TimerException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tTimerException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001TimerException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandIllegalCertificateException
    implements TerminalCommand {
        private CommandIllegalCertificateException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                SSLProperties.getInstance().setIllegalCertificateException(bl, null);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            SSLProperties.getInstance().setIllegalCertificateException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "IllegalCertificateException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tIllegalCertificateException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001IllegalCertificateException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSecureHandshakeException
    implements TerminalCommand {
        private CommandSecureHandshakeException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            int n = 0;
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                SSLProperties.getInstance().setSecureHandshakeException(bl, n, null);
                return true;
            }
            n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                SSLProperties.getInstance().setSecureHandshakeException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            SSLProperties.getInstance().setSecureHandshakeException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "SecureHandshakeException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tSecureHandshakeException <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001SecureHandshakeException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandUSSDServiceException
    implements TerminalCommand {
        private CommandUSSDServiceException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                NetProperties.getInstance().setUSSDServiceException(bl, null);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            NetProperties.getInstance().setUSSDServiceException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "USSDServiceException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tUSSDServiceException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001USSDServiceException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandRegulationException
    implements TerminalCommand {
        private CommandRegulationException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setRegulationException(bl);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setRegulationException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "RegulationException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tRegulationException <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001RegulationException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandIllegalSettingException
    implements TerminalCommand {
        private CommandIllegalSettingException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setIllegalSettingException(bl);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setIllegalSettingException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "IllegalSettingException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tIllegalSettingException <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001IllegalSettingException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandExternalStatusException
    implements TerminalCommand {
        private CommandExternalStatusException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            int n = 0;
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setExternalStatusException(bl);
                return true;
            }
            n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                ModuleProperties.getInstance().setExternalStatusException(bl, n, null);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setExternalStatusException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "ExternalStatusException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tCommunicationExternalStatusException <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001ExternalStatusException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandIOException
    implements TerminalCommand {
        private CommandIOException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ConnectionProperties.getInstance().setIOExcepton(bl, null);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ConnectionProperties.getInstance().setIOExcepton(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "IOException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tIOException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001DeviceException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandDeviceException
    implements TerminalCommand {
        private CommandDeviceException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setDeviceException(bl);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setDeviceException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "DeviceException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tDeviceException <bool> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001DeviceException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandCommunicationFailureException
    implements TerminalCommand {
        private CommandCommunicationFailureException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setCommunicationFailureException(bl);
                return true;
            }
            int n = Integer.valueOf(list.get(1));
            if (list.size() == 2) {
                ModuleProperties.getInstance().setCommunicationFailureException(bl, n);
                return true;
            }
            String string = list.get(2);
            for (int i = 3; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setCommunicationFailureException(bl, n, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "CommunicationFailureException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tCommunicationFailureException <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001ModuleException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandModuleException
    implements TerminalCommand {
        private CommandModuleException() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            if (list.size() == 1) {
                ModuleProperties.getInstance().setModuleException(bl);
                return true;
            }
            String string = list.get(1);
            for (int i = 2; i < list.size(); ++i) {
                string = string + " ";
                string = string + list.get(i);
            }
            ModuleProperties.getInstance().setModuleException(bl, string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "ModuleException\u306e\u767a\u751f\u306e\u6709\u7121\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\tmoduleexception <bool> <status> <message>\r\n\tbool\uff1aTRUE\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u3001ModuleException\u304c\u767a\u751f\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandUIM
    implements TerminalCommand {
        private CommandUIM() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                TerminalIF.this.println("UIM = " + String.valueOf(ModuleProperties.getInstance().getUIM()));
                return true;
            }
            boolean bl = Boolean.valueOf(list.get(0));
            ModuleProperties.getInstance().setUIM(bl);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "UIM\u306e\u633f\u5165\u72b6\u614b\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\r\n\tUIM <enable>\r\n\tenable\uff1aUIM\u306e\u633f\u5165\u72b6\u614b\u3092TRUE/FALSE\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002TRUE: \u633f\u5165\u72b6\u614b\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandReceivedPower
    implements TerminalCommand {
        private CommandReceivedPower() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            int n = Integer.valueOf(list.get(0));
            if (n < 0 || n > 75) {
                this.Usage();
                return true;
            }
            int n2 = ModuleProperties.getInstance().getRecievedPower();
            ModuleProperties.getInstance().setRecievedPower(n);
            String string = String.valueOf(n2) + "\u2192" + String.valueOf(n);
            TerminalIF.this.println(string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u53d7\u4fe1\u96fb\u529b\u6307\u6a19\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\r\n\treceivedpower <power>\r\n\tpower\uff1a\u53d7\u4fe1\u96fb\u529b\u6307\u6a19\u30920\uff5e75\u306e\u5024\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandRegulation
    implements TerminalCommand {
        private CommandRegulation() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            int n = Integer.valueOf(list.get(0));
            if (n < 0 || n > 3) {
                this.Usage();
                return true;
            }
            int n2 = ModuleProperties.getInstance().getRegulation();
            ModuleProperties.getInstance().setRegulation(n);
            String string = String.valueOf(n2) + "\u2192" + String.valueOf(n);
            TerminalIF.this.println(string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u898f\u5236\u72b6\u614b\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\r\n\treguration <reg>\r\n\treg\uff1a\u4ee5\u4e0b\u306e\u5024\u306eOR\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n\t0\uff1aNONE\r\n\t1\uff1aVOICE\r\n\t2\uff1aPACKET\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandAreaInfo
    implements TerminalCommand {
        String[] area = new String[4];
        int[] mask;

        public CommandAreaInfo() {
            this.area[0] = "OUTSIDE";
            this.area[1] = "HSUPA";
            this.area[2] = "HSDPA";
            this.area[3] = "FOMA";
            this.mask = new int[4];
            this.mask[0] = 0;
            this.mask[1] = 1;
            this.mask[2] = 2;
            this.mask[3] = 4;
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            int n = -1;
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            n = Integer.valueOf(list.get(0));
            if (n < 0 || n > 7) {
                this.Usage();
                return true;
            }
            int n2 = ModuleProperties.getInstance().getAreaInfo();
            ModuleProperties.getInstance().setAreaInfo(n);
            String string = String.valueOf(n2) + "\u2192" + String.valueOf(n);
            TerminalIF.this.println(string);
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30a8\u30ea\u30a2\u72b6\u614b\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\r\n\tareainfo <area>\r\n\tarea\uff1a\u4ee5\u4e0b\u306e\u5024\u306eOR\u3092\u6307\u5b9a\u3057\u30010\u306f\u570f\u5916\u3092\u8868\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
            for (int i = 0; i < this.area.length; ++i) {
                TerminalIF.this.println("\t" + String.valueOf(this.mask[i]) + "\uff1a" + this.area[i]);
            }
        }
    }

    private class CommandSignalStatus
    implements TerminalCommand {
        private CommandSignalStatus() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() > 0) {
                int n = -1;
                try {
                    n = Integer.valueOf(list.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    this.Usage();
                }
                if (n >= 0 && n <= 3) {
                    int n2 = ModuleProperties.getInstance().getSignalStatus();
                    ModuleProperties.getInstance().setSignalStatus(n);
                    String string = String.valueOf(n2) + "\u2192" + String.valueOf(n);
                    TerminalIF.this.println(string);
                } else {
                    this.Usage();
                }
            } else {
                this.Usage();
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30a2\u30f3\u30c6\u30ca\u72b6\u614b\u3092\u5909\u66f4\u3057\u307e\u3059\u3002\r\n\tsignalstatus <status>\r\n\tstatus\uff1a0,1,2,3\u3092\u6307\u5b9a\u3057\u30010\u306f\u570f\u5916\u3092\u8868\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandUpdateSystemStatus
    implements TerminalCommand {
        String[] strStatus = new String[5];

        CommandUpdateSystemStatus() {
            this.strStatus[0] = "IDLE";
            this.strStatus[1] = "DOWNLOADING";
            this.strStatus[2] = "DOWNLOAD_COMPLETE";
            this.strStatus[3] = "REWRITING";
            this.strStatus[4] = "SENDING_COMPINFO";
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.isEmpty()) {
                int n;
                try {
                    n = TerminalIF.this.moduleMan.getSystemUpdateStatus();
                }
                catch (ModuleException moduleException) {
                    return false;
                }
                TerminalIF.this.println(this.strStatus[n]);
            } else {
                String string = list.get(0);
                for (int i = 0; i < this.strStatus.length; ++i) {
                    string.toUpperCase();
                    if (!string.equals(this.strStatus[i]) && !string.equals(String.valueOf(i))) continue;
                    int n = ModuleProperties.getInstance().getSystemUpdateStatus();
                    ModuleProperties.getInstance().setSystemUpdateStatus(i);
                    String string2 = this.strStatus[n] + "\u2192" + this.strStatus[i] + "\r\n";
                    TerminalIF.this.println(string2);
                    return true;
                }
                String string3 = "\u30d1\u30e9\u30e1\u30fc\u30bf(" + string + ")\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002";
                TerminalIF.this.println(string3);
            }
            return true;
        }

        @Override
        public void Usage() throws IOException {
            String string = "\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u5b9f\u884c\u72b6\u614b\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002\r\nupdatestatus <status>\r\n\tstatus : \u5b9f\u884c\u72b6\u614b\r\n\t\u5b9f\u884c\u72b6\u614b\u306f\u3001\u4ee5\u4e0b\u306e\u6570\u5024\u307e\u305f\u306f\u6587\u5b57\u5217\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002\r\n";
            TerminalIF.this.print(string);
            for (int i = 0; i < this.strStatus.length; ++i) {
                string = String.valueOf(i) + " : " + this.strStatus[i];
                TerminalIF.this.println(string);
            }
        }
    }

    private class CommandCancelSystemUpdate
    implements TerminalCommand {
        private CommandCancelSystemUpdate() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                boolean bl = ModuleProperties.getInstance().getCancelSystemUpdate();
                TerminalIF.this.println(String.valueOf(bl));
                return true;
            }
            ModuleProperties.getInstance().setCancelSystemUpdate(Boolean.valueOf(list.get(0)));
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u30ad\u30e3\u30f3\u30bb\u30eb\u306e\u53ef\u5426\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\r\ncancelsystemupdate <bool>\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSystemUpdateAbort
    implements TerminalCommand {
        private CommandSystemUpdateAbort() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.size() == 0) {
                this.Usage();
                return true;
            }
            int n = Integer.valueOf(list.get(0));
            switch (n) {
                case 0: 
                case 1: {
                    ModuleFunctions.requestSystemUpdateAbort(n);
                    break;
                }
                default: {
                    TerminalIF.this.println("\u4e2d\u65ad\u7406\u7531\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002");
                    this.Usage();
                }
            }
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u4e2d\u65ad\u3092\u8981\u6c42\u3057\u307e\u3059\u3002\r\nsystemupdateabort <status>\r\n\tstatus:\u4e2d\u65ad\u7406\u7531\r\n\t0:STATUS_NO_UPDATE\r\n\t1:STATUS_DOWNLOAD_FAILURE\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandSystemUpdate
    implements TerminalCommand {
        private CommandSystemUpdate() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            ModuleFunctions.requestSystemUpdate();
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u5b9f\u884c\u3092\u8981\u6c42\u3057\u307e\u3059\u3002\r\nsystemupdate\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandReset
    implements TerminalCommand {
        private CommandReset() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            ModuleFunctions.requestReset();
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
            String string = "\u30b7\u30b9\u30c6\u30e0\u306e\u30ea\u30bb\u30c3\u30c8\u3092\u8981\u6c42\u3057\u307e\u3059\u3002\r\nreset\r\n";
            TerminalIF.this.print(string);
        }
    }

    private class CommandLocalVersion
    implements TerminalCommand {
        private CommandLocalVersion() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            TerminalIF.this.print(Version.getLocalVersion() + "\r\n");
            return true;
        }

        @Override
        @Override
        public void Usage() throws IOException {
        }
    }

    private class CommandHelp
    implements TerminalCommand {
        private CommandHelp() {
        }

        @Override
        @Override
        public boolean CommandProc(List<String> list) throws IOException {
            if (list.isEmpty()) {
                this.Usage();
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i);
                    if (!TerminalIF.this.commandMap.containsKey(string = string.toUpperCase())) continue;
                    TerminalCommand terminalCommand = TerminalIF.this.commandMap.get(string);
                    terminalCommand.Usage();
                }
            }
            return true;
        }

        @Override
        public void Usage() throws IOException {
            String string = "help\r\n? <commands>\r\n";
            TerminalIF.this.print(string);
            for (int i = 0; i < TerminalIF.this.commandList.size(); ++i) {
                TerminalIF.this.println(TerminalIF.this.commandList.get(i));
            }
        }
    }

    private class TerminalMessageListener
    implements SerialListener {
        private String line;
        private byte[] lineBuffer = new byte[256];
        private byte[] escapeBuffer = new byte[2];
        private static final int BUFFERSIZE = 256;
        private int curPos = 0;
        private ArrayList<String> history = new ArrayList();
        private static final int MAX_HISTORY = 256;

        TerminalMessageListener() {
        }

        public synchronized String read() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            return this.line;
        }

        public synchronized void write(String string) {
            this.line = string;
            this.notifyAll();
        }

        @Override
        @Override
        public void onReceived(Serial serial) {
            InputStream inputStream = serial.getInputStream();
            OutputStream outputStream = serial.getOutputStream();
            try {
                int n;
                block13: while ((n = inputStream.read()) > 0) {
                    switch (n) {
                        case 27: {
                            inputStream.read(this.escapeBuffer);
                            if (this.escapeBuffer[0] != 91) continue block13;
                            switch (this.escapeBuffer[1]) {
                                case 65: {
                                    break;
                                }
                                case 66: {
                                    break;
                                }
                                case 67: {
                                    break;
                                }
                            }
                            continue block13;
                        }
                        case 8: {
                            if (this.curPos <= 0) continue block13;
                            --this.curPos;
                            outputStream.write(8);
                            outputStream.write(32);
                            outputStream.write(8);
                            continue block13;
                        }
                        case 9: {
                            continue block13;
                        }
                        case 13: {
                            if (this.curPos <= 0) continue block13;
                            String string = new String(this.lineBuffer, 0, this.curPos);
                            this.write(string);
                            this.history.add(0, string);
                            if (this.history.size() > 256) {
                                this.history.remove(this.history.size() - 1);
                            }
                            outputStream.write(13);
                            outputStream.write(10);
                            this.curPos = 0;
                            continue block13;
                        }
                    }
                    if (n < 32 || n > 127 || this.curPos >= 256) continue;
                    this.lineBuffer[this.curPos++] = (byte)n;
                    outputStream.write(n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        @Override
        public void onChangedERStatus(Serial serial, boolean bl) {
        }
    }
}

