/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketImpl;
import jp.co.aplix.net.DefaultSocketInputStream;
import jp.co.aplix.net.DefaultSocketOutputStream;
import jp.co.aplix.net.ZNativeSock;

public class DefaultSocketImpl
extends SocketImpl {
    protected int handle = 0;
    private final Object iLockObj = new Object();
    protected boolean isConnected;
    protected boolean isClosed;
    protected InputStream is;
    protected OutputStream os;
    protected boolean isInputShutdown;
    protected boolean isOutputShutdown;
    private static final int SD_RECEIVE = 0;
    private static final int SD_SEND = 1;

    @Override
    protected void create(boolean bl) throws IOException {
        this.handle = ZNativeSock.nativeCreateTcp();
        if (this.handle == -1) {
            throw new IOException();
        }
    }

    @Override
    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        int n2 = ZNativeSock.publishSerial();
        int n3 = ZNativeSock.nativeConnect(this.handle, inetAddress.getAddress(), n, n2);
        if (n3 != 0) {
            throw new IOException();
        }
        n3 = ZNativeSock.getResult(n2);
        if (n3 != 0) {
            throw new IOException();
        }
        this.isConnected = true;
    }

    @Override
    @Override
    protected void bind(InetAddress inetAddress, int n) throws IOException {
        int n2 = ZNativeSock.nativeBind(this.handle, inetAddress.getAddress(), n);
        if (n2 != 0) {
            throw new IOException();
        }
    }

    @Override
    @Override
    protected void listen(int n) throws IOException {
        int n2 = ZNativeSock.nativeListen(this.handle, n);
        if (n2 != 0) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void accept(SocketImpl socketImpl) throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("closed");
            }
        }
        this.accept((DefaultSocketImpl)socketImpl);
    }

    private void accept(DefaultSocketImpl defaultSocketImpl) throws IOException {
        int n = ZNativeSock.publishSerial();
        int n2 = ZNativeSock.nativeAccept(this.handle, n);
        if (n2 != 0) {
            throw new IOException();
        }
        n2 = ZNativeSock.getResult(n);
        if (n2 == -1) {
            throw new IOException();
        }
        defaultSocketImpl.handle = n2;
        defaultSocketImpl.isConnected = true;
        int n3 = ZNativeSock.nativeGetClientAddress(defaultSocketImpl.handle);
        defaultSocketImpl.address = InetAddress.getByName((n3 >> 24 & 0xFF) + "." + (n3 >> 16 & 0xFF) + "." + (n3 >> 8 & 0xFF) + "." + (n3 >> 0 & 0xFF));
        defaultSocketImpl.port = ZNativeSock.nativeGetClientPort(defaultSocketImpl.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void close() throws IOException {
        try {
            this.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        int n = ZNativeSock.publishSerial();
        int n2 = ZNativeSock.nativeClose(this.handle, n);
        if (n2 != 0) {
            throw new IOException();
        }
        n2 = ZNativeSock.getResult(n);
        if (n2 != 0) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed || this.isOutputShutdown) {
                throw new IOException();
            }
        }
        int n3 = ZNativeSock.publishSerial();
        if (ZNativeSock.nativeSend(this.handle, byArray, n, n2, n3) != 0) {
            throw new IOException();
        }
        if (ZNativeSock.getResult(n3) != 0) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int recv(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed || this.isInputShutdown) {
                throw new IOException();
            }
        }
        int n3 = ZNativeSock.publishSerial();
        if (ZNativeSock.nativeRecv(this.handle, byArray, n, n2, n3) != 0) {
            throw new IOException();
        }
        int n4 = ZNativeSock.getResult(n3);
        if (n4 == -1) {
            throw new IOException();
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected InputStream getInputStream() throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (!this.isConnected || this.isClosed) {
                throw new IOException();
            }
            if (this.is == null) {
                this.is = new DefaultSocketInputStream(this);
            }
        }
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected OutputStream getOutputStream() throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (!this.isConnected || this.isClosed) {
                throw new IOException();
            }
            if (this.os == null) {
                this.os = new DefaultSocketOutputStream(this);
            }
        }
        return this.os;
    }

    @Override
    @Override
    protected int available() throws IOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void shutdownInput() throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isInputShutdown) {
                return;
            }
            this.isInputShutdown = true;
        }
        int n = ZNativeSock.publishSerial();
        int n2 = ZNativeSock.nativeShutdown(this.handle, 0, n);
        if (n2 != 0) {
            throw new IOException();
        }
        n2 = ZNativeSock.getResult(n);
        if (n2 != 0) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void shutdownOutput() throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isOutputShutdown) {
                return;
            }
            this.isOutputShutdown = true;
        }
        int n = ZNativeSock.publishSerial();
        int n2 = ZNativeSock.nativeShutdown(this.handle, 1, n);
        if (n2 != 0) {
            throw new IOException();
        }
        n2 = ZNativeSock.getResult(n);
        if (n2 != 0) {
            throw new IOException();
        }
    }

    protected boolean isInputShutdown() {
        return this.isInputShutdown;
    }

    protected boolean isOutputShutdown() {
        return this.isOutputShutdown;
    }
}

