/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import jp.co.aplix.net.ZNativeSock;

public class DefaultDatagramSocketImpl
extends DatagramSocketImpl {
    protected int handle = 0;
    private final Object iLockObj = new Object();
    protected boolean isConnected;
    protected boolean isClosed;

    @Override
    @Override
    protected void create() throws IOException {
        this.handle = ZNativeSock.nativeCreateUdp();
        if (this.handle == -1) {
            throw new IOException();
        }
    }

    @Override
    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        int n2 = ZNativeSock.publishSerial();
        int n3 = ZNativeSock.nativeConnect(this.handle, inetAddress.getAddress(), n, n2);
        if (n3 != 0) {
            throw new IOException();
        }
        n3 = ZNativeSock.getResult(n2);
        if (n3 != 0) {
            throw new IOException();
        }
        this.isConnected = true;
    }

    @Override
    @Override
    protected void bind(int n, InetAddress inetAddress) throws IOException {
        int n2 = ZNativeSock.nativeBind(this.handle, inetAddress.getAddress(), n);
        if (n2 != 0) {
            throw new IOException();
        }
        this.isConnected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void close() {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        int n = ZNativeSock.publishSerial();
        int n2 = ZNativeSock.nativeClose(this.handle, n);
        if (n2 != 0) {
            throw new RuntimeException();
        }
        n2 = ZNativeSock.getResult(n);
        if (n2 != 0) {
            throw new RuntimeException();
        }
    }

    @Override
    @Override
    protected void disconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void receive(DatagramPacket datagramPacket) throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException();
            }
        }
        object = new byte[4];
        int[] nArray = new int[1];
        int n = ZNativeSock.publishSerial();
        if (ZNativeSock.nativeRecvfrom(this.handle, datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), (byte[])object, nArray, n) != 0) {
            throw new IOException();
        }
        int n2 = ZNativeSock.getResult(n);
        if (n2 == -1) {
            throw new IOException();
        }
        datagramPacket.setLength(n2);
        datagramPacket.setPort(nArray[0]);
        datagramPacket.setAddress(InetAddress.getByAddress((byte[])object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected void send(DatagramPacket datagramPacket) throws IOException {
        Object object = this.iLockObj;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException();
            }
        }
        int n = ZNativeSock.publishSerial();
        if (ZNativeSock.nativeSendto(this.handle, datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), datagramPacket.getAddress().getAddress(), datagramPacket.getPort(), n) != 0) {
            throw new IOException();
        }
        if (ZNativeSock.getResult(n) != 0) {
            throw new IOException();
        }
    }
}

