/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.micro.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.aplix.io.ConnectionFactory;
import jp.co.aplix.io.ConnectionFactoryManager;
import jp.co.aplix.io.ResourceConnection;
import jp.co.aplix.micro.io.Connection;
import jp.co.aplix.micro.io.ConnectionNotFoundException;
import jp.co.aplix.micro.io.InputConnection;
import jp.co.aplix.micro.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int READ_WRITE = 3;
    public static final int WRITE = 2;

    private Connector() {
    }

    public static InputStream openInputStream(String string) throws IOException {
        InputConnection inputConnection = (InputConnection)Connector.open(string, 1, false);
        InputStream inputStream = inputConnection.openInputStream();
        inputConnection.close();
        return inputStream;
    }

    public static DataInputStream openDataInputStream(String string) throws IOException {
        InputConnection inputConnection = (InputConnection)Connector.open(string, 1, false);
        DataInputStream dataInputStream = inputConnection.openDataInputStream();
        inputConnection.close();
        return dataInputStream;
    }

    public static OutputStream openOutputStream(String string) throws IOException {
        try {
            OutputConnection outputConnection = (OutputConnection)Connector.open(string, 2, false);
            OutputStream outputStream = outputConnection.openOutputStream();
            outputConnection.close();
            return outputStream;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
    }

    public static DataOutputStream openDataOutputStream(String string) throws IOException {
        try {
            OutputConnection outputConnection = (OutputConnection)Connector.open(string, 2, false);
            DataOutputStream dataOutputStream = outputConnection.openDataOutputStream();
            outputConnection.close();
            return dataOutputStream;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
    }

    public static Connection open(String string) throws IOException {
        return Connector.open(string, 3);
    }

    public static Connection open(String string, int n) throws IOException {
        return Connector.open(string, n, false);
    }

    public static Connection open(String string, int n, boolean bl) throws IOException {
        Connection connection;
        ConnectionFactory connectionFactory = ConnectionFactoryManager.get();
        if (connectionFactory != null && (connection = connectionFactory.find(string, n, bl)) != null) {
            return connection;
        }
        if (string.startsWith("resource://")) {
            if (n != 1) {
                throw new IllegalArgumentException("resource is read only");
            }
            return new ResourceConnection(string);
        }
        throw new ConnectionNotFoundException(string);
    }
}

