/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.io;

import java.io.IOException;
import java.io.InputStream;
import jp.co.aplix.avm.RomizeInstance;

public final class ResourceInputStream
extends InputStream {
    private int index = 0;
    final byte[] b;

    ResourceInputStream(String string) throws IOException {
        this.b = RomizeInstance.getByteArray(string.substring(11));
        if (this.b == null) {
            throw new IOException("there is no resource:" + string);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.index < this.b.length) {
            return this.b[this.index++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.b.length - this.index;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.b.length - this.index;
        if (n3 == 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.b, this.index, byArray, n, n2);
        this.index += n2;
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        int n = this.b.length - this.index;
        if (l < (long)n) {
            n = (int)l;
        }
        this.index += n;
        return n;
    }
}

