/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.extra.util;

import jp.co.aplix.avm.Tick;
import jp.co.aplix.extra.util.TimerListener;

public class Timer {
    private static final int STATE_READY = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPED = 2;
    private static MasterThread masterThread = null;
    private static Object masterLock = new Object();
    private static Timer list = null;
    private int state = 0;
    private Timer next = null;
    private int ms;
    private boolean repeat;
    private TimerListener listener;
    private int curMs = 0;
    private int remain = 0;
    private TimerThread thread = null;

    public Timer(int n, boolean bl, TimerListener timerListener) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.ms = n;
        this.repeat = bl;
        this.listener = timerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = masterLock;
        synchronized (object) {
            int n;
            if (this.state == 1) {
                throw new IllegalStateException();
            }
            this.thread = new TimerThread(this);
            this.state = 1;
            this.thread.start();
            this.next = list;
            list = this;
            this.curMs = n = Tick.get();
            this.remain = this.ms;
            if (masterThread == null) {
                Timer.reschedule(n);
            } else {
                masterLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = masterLock;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 2;
                TimerThread timerThread = this.thread;
                this.thread = null;
                Object object2 = timerThread.lockObj;
                synchronized (object2) {
                    timerThread.requestExpire = false;
                    timerThread.requestQuit = true;
                    if (timerThread != Thread.currentThread()) {
                        timerThread.lockObj.notifyAll();
                    }
                }
                object2 = null;
                Timer timer = list;
                while (timer != null) {
                    if (timer == this) {
                        if (object2 == null) {
                            list = timer.next;
                            break;
                        }
                        ((Timer)object2).next = timer.next;
                        break;
                    }
                    object2 = timer;
                    timer = timer.next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reschedule(int n) {
        Object object = masterLock;
        synchronized (object) {
            boolean bl = false;
            int n2 = 0;
            Timer timer = null;
            Timer timer2 = list;
            while (timer2 != null) {
                int n3 = n - timer2.curMs;
                if (n3 < 0) {
                    n3 = 0;
                }
                timer2.curMs = n;
                timer2.remain -= n3;
                if (timer2.remain <= 0) {
                    TimerThread timerThread = timer2.thread;
                    Object object2 = timerThread.lockObj;
                    synchronized (object2) {
                        timerThread.requestExpire = true;
                        if (!timer2.repeat) {
                            timerThread.requestQuit = true;
                        }
                        timerThread.lockObj.notifyAll();
                    }
                    if (timer2.repeat) {
                        timer2.remain = timer2.ms + timer2.remain;
                        if (timer2.remain <= 0) {
                            timer2.remain = 1;
                        }
                    } else {
                        timer2.state = 0;
                        timer2.thread = null;
                        if (timer == null) {
                            list = timer2.next;
                        } else {
                            timer.next = timer2.next;
                        }
                        timer2 = timer2.next;
                        continue;
                    }
                }
                if (!bl) {
                    bl = true;
                    n2 = timer2.remain;
                } else if (timer2.remain < n2) {
                    n2 = timer2.remain;
                }
                timer = timer2;
                timer2 = timer2.next;
            }
            if (bl) {
                if (masterThread == null) {
                    masterThread = new MasterThread();
                    Timer.masterThread.nextMs = n2;
                    masterThread.start();
                } else {
                    Timer.masterThread.nextMs = n2;
                }
            } else if (masterThread != null) {
                Timer.masterThread.nextMs = 0;
                masterThread = null;
            }
        }
    }

    private static class TimerThread
    extends Thread {
        private Timer timer;
        boolean requestQuit = false;
        boolean requestExpire = false;
        Object lockObj = new Object();

        TimerThread(Timer timer) {
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TimerListener timerListener = null;
                Object object = this.lockObj;
                synchronized (object) {
                    if (this.requestQuit && !this.requestExpire) {
                        break;
                    }
                    if (!this.requestExpire) {
                        try {
                            this.lockObj.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.requestExpire) {
                        timerListener = this.timer.listener;
                        this.requestExpire = false;
                    }
                }
                if (timerListener == null) continue;
                try {
                    timerListener.timerExpired(this.timer);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static class MasterThread
    extends Thread {
        int nextMs;

        private MasterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = masterLock;
            synchronized (object) {
                while (this.nextMs != 0) {
                    try {
                        masterLock.wait(this.nextMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.nextMs = 0;
                    int n = Tick.get();
                    Timer.reschedule(n);
                }
            }
        }
    }
}

