/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.extra.util;

import java.io.PrintStream;
import jp.co.aplix.extra.util.HexUtil;

public final class ReferenceTrace {
    private static final int BUFFSIZE = 4096;

    private ReferenceTrace() {
    }

    public static synchronized native long addReferenceTrace(Object var0);

    public static synchronized boolean checkReferenceTrace(long l, PrintStream printStream) {
        return ReferenceTrace.checkReferenceTrace(l, printStream, null);
    }

    public static synchronized native void removeReferenceTrace(long var0);

    public static synchronized native void removeAllReferenceTrace();

    public static synchronized void checkRegisteredReferenceTrace(PrintStream printStream) {
        long l;
        int n = 0;
        while ((l = ReferenceTrace.nGetNext(n)) != -1L) {
            ReferenceTrace.checkReferenceTrace(l, printStream);
            ++n;
        }
    }

    public static synchronized boolean checkReferenceTrace(long l, PrintStream printStream, String string) {
        int[] nArray = null;
        if (printStream != null) {
            nArray = new int[4096];
        }
        if (ReferenceTrace.nCollected(l)) {
            if (printStream != null) {
                if (string == null) {
                    printStream.println("=== id:0x" + HexUtil.toHexStringUpper(l) + " was collected by GC.");
                } else {
                    printStream.println("=== [" + string + "] id:0x" + HexUtil.toHexStringUpper(l) + " was collected by GC.");
                }
                printStream.println();
            }
            return false;
        }
        boolean bl = ReferenceTrace.nReferenceTrace(l, nArray);
        if (printStream != null) {
            int n = 0;
            try {
                block11: while (true) {
                    int n2;
                    if ((n2 = nArray[n++]) == 0) {
                        if (bl) break;
                        printStream.println("    No one referred this instance.");
                        break;
                    }
                    int n3 = nArray[n++];
                    String string2 = ReferenceTrace.nGetClassName(n2);
                    if (n == 2) {
                        if (string == null) {
                            printStream.println("=== id:0x" + HexUtil.toHexStringUpper(l));
                        } else {
                            printStream.println("=== [" + string + "] id:0x" + HexUtil.toHexStringUpper(l));
                        }
                    }
                    printStream.println(string2 + "(&" + HexUtil.toHexStringUpper(n3) + ")");
                    while (true) {
                        int n4;
                        if (((n4 = nArray[n++]) & 1) == 0) {
                            string2 = ReferenceTrace.nGetClassName(n4);
                            n3 = nArray[n++];
                            printStream.println("    " + string2 + "(&" + HexUtil.toHexStringUpper(n3) + ")");
                            continue;
                        }
                        if (n4 == -1) continue block11;
                        printStream.print("    This is a root object. (");
                        switch (n4) {
                            case 1: {
                                printStream.println("active thread instance)");
                                break;
                            }
                            case 65537: {
                                printStream.println("active thread target)");
                                break;
                            }
                            case 131073: {
                                int n5 = nArray[n++];
                                Thread thread = ReferenceTrace.nToThread(n5);
                                if (thread != null) {
                                    printStream.println("referred from \"" + thread.getName() + "\" thread's stack or local)");
                                    break;
                                }
                                printStream.println("referred from thread's stack or local)");
                                break;
                            }
                            case 196609: {
                                printStream.println("LoadableModule)");
                                break;
                            }
                            case 262145: {
                                printStream.println("referred from Global Memory)");
                                break;
                            }
                            case 327681: {
                                printStream.println("constantpool string)");
                                break;
                            }
                            case 393217: {
                                n2 = nArray[n++];
                                string2 = ReferenceTrace.nGetClassName(n2);
                                printStream.println("referred from " + string2 + "'s class field)");
                                break;
                            }
                            default: {
                                throw new RuntimeException("unexpected value.");
                            }
                        }
                    }
                    break;
                }
                printStream.println();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                printStream.println("\nBecause the reference relationship was complex, the work area was insufficient.");
            }
        }
        return bl;
    }

    private static native boolean nCollected(long var0);

    private static native String nGetClassName(int var0);

    private static native long nGetNext(int var0);

    private static native boolean nReferenceTrace(long var0, int[] var2);

    private static native Thread nToThread(int var0);
}

