/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.extra.util;

import jp.co.aplix.extra.util.Random;

public final class MersenneTwister
extends Random {
    private static final int N = 624;
    private static final int M = 397;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int MATRIX_A = -1727483681;
    private int[] x = new int[624];
    private int p;
    private int q;
    private int r;

    public MersenneTwister(long l) {
        this.setSeed(l);
    }

    public MersenneTwister(int[] nArray) {
        this.setSeed(nArray);
    }

    private synchronized void setSeed(long l) {
        this.x[0] = (int)l;
        for (int i = 1; i < 624; ++i) {
            this.x[i] = 1812433253 * (this.x[i - 1] ^ this.x[i - 1] >>> 30) + i;
        }
        this.p = 0;
        this.q = 1;
        this.r = 397;
    }

    private synchronized void setSeed(int[] nArray) {
        int n;
        this.setSeed(19650218L);
        int n2 = 1;
        int n3 = 0;
        int n4 = nArray.length > 624 ? nArray.length : 624;
        for (n = 0; n < n4; ++n) {
            int n5 = n2;
            this.x[n5] = this.x[n5] ^ (this.x[n2 - 1] ^ this.x[n2 - 1] >>> 30) * 1664525;
            int n6 = n2++;
            this.x[n6] = this.x[n6] + (nArray[n3] + n3);
            if (n2 == 624) {
                this.x[0] = this.x[623];
                n2 = 1;
            }
            if (++n3 != nArray.length) continue;
            n3 = 0;
        }
        for (n = 0; n < 623; ++n) {
            int n7 = n2;
            this.x[n7] = this.x[n7] ^ (this.x[n2 - 1] ^ this.x[n2 - 1] >>> 30) * 1566083941;
            int n8 = n2;
            this.x[n8] = this.x[n8] - n2;
            if (++n2 != 624) continue;
            this.x[0] = this.x[623];
            n2 = 1;
        }
        this.x[0] = Integer.MIN_VALUE;
    }

    @Override
    protected synchronized int next(int n) {
        int n2 = this.x[this.p] & Integer.MIN_VALUE | this.x[this.q] & Integer.MAX_VALUE;
        n2 = this.x[this.p] = this.x[this.r] ^ n2 >>> 1 ^ (n2 & 1) * -1727483681;
        if (++this.p == 624) {
            this.p = 0;
        }
        if (++this.q == 624) {
            this.q = 0;
        }
        if (++this.r == 624) {
            this.r = 0;
        }
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return n2 >>> 32 - n;
    }
}

