/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.extra.util;

import java.util.ArrayList;
import java.util.List;
import jp.co.aplix.avm.Interrupt;

public class InterruptDispatcher {
    private final Interrupt interrupt_ = new Interrupt(true);
    private final int interruptId_ = this.interrupt_.getHandler();
    private final List<InterruptReceiver> eventWaiters_ = new ArrayList<InterruptReceiver>();
    private PollThread pollThread_;
    int nextId_ = Integer.MIN_VALUE;

    public synchronized void register(InterruptReceiver interruptReceiver) {
        this.eventWaiters_.add(interruptReceiver);
        if (this.pollThread_ == null) {
            this.pollThread_ = new PollThread();
            this.pollThread_.start();
        }
    }

    public synchronized int registerAndAssignId(InterruptReceiver interruptReceiver) {
        interruptReceiver.setId(this.nextId_);
        this.register(interruptReceiver);
        this.nextId_ = this.nextId_ == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++this.nextId_;
        return interruptReceiver.getId();
    }

    public int getInterruptId() {
        return this.interruptId_;
    }

    public int getNextId() {
        return this.nextId_;
    }

    public synchronized void remove(InterruptReceiver interruptReceiver) {
        this.eventWaiters_.remove(interruptReceiver);
        if (this.eventWaiters_.isEmpty()) {
            this.pollThread_.interrupt();
            this.pollThread_ = null;
        }
    }

    private class PollThread
    extends Thread {
        private PollThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    long l = InterruptDispatcher.this.interrupt_.waitInputLong();
                    int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    int n2 = (int)(l >>> 32);
                    InterruptDispatcher interruptDispatcher = InterruptDispatcher.this;
                    synchronized (interruptDispatcher) {
                        for (InterruptReceiver interruptReceiver : InterruptDispatcher.this.eventWaiters_) {
                            if (interruptReceiver.getId() != n2) continue;
                            boolean bl = false;
                            try {
                                bl = interruptReceiver.notifyInterrupt(n);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            if (bl) {
                                InterruptDispatcher.this.eventWaiters_.remove(interruptReceiver);
                            }
                            if (!InterruptDispatcher.this.eventWaiters_.isEmpty()) break;
                            InterruptDispatcher.this.pollThread_ = null;
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static abstract class InterruptReceiver {
        private int id_;

        public int getId() {
            return this.id_;
        }

        protected void setId(int n) {
            this.id_ = n;
        }

        protected abstract boolean notifyInterrupt(int var1);
    }
}

