/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.extra.util;

public final class HexUtil {
    private HexUtil() {
    }

    public static boolean compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        return HexUtil.compare(byArray, 0, byArray2, 0, byArray.length);
    }

    public static boolean compare(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("length less than zero.");
        }
        while (n3 != 0) {
            if (byArray[n++] != byArray2[n2++]) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public static void dump(byte[] byArray) {
        HexUtil.dump(byArray, 0, byArray.length);
    }

    public static void dump(byte[] byArray, int n, int n2) {
        int n3;
        char[] cArray = null;
        int n4 = n;
        int n5 = 0;
        while (n5 < n2) {
            n3 = n5 % 16;
            if (n3 == 0) {
                if (cArray == null) {
                    cArray = new char[16];
                } else {
                    System.out.println(": " + new String(cArray));
                }
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = 32;
                }
                System.out.print(HexUtil.toHexStringUpper(n) + ": ");
                n += 16;
            } else if (n3 == 8) {
                System.out.print("- ");
            }
            cArray[n3] = byArray[n4] >= 32 && byArray[n4] < 127 ? (int)byArray[n4] : 46;
            System.out.print(HexUtil.toHexStringUpper(byArray[n4]) + " ");
            ++n5;
            ++n4;
        }
        if (cArray != null) {
            n5 = n2 % 16;
            if (n5 != 0) {
                for (n3 = (16 - n5) * 3 + (n5 < 9 ? 2 : 0); n3 != 0; --n3) {
                    System.out.print(' ');
                }
            }
            System.out.println(": " + new String(cArray));
        }
    }

    public static void dump(int[] nArray) {
        HexUtil.dump(nArray, 0, nArray.length);
    }

    public static void dump(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        char[] cArray = null;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = n4 % 4;
            if (n3 == 0) {
                if (cArray == null) {
                    cArray = new char[16];
                } else {
                    System.out.println(": " + new String(cArray));
                }
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = 32;
                }
                System.out.print(HexUtil.toHexStringUpper(n) + ": ");
                n += 16;
            } else if (n3 == 2) {
                System.out.print("- ");
            }
            cArray[n3 * 4 + 0] = (nArray[n4] >> 24 & 0xFF) >= 32 && (nArray[n4] >> 24 & 0xFF) < 127 ? (int)(nArray[n4] >> 24 & 0xFF) : 46;
            cArray[n3 * 4 + 1] = (nArray[n4] >> 16 & 0xFF) >= 32 && (nArray[n4] >> 16 & 0xFF) < 127 ? (int)(nArray[n4] >> 16 & 0xFF) : 46;
            cArray[n3 * 4 + 2] = (nArray[n4] >> 8 & 0xFF) >= 32 && (nArray[n4] >> 8 & 0xFF) < 127 ? (int)(nArray[n4] >> 8 & 0xFF) : 46;
            cArray[n3 * 4 + 3] = (nArray[n4] >> 0 & 0xFF) >= 32 && (nArray[n4] >> 0 & 0xFF) < 127 ? (int)(nArray[n4] >> 0 & 0xFF) : 46;
            System.out.print(HexUtil.toHexStringUpper(nArray[n4]) + " ");
        }
        if (cArray != null) {
            n4 = n2 % 4;
            if (n4 != 0) {
                for (n3 = (4 - n4) * 9 + (n4 < 3 ? 2 : 0); n3 != 0; --n3) {
                    System.out.print(' ');
                }
            }
            System.out.println(": " + new String(cArray));
        }
    }

    private static char get4b(int n) {
        return (n &= 0xF) < 10 ? (char)(48 + n) : (char)(97 + (n - 10));
    }

    private static char get4bUpper(int n) {
        return (n &= 0xF) < 10 ? (char)(48 + n) : (char)(65 + (n - 10));
    }

    public static String toHexString(byte n) {
        int n2 = n;
        char[] cArray = new char[2];
        for (int i = 1; i >= 0; --i) {
            cArray[i] = HexUtil.get4b(n2);
            n2 >>= 4;
        }
        return new String(cArray);
    }

    public static String toHexStringUpper(byte n) {
        int n2 = n;
        char[] cArray = new char[2];
        for (int i = 1; i >= 0; --i) {
            cArray[i] = HexUtil.get4bUpper(n2);
            n2 >>= 4;
        }
        return new String(cArray);
    }

    public static String toHexString(int n) {
        char[] cArray = new char[8];
        for (int i = 7; i >= 0; --i) {
            cArray[i] = HexUtil.get4b(n);
            n >>= 4;
        }
        return new String(cArray);
    }

    public static String toHexStringUpper(int n) {
        char[] cArray = new char[8];
        for (int i = 7; i >= 0; --i) {
            cArray[i] = HexUtil.get4bUpper(n);
            n >>= 4;
        }
        return new String(cArray);
    }

    public static String toHexString(long l) {
        char[] cArray = new char[16];
        for (int i = 15; i >= 0; --i) {
            cArray[i] = HexUtil.get4b((int)l);
            l >>= 4;
        }
        return new String(cArray);
    }

    public static String toHexStringUpper(long l) {
        char[] cArray = new char[16];
        for (int i = 15; i >= 0; --i) {
            cArray[i] = HexUtil.get4bUpper((int)l);
            l >>= 4;
        }
        return new String(cArray);
    }
}

