/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.avm;

public class Interrupt {
    private static int MAX_EXTSIGNAL_HANDLERS = 16;
    private static int MAX_SYSCLS_EXTSIG_HANDLERS = 4;
    private static int handler_bits = 0;
    private int handler;

    private static native void setInterruptHandler(int var0);

    private static native long waitInterruptLong(int var0);

    private static native void clearInteruptQueue(int var0);

    public Interrupt(int n) {
        if (n < 0 || n >= MAX_EXTSIGNAL_HANDLERS) {
            throw new IllegalArgumentException();
        }
        this.handler = n;
        Interrupt.register(n);
    }

    public Interrupt(boolean bl) {
        this.handler = Interrupt.getNewHandlerAndResister(bl);
    }

    public Interrupt() {
        this.handler = Interrupt.getNewHandlerAndResister(false);
    }

    public int getHandler() {
        return this.handler;
    }

    public int waitInput() throws InterruptedException {
        return (int)Interrupt.waitInterruptLong(this.handler);
    }

    public long waitInputLong() throws InterruptedException {
        return Interrupt.waitInterruptLong(this.handler);
    }

    private static void register(int n) {
        if ((handler_bits & 1 << n) != 0) {
            throw new RuntimeException();
        }
        handler_bits |= 1 << n;
        Interrupt.setInterruptHandler(n);
    }

    private static synchronized int getNewHandlerAndResister(boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = MAX_EXTSIGNAL_HANDLERS;
            n = MAX_EXTSIGNAL_HANDLERS + MAX_SYSCLS_EXTSIG_HANDLERS;
        } else {
            n2 = 0;
            n = MAX_EXTSIGNAL_HANDLERS;
        }
        int n3 = 1 << n2;
        int n4 = n2;
        while (n4 < n) {
            if ((handler_bits & n3) == 0) {
                handler_bits |= n3;
                Interrupt.setInterruptHandler(n4);
                return n4;
            }
            ++n4;
            n3 <<= 1;
        }
        throw new RuntimeException("handler full");
    }

    public void clearQueue() {
        Interrupt.clearInteruptQueue(this.handler);
    }

    public int available() {
        return Interrupt.nAvailable(this.handler);
    }

    private static native int nAvailable(int var0);
}

